/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.coyote.ActionCode;

public class SSLAuthenticator
extends AuthenticatorBase {
    protected static final String info = "org.apache.catalina.authenticator.SSLAuthenticator/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        X509Certificate[] certs;
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            String ssoId;
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            if ((ssoId = (String)request.getNote("org.apache.catalina.request.SSOID")) != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)" Looking up certificates");
        }
        if ((certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate")) == null || certs.length < 1) {
            request.getCoyoteRequest().action(ActionCode.REQ_SSL_CERTIFICATE, null);
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        if (certs == null || certs.length < 1) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"  No certificates included with this request");
            }
            response.sendError(401, sm.getString("authenticator.certificates"));
            return false;
        }
        principal = this.context.getRealm().authenticate(certs);
        if (principal == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"  Realm.authenticate() returned false");
            }
            response.sendError(401, sm.getString("authenticator.unauthorized"));
            return false;
        }
        this.register(request, response, principal, "CLIENT_CERT", null, null);
        return true;
    }

    @Override
    protected String getAuthMethod() {
        return "CLIENT_CERT";
    }
}

