/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.web.util;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.reflect.ClassUtil;
import org.apache.tiles.request.servlet.ServletUtil;
import org.apache.tiles.web.util.AttributeContextMutator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesDispatchServlet
extends HttpServlet {
    public static final String CONTAINER_KEY_INIT_PARAMETER = "org.apache.tiles.web.util.TilesDispatchServlet.CONTAINER_KEY";
    private final Logger log = LoggerFactory.getLogger(TilesDispatchServlet.class);
    private String containerKey;
    private AttributeContextMutator mutator;

    public void init() throws ServletException {
        super.init();
        this.containerKey = this.getServletConfig().getInitParameter(CONTAINER_KEY_INIT_PARAMETER);
        String temp = this.getInitParameter("mutator");
        if (temp != null) {
            try {
                this.mutator = (AttributeContextMutator)ClassUtil.instantiate((String)temp);
            }
            catch (Exception e) {
                throw new ServletException("Unable to instantiate specified context mutator.", (Throwable)e);
            }
        } else {
            this.mutator = new DefaultMutator();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        ApplicationContext applicationContext = ServletUtil.getApplicationContext((ServletContext)this.getServletContext());
        org.apache.tiles.request.servlet.ServletRequest request = new org.apache.tiles.request.servlet.ServletRequest(applicationContext, req, res);
        TilesContainer container = TilesAccess.getContainer((ApplicationContext)applicationContext, (String)this.containerKey);
        this.mutator.mutate(container.getAttributeContext((Request)request), (ServletRequest)req);
        String definition = this.getDefinitionName(req);
        if (this.log.isDebugEnabled()) {
            this.log.info("Dispatching to tile '" + definition + "'");
        }
        container.render(definition, (Request)request);
    }

    protected String getDefinitionName(HttpServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (path == null) {
            path = request.getServletPath();
        }
        int start = path.startsWith("/") ? 1 : 0;
        int end = path.endsWith(".tiles") ? path.indexOf(".tiles") : path.length();
        return path.substring(start, end);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        this.log.info("Tiles dispatch request received. Redirecting POST to GET.");
        this.doGet(req, res);
    }

    class DefaultMutator
    implements AttributeContextMutator {
        DefaultMutator() {
        }

        @Override
        public void mutate(AttributeContext context, ServletRequest request) {
        }
    }
}

