/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib.definition;

import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.ListAttribute;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.jsp.context.JspUtil;
import org.apache.tiles.jsp.taglib.PutAttributeTag;
import org.apache.tiles.jsp.taglib.PutAttributeTagParent;
import org.apache.tiles.jsp.taglib.PutListAttributeTag;
import org.apache.tiles.jsp.taglib.PutListAttributeTagParent;
import org.apache.tiles.jsp.taglib.TilesJspException;
import org.apache.tiles.jsp.taglib.definition.DefinitionTagParent;
import org.apache.tiles.mgmt.MutableTilesContainer;

public class DefinitionTag
extends TagSupport
implements PutAttributeTagParent,
PutListAttributeTagParent {
    private String name;
    private String template;
    private String extend;
    private String role;
    private String preparer;
    private MutableTilesContainer container;
    private Definition definition;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getExtends() {
        return this.extend;
    }

    public void setExtends(String extend) {
        this.extend = extend;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getPreparer() {
        return this.preparer;
    }

    public void setPreparer(String preparer) {
        this.preparer = preparer;
    }

    public void release() {
        super.release();
        this.name = null;
        this.template = null;
        this.extend = null;
        this.role = null;
        this.preparer = null;
        this.definition = null;
    }

    public int doStartTag() throws TilesJspException {
        this.definition = new Definition();
        this.definition.setName(this.name);
        this.definition.setTemplate(this.template);
        this.definition.setExtends(this.extend);
        this.definition.setRole(this.role);
        this.definition.setPreparer(this.preparer);
        TilesContainer c = JspUtil.getCurrentContainer(this.pageContext);
        if (c == null) {
            throw new TilesJspException("TilesContainer not initialized");
        }
        if (!(c instanceof MutableTilesContainer)) {
            throw new TilesJspException("Unable to define definition for a container which does not implement MutableTilesContainer");
        }
        this.container = (MutableTilesContainer)c;
        return 1;
    }

    public int doEndTag() throws TilesJspException {
        this.container.register(this.definition, new Object[]{this.pageContext});
        this.callParent();
        return 6;
    }

    public void processNestedTag(PutAttributeTag nestedTag) throws TilesJspException {
        Attribute attr = new Attribute(nestedTag.getValue(), nestedTag.getRole(), nestedTag.getType());
        this.definition.putAttribute(nestedTag.getName(), attr, nestedTag.isCascade());
    }

    public void processNestedTag(PutListAttributeTag nestedTag) {
        ListAttribute attribute = new ListAttribute(nestedTag.getAttributes());
        attribute.setRole(nestedTag.getRole());
        attribute.setInherit(nestedTag.getInherit());
        this.definition.putAttribute(nestedTag.getName(), (Attribute)attribute, nestedTag.isCascade());
    }

    protected void callParent() throws TilesJspException {
        DefinitionTagParent enclosingParent = this.findEnclosingDefinitionTagParent();
        if (enclosingParent != null) {
            enclosingParent.processNestedDefinitionName(this.definition.getName());
        }
    }

    protected DefinitionTagParent findEnclosingDefinitionTagParent() throws TilesJspException {
        try {
            DefinitionTagParent parent = (DefinitionTagParent)DefinitionTag.findAncestorWithClass((Tag)this, DefinitionTagParent.class);
            if (parent == null && this.name == null) {
                throw new TilesJspException("Error - tag definition : enclosing tag doesn't accept 'definition' tag and a name was not specified.");
            }
            return parent;
        }
        catch (ClassCastException ex) {
            throw new TilesJspException("Error - tag definition : enclosing tag doesn't accept 'definition' tag.", ex);
        }
    }
}

