/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.freemarker.context;

import freemarker.core.Environment;
import freemarker.ext.servlet.HttpRequestHashModel;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.freemarker.FreeMarkerTilesException;
import org.apache.tiles.freemarker.context.FreeMarkerTilesRequestContext;
import org.apache.tiles.freemarker.context.FreeMarkerUtil;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMarkerTilesRequestContextFactory
implements TilesRequestContextFactory,
TilesRequestContextFactoryAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private TilesRequestContextFactory parent;

    public void setRequestContextFactory(TilesRequestContextFactory contextFactory) {
        this.parent = contextFactory;
    }

    public TilesRequestContext createRequestContext(TilesApplicationContext context, Object ... requestItems) {
        if (requestItems.length == 1 && requestItems[0] instanceof Environment) {
            HttpRequestHashModel requestModel;
            Environment env = (Environment)requestItems[0];
            try {
                requestModel = FreeMarkerUtil.getRequestHashModel(env);
            }
            catch (FreeMarkerTilesException e) {
                this.log.warn("Cannot evaluate as a FreeMarker in Servlet Environment, skipping", (Throwable)((Object)e));
                return null;
            }
            HttpServletRequest request = requestModel.getRequest();
            HttpServletResponse response = requestModel.getResponse();
            Object enclosedRequest = this.parent != null ? this.parent.createRequestContext(context, new Object[]{request, response}) : new ServletTilesRequestContext(context, request, response);
            return new FreeMarkerTilesRequestContext((TilesRequestContext)enclosedRequest, env);
        }
        return null;
    }

    public void init(Map<String, String> configurationParameters) {
    }
}

