/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.freemarker.renderer;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.freemarker.FreeMarkerTilesException;
import org.apache.tiles.freemarker.servlet.TilesFreemarkerServlet;
import org.apache.tiles.impl.InvalidTemplateException;
import org.apache.tiles.renderer.impl.AbstractTypeDetectingAttributeRenderer;
import org.apache.tiles.servlet.context.ExternalWriterHttpServletResponse;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.tiles.util.IteratorEnumeration;

public class FreeMarkerAttributeRenderer
extends AbstractTypeDetectingAttributeRenderer {
    private AttributeValueFreemarkerServlet servlet;
    private Map<String, String> params = new HashMap<String, String>();

    public void setParameter(String key, String value) {
        this.params.put(key, value);
    }

    public void commit() {
        this.servlet = new AttributeValueFreemarkerServlet();
        try {
            this.servlet.init(new InitParamsServletConfig());
        }
        catch (ServletException e) {
            throw new FreeMarkerTilesException("Cannot initialize internal servlet", (Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Object value, Attribute attribute, TilesRequestContext request) throws IOException {
        if (value == null) throw new InvalidTemplateException("Cannot render a null template");
        if (!(value instanceof String)) throw new InvalidTemplateException("Cannot render a template that is not a string: " + value.toString());
        ServletTilesRequestContext servletRequest = ServletUtil.getServletRequest((TilesRequestContext)request);
        HttpServletRequest httpRequest = servletRequest.getRequest();
        HttpServletResponse httpResponse = servletRequest.getResponse();
        this.servlet.setValue((String)value);
        try {
            this.servlet.doGet(httpRequest, (HttpServletResponse)new ExternalWriterHttpServletResponse(httpResponse, request.getPrintWriter()));
            return;
        }
        catch (ServletException e) {
            throw new FreeMarkerTilesException("Exception when rendering a FreeMarker attribute", (Exception)((Object)e));
        }
    }

    public boolean isRenderable(Object value, Attribute attribute, TilesRequestContext request) {
        if (value instanceof String) {
            String string = (String)value;
            return string.startsWith("/") && string.endsWith(".ftl");
        }
        return false;
    }

    private class InitParamsServletConfig
    implements ServletConfig {
        private InitParamsServletConfig() {
        }

        public String getInitParameter(String name) {
            return (String)FreeMarkerAttributeRenderer.this.params.get(name);
        }

        public Enumeration getInitParameterNames() {
            return new IteratorEnumeration(FreeMarkerAttributeRenderer.this.params.keySet().iterator());
        }

        public ServletContext getServletContext() {
            return ServletUtil.getServletContext((TilesApplicationContext)FreeMarkerAttributeRenderer.this.applicationContext);
        }

        public String getServletName() {
            return "FreeMarker Attribute Renderer";
        }
    }

    private static class AttributeValueFreemarkerServlet
    extends TilesFreemarkerServlet {
        private ThreadLocal<String> valueHolder = new ThreadLocal();

        private AttributeValueFreemarkerServlet() {
        }

        public void setValue(String value) {
            this.valueHolder.set(value);
        }

        protected String requestUrlToTemplatePath(HttpServletRequest request) {
            return this.valueHolder.get();
        }
    }
}

