/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tiles.Definition;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.definition.Definitions;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.RefreshMonitor;
import org.apache.tiles.definition.Refreshable;
import org.apache.tiles.definition.UnresolvingLocaleDefinitionsFactory;
import org.apache.tiles.definition.dao.DefinitionDAO;
import org.apache.tiles.definition.dao.ResolvingLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.dao.URLReader;
import org.apache.tiles.util.LocaleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlDefinitionsFactory
extends UnresolvingLocaleDefinitionsFactory
implements Refreshable {
    private static final String LEGACY_DEFINITIONS_CONFIG = "definitions-config";
    private final Logger log = LoggerFactory.getLogger(UrlDefinitionsFactory.class);
    protected List<Object> sources;
    protected DefinitionsReader reader;
    protected Map<String, Long> lastModifiedDates;

    @Override
    public synchronized void refresh() {
        this.log.debug("Updating Tiles definitions. . .");
        if (this.definitionDao instanceof Refreshable) {
            ((Refreshable)((Object)this.definitionDao)).refresh();
        }
    }

    @Override
    public boolean refreshRequired() {
        return this.definitionDao instanceof RefreshMonitor && ((RefreshMonitor)((Object)this.definitionDao)).refreshRequired();
    }

    @Deprecated
    protected boolean isContextProcessed(TilesRequestContext tilesContext) {
        return true;
    }

    @Override
    public void addSource(Object source) {
        if (source == null) {
            throw new DefinitionsFactoryException("Source object must not be null");
        }
        if (!(source instanceof URL)) {
            throw new DefinitionsFactoryException("Source object must be an URL");
        }
        if (this.definitionDao instanceof URLReader) {
            ((URLReader)((Object)this.definitionDao)).addSourceURL((URL)source);
        }
    }

    protected DefinitionDAO<Locale> createDefaultDefinitionDAO() {
        return new ResolvingLocaleUrlDefinitionDAO();
    }

    @Override
    @Deprecated
    public Definitions readDefinitions() {
        return new CompatibilityDefinitionsImpl(this.definitionDao);
    }

    @Deprecated
    protected Definitions getDefinitions() {
        return new CompatibilityDefinitionsImpl(this.definitionDao);
    }

    @Deprecated
    protected void addDefinitions(Definitions definitions, TilesRequestContext tilesContext) {
        Locale locale = this.localeResolver.resolveLocale(tilesContext);
        Map<String, Definition> defsMap = this.definitionDao.getDefinitions(locale);
        if (defsMap == null) {
            throw new NullPointerException("There are no definitions mapped to locale '" + locale.toString() + "'");
        }
    }

    @Deprecated
    protected Definitions createDefinitions() {
        return new CompatibilityDefinitionsImpl(this.definitionDao);
    }

    protected static String concatPostfix(String name, String postfix) {
        return LocaleUtil.concatPostfix(name, postfix);
    }

    protected static List<String> calculatePostfixes(Locale locale) {
        return LocaleUtil.calculatePostfixes(locale);
    }

    @Deprecated
    protected String getResourceString(Map<String, String> parms) {
        String resourceStr = parms.get("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG");
        if (resourceStr == null) {
            resourceStr = parms.get("org.apache.tiles.impl.BasicTilesContainer.DEFINITIONS_CONFIG");
        }
        if (resourceStr == null) {
            resourceStr = parms.get(LEGACY_DEFINITIONS_CONFIG);
        }
        if (resourceStr == null) {
            resourceStr = "/WEB-INF/tiles.xml";
        }
        return resourceStr;
    }

    @Deprecated
    protected List<String> getResourceNames(String resourceString) {
        StringTokenizer tokenizer = new StringTokenizer(resourceString, ",");
        ArrayList<String> filenames = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            filenames.add(tokenizer.nextToken().trim());
        }
        return filenames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    private static final class CompatibilityDefinitionsImpl
    implements Definitions {
        private DefinitionDAO<Locale> definitionDao;

        public CompatibilityDefinitionsImpl(DefinitionDAO<Locale> definitionDao) {
            this.definitionDao = definitionDao;
        }

        @Override
        public void addDefinitions(Map<String, Definition> defsMap) {
            Map<String, Definition> definitions = this.definitionDao.getDefinitions(null);
            if (definitions == null) {
                throw new NullPointerException("No definitions loaded for default locale");
            }
            definitions.putAll(defsMap);
        }

        @Override
        public void addDefinitions(Map<String, Definition> defsMap, Locale locale) {
            Map<String, Definition> definitions = this.definitionDao.getDefinitions(locale);
            if (definitions == null) {
                throw new NullPointerException("No definitions loaded for locale '" + locale.toString() + "'");
            }
            definitions.putAll(defsMap);
        }

        @Override
        public Map<String, Definition> getBaseDefinitions() {
            return this.definitionDao.getDefinitions(null);
        }

        @Override
        public Definition getDefinition(String name) {
            return this.definitionDao.getDefinition(name, null);
        }

        @Override
        public Definition getDefinition(String name, Locale locale) {
            return this.definitionDao.getDefinition(name, locale);
        }

        @Override
        public void reset() {
            if (this.definitionDao instanceof Refreshable) {
                ((Refreshable)((Object)this.definitionDao)).refresh();
            }
        }

        @Override
        public void resolveInheritances() {
        }

        @Override
        public void resolveInheritances(Locale locale) {
        }
    }
}

