/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.util;

import org.apache.tiles.reflect.CannotInstantiateObjectException;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static Object instantiate(String className) {
        return ClassUtil.instantiate(className, false);
    }

    public static Object instantiate(String className, boolean returnNull) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (original == null) {
            Thread.currentThread().setContextClassLoader(ClassUtil.class.getClassLoader());
        }
        try {
            Class<?> namedClass = Class.forName(className);
            Object obj = namedClass.newInstance();
            return obj;
        }
        catch (ClassNotFoundException e) {
            if (returnNull) {
                Object var4_8 = null;
                return var4_8;
            }
            throw new CannotInstantiateObjectException("Unable to resolve factory class: '" + className + "'", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new CannotInstantiateObjectException("Unable to access factory class: '" + className + "'", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new CannotInstantiateObjectException("Unable to instantiate factory class: '" + className + "'. Make sure that this class has a default constructor", (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

