/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.awareness.TilesContextFactoryAware;
import org.apache.tiles.context.TilesContextFactory;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorAware;
import org.apache.tiles.renderer.AttributeRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseAttributeRenderer
implements AttributeRenderer,
TilesContextFactoryAware,
TilesApplicationContextAware,
AttributeEvaluatorAware {
    private static final Log LOG = LogFactory.getLog(AbstractBaseAttributeRenderer.class);
    protected TilesContextFactory contextFactory;
    protected TilesApplicationContext applicationContext;
    protected AttributeEvaluator evaluator;

    @Override
    public void setContextFactory(TilesContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public void setApplicationContext(TilesApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setEvaluator(AttributeEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public void render(Attribute attribute, Writer writer, Object ... requestItems) throws IOException {
        TilesRequestContext request = this.getRequestContext(requestItems);
        if (!this.isPermitted(request, attribute.getRoles())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Access to attribute denied.  User not in role '" + attribute.getRoles() + "'"));
            }
            return;
        }
        Object value = this.evaluator.evaluate(attribute, request);
        this.write(value, attribute, writer, request, requestItems);
    }

    public abstract void write(Object var1, Attribute var2, Writer var3, TilesRequestContext var4, Object ... var5) throws IOException;

    protected TilesRequestContext getRequestContext(Object ... requestItems) {
        return this.contextFactory.createRequestContext(this.applicationContext, requestItems);
    }

    protected boolean isPermitted(TilesRequestContext request, Set<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return true;
        }
        boolean retValue = false;
        Iterator<String> roleIt = roles.iterator();
        while (roleIt.hasNext() && !retValue) {
            retValue = request.isUserInRole(roleIt.next());
        }
        return retValue;
    }
}

