/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.impl.mgmt;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.BasicAttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.NoSuchDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionManager {
    private static final Log LOG = LogFactory.getLog(DefinitionManager.class);
    private static final String DEFAULT_DEFINITIONS_ATTRIBUTE_NAME = "org.apache.tiles.impl.mgmt.DefinitionManager.DEFINITIONS";
    private DefinitionsFactory factory;
    private String definitionsAttributeName;

    public DefinitionManager() {
        this.definitionsAttributeName = DEFAULT_DEFINITIONS_ATTRIBUTE_NAME;
    }

    public DefinitionManager(String definitionsAttributeName) {
        this.definitionsAttributeName = definitionsAttributeName;
        if (this.definitionsAttributeName == null) {
            this.definitionsAttributeName = DEFAULT_DEFINITIONS_ATTRIBUTE_NAME;
        }
    }

    public DefinitionsFactory getFactory() {
        return this.factory;
    }

    public void setFactory(DefinitionsFactory factory) {
        this.factory = factory;
    }

    public Definition getDefinition(String definition, TilesRequestContext request) {
        Map<String, Definition> definitions = this.getDefinitions(request);
        if (definitions != null && definitions.containsKey(definition)) {
            return definitions.get(definition);
        }
        return this.getFactory().getDefinition(definition, request);
    }

    public void addDefinition(Definition definition, TilesRequestContext request) {
        Map<String, Definition> definitions = this.getOrCreateDefinitions(request);
        if (definition.getName() == null) {
            definition.setName(this.getNextUniqueDefinitionName(definitions));
        }
        this.validate(definition);
        if (definition.isExtending()) {
            this.resolveInheritance(definition, request);
        }
        definitions.put(definition.getName(), definition);
    }

    private void validate(Definition definition) {
        Attribute attribute;
        Set names = definition.getLocalAttributeNames();
        if (names != null) {
            for (String name : names) {
                attribute = definition.getLocalAttribute(name);
                if (attribute.getValue() != null) continue;
                throw new IllegalArgumentException("Attribute '" + name + "' value not defined");
            }
        }
        if ((names = definition.getCascadedAttributeNames()) != null) {
            for (String name : names) {
                attribute = definition.getCascadedAttribute(name);
                if (attribute.getValue() != null) continue;
                throw new IllegalArgumentException("Attribute '" + name + "' value not defined");
            }
        }
    }

    protected void resolveInheritance(Definition definition, TilesRequestContext request) {
        Definition parent;
        if (!definition.isExtending()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolve definition for child name='" + definition.getName() + "' extends='" + definition.getExtends() + "'."));
        }
        if ((parent = this.getDefinition(definition.getExtends(), request)) == null) {
            String msg = "Error while resolving definition inheritance: child '" + definition.getName() + "' can't find its ancestor '" + definition.getExtends() + "'. Please check your description file.";
            LOG.error((Object)msg);
            throw new NoSuchDefinitionException(msg);
        }
        this.resolveInheritance(parent, request);
        definition.inherit((BasicAttributeContext)parent);
    }

    protected void overload(Definition parent, Definition child) {
        child.inherit((BasicAttributeContext)parent);
    }

    protected Map<String, Definition> getDefinitions(TilesRequestContext request) {
        return (Map)request.getRequestScope().get(this.definitionsAttributeName);
    }

    protected Map<String, Definition> getOrCreateDefinitions(TilesRequestContext request) {
        HashMap definitions = (HashMap)request.getRequestScope().get(this.definitionsAttributeName);
        if (definitions == null) {
            definitions = new HashMap();
            request.getRequestScope().put(this.definitionsAttributeName, definitions);
        }
        return definitions;
    }

    protected String getNextUniqueDefinitionName(Map<String, Definition> definitions) {
        String candidate;
        int anonymousDefinitionIndex = 1;
        do {
            candidate = "$anonymousMutableDefinition" + anonymousDefinitionIndex;
            ++anonymousDefinitionIndex;
        } while (definitions.containsKey(candidate));
        return candidate;
    }
}

