/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.factory;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.awareness.TilesContainerAware;
import org.apache.tiles.awareness.TilesContextFactoryAware;
import org.apache.tiles.context.ChainedTilesContextFactory;
import org.apache.tiles.context.TilesContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.UrlDefinitionsFactory;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorAware;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.mgmt.MutableTilesContainer;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.reflect.ClassUtil;
import org.apache.tiles.renderer.RendererFactory;
import org.apache.tiles.renderer.impl.BasicRendererFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesContainerFactory
extends AbstractTilesContainerFactory {
    public static final String CONTAINER_FACTORY_INIT_PARAM = "org.apache.tiles.factory.TilesContainerFactory";
    public static final String CONTAINER_FACTORY_MUTABLE_INIT_PARAM = "org.apache.tiles.factory.TilesContainerFactory.MUTABLE";
    public static final String CONTEXT_FACTORY_INIT_PARAM = "org.apache.tiles.context.TilesContextFactory";
    public static final String DEFINITIONS_FACTORY_INIT_PARAM = "org.apache.tiles.definition.DefinitionsFactory";
    public static final String PREPARER_FACTORY_INIT_PARAM = "org.apache.tiles.preparer.PreparerFactory";
    public static final String RENDERER_FACTORY_INIT_PARAM = "org.apache.tiles.renderer.RendererFactory";
    public static final String ATTRIBUTE_EVALUATOR_INIT_PARAM = "org.apache.tiles.evaluator.AttributeEvaluator";
    private static final Log LOG = LogFactory.getLog(TilesContainerFactory.class);
    private static final Map<String, String> DEFAULTS = new HashMap<String, String>();
    protected Map<String, String> defaultConfiguration = new HashMap<String, String>(DEFAULTS);

    @Deprecated
    public static TilesContainerFactory getFactory(Object context) {
        return TilesContainerFactory.getFactory(context, DEFAULTS);
    }

    public static TilesContainerFactory getFactory(Object context, Map<String, String> defaults) {
        HashMap<String, String> configuration = new HashMap<String, String>(defaults);
        configuration.putAll(TilesContainerFactory.getInitParameterMap(context));
        TilesContainerFactory factory = (TilesContainerFactory)TilesContainerFactory.createFactory(configuration, CONTAINER_FACTORY_INIT_PARAM);
        factory.setDefaultConfiguration(defaults);
        return factory;
    }

    @Override
    public TilesContainer createContainer(Object context) {
        String value = TilesContainerFactory.getInitParameter(context, CONTAINER_FACTORY_MUTABLE_INIT_PARAM);
        if (Boolean.parseBoolean(value)) {
            return this.createMutableTilesContainer(context);
        }
        return this.createTilesContainer(context);
    }

    public void setDefaultConfiguration(Map<String, String> defaultConfiguration) {
        if (defaultConfiguration != null) {
            this.defaultConfiguration.putAll(defaultConfiguration);
        }
    }

    public void setDefaultValue(String key, String value) {
        this.defaultConfiguration.put(key, value);
    }

    public TilesContainer createTilesContainer(Object context) {
        BasicTilesContainer container = new BasicTilesContainer();
        this.initializeContainer(context, container);
        return container;
    }

    public MutableTilesContainer createMutableTilesContainer(Object context) {
        CachingTilesContainer container = new CachingTilesContainer();
        this.initializeContainer(context, container);
        return container;
    }

    protected void initializeContainer(Object context, BasicTilesContainer container) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Initializing Tiles2 container. . .");
        }
        Map<String, String> initParameterMap = TilesContainerFactory.getInitParameterMap(context);
        HashMap<String, String> configuration = new HashMap<String, String>(this.defaultConfiguration);
        configuration.putAll(initParameterMap);
        this.storeContainerDependencies(context, initParameterMap, configuration, container);
        container.init(initParameterMap);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Tiles2 container initialized");
        }
    }

    protected void storeContainerDependencies(Object context, Map<String, String> initParameters, Map<String, String> configuration, BasicTilesContainer container) {
        TilesContextFactory contextFactory = (TilesContextFactory)TilesContainerFactory.createFactory(configuration, CONTEXT_FACTORY_INIT_PARAM);
        contextFactory.init(configuration);
        TilesApplicationContext tilesContext = contextFactory.createApplicationContext(context);
        RendererFactory rendererFactory = (RendererFactory)TilesContainerFactory.createFactory(configuration, RENDERER_FACTORY_INIT_PARAM);
        AttributeEvaluator evaluator = (AttributeEvaluator)TilesContainerFactory.createFactory(configuration, ATTRIBUTE_EVALUATOR_INIT_PARAM);
        if (evaluator instanceof TilesContextFactoryAware) {
            ((TilesContextFactoryAware)((Object)evaluator)).setContextFactory(contextFactory);
        }
        if (evaluator instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)evaluator)).setApplicationContext(tilesContext);
        }
        if (evaluator instanceof TilesContainerAware) {
            ((TilesContainerAware)((Object)evaluator)).setContainer(container);
        }
        evaluator.init(configuration);
        if (rendererFactory instanceof TilesContextFactoryAware) {
            ((TilesContextFactoryAware)((Object)rendererFactory)).setContextFactory(contextFactory);
        }
        if (rendererFactory instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)rendererFactory)).setApplicationContext(tilesContext);
        }
        if (rendererFactory instanceof TilesContainerAware) {
            ((TilesContainerAware)((Object)rendererFactory)).setContainer(container);
        }
        if (rendererFactory instanceof AttributeEvaluatorAware) {
            ((AttributeEvaluatorAware)((Object)rendererFactory)).setEvaluator(evaluator);
        }
        rendererFactory.init(initParameters);
        PreparerFactory prepFactory = (PreparerFactory)TilesContainerFactory.createFactory(configuration, PREPARER_FACTORY_INIT_PARAM);
        this.postCreationOperations(contextFactory, tilesContext, rendererFactory, evaluator, initParameters, configuration, container);
        container.setContextFactory(contextFactory);
        container.setPreparerFactory(prepFactory);
        container.setApplicationContext(tilesContext);
        container.setRendererFactory(rendererFactory);
        container.setEvaluator(evaluator);
    }

    protected void postCreationOperations(TilesContextFactory contextFactory, TilesApplicationContext tilesContext, RendererFactory rendererFactory, AttributeEvaluator evaluator, Map<String, String> initParameters, Map<String, String> configuration, BasicTilesContainer container) {
        DefinitionsFactory defsFactory = (DefinitionsFactory)TilesContainerFactory.createFactory(configuration, DEFINITIONS_FACTORY_INIT_PARAM);
        if (defsFactory instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)defsFactory)).setApplicationContext(tilesContext);
        }
        defsFactory.init(configuration);
        container.setDefinitionsFactory(defsFactory);
    }

    protected static Object createFactory(Map<String, String> configuration, String initParameterName) {
        String factoryName = TilesContainerFactory.resolveFactoryName(configuration, initParameterName);
        return ClassUtil.instantiate((String)factoryName);
    }

    protected static String resolveFactoryName(Map<String, String> configuration, String parameterName) {
        String factoryName = configuration.get(parameterName);
        return factoryName == null ? DEFAULTS.get(parameterName) : factoryName.toString();
    }

    static {
        DEFAULTS.put(CONTEXT_FACTORY_INIT_PARAM, ChainedTilesContextFactory.class.getName());
        DEFAULTS.put(DEFINITIONS_FACTORY_INIT_PARAM, UrlDefinitionsFactory.class.getName());
        DEFAULTS.put(PREPARER_FACTORY_INIT_PARAM, BasicPreparerFactory.class.getName());
        DEFAULTS.put(RENDERER_FACTORY_INIT_PARAM, BasicRendererFactory.class.getName());
        DEFAULTS.put(ATTRIBUTE_EVALUATOR_INIT_PARAM, DirectAttributeEvaluator.class.getName());
    }
}

