/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.factory;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.context.ChainedTilesContextFactory;
import org.apache.tiles.context.TilesContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.LocaleDefinitionsFactory;
import org.apache.tiles.definition.Refreshable;
import org.apache.tiles.definition.UrlDefinitionsFactory;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.dao.DefinitionDAO;
import org.apache.tiles.definition.dao.ResolvingLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.factory.TilesContainerFactoryException;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.locale.impl.DefaultLocaleResolver;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.renderer.AttributeRenderer;
import org.apache.tiles.renderer.RendererFactory;
import org.apache.tiles.renderer.impl.BasicRendererFactory;
import org.apache.tiles.renderer.impl.DefinitionAttributeRenderer;
import org.apache.tiles.renderer.impl.StringAttributeRenderer;
import org.apache.tiles.renderer.impl.TemplateAttributeRenderer;
import org.apache.tiles.renderer.impl.UntypedAttributeRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTilesContainerFactory
extends AbstractTilesContainerFactory {
    private static final int CONTEXT_FACTORY_CHAIN_COUNT = 3;
    private static final Log LOG = LogFactory.getLog(BasicTilesContainerFactory.class);

    @Override
    public TilesContainer createContainer(Object context) {
        BasicTilesContainer container = this.instantiateContainer(context);
        TilesContextFactory contextFactory = this.createContextFactory(context);
        TilesApplicationContext applicationContext = contextFactory.createApplicationContext(context);
        container.setContextFactory(contextFactory);
        container.setApplicationContext(applicationContext);
        LocaleResolver resolver = this.createLocaleResolver(context, applicationContext, contextFactory);
        container.setDefinitionsFactory(this.createDefinitionsFactory(context, applicationContext, contextFactory, resolver));
        AttributeEvaluator evaluator = this.createEvaluator(context, applicationContext, contextFactory, resolver);
        container.setEvaluator(evaluator);
        container.setPreparerFactory(this.createPreparerFactory(context, applicationContext, contextFactory));
        container.setRendererFactory(this.createRendererFactory(context, applicationContext, contextFactory, container, evaluator));
        return container;
    }

    protected BasicTilesContainer instantiateContainer(Object context) {
        return new BasicTilesContainer();
    }

    protected TilesContextFactory createContextFactory(Object context) {
        ChainedTilesContextFactory contextFactory = new ChainedTilesContextFactory();
        this.registerChainedContextFactories(context, contextFactory);
        return contextFactory;
    }

    protected void registerChainedContextFactories(Object context, ChainedTilesContextFactory contextFactory) {
        ArrayList<TilesContextFactory> factories = new ArrayList<TilesContextFactory>(3);
        this.registerContextFactory("org.apache.tiles.servlet.context.ServletTilesContextFactory", factories);
        this.registerContextFactory("org.apache.tiles.portlet.context.PortletTilesContextFactory", factories);
        this.registerContextFactory("org.apache.tiles.jsp.context.JspTilesContextFactory", factories);
        contextFactory.setFactories(factories);
    }

    protected void registerContextFactory(String className, List<TilesContextFactory> factories) {
        TilesContextFactory retValue = null;
        try {
            Class<TilesContextFactory> clazz = Class.forName(className).asSubclass(TilesContextFactory.class);
            retValue = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cannot find JspTilesContextFactory, ignoring problem", (Throwable)e);
            }
        }
        catch (InstantiationException e) {
            throw new TilesContainerFactoryException("Cannot instantiate JspTilesContextFactory", e);
        }
        catch (IllegalAccessException e) {
            throw new TilesContainerFactoryException("Cannot access default constructor JspTilesContextFactory", e);
        }
        if (retValue != null) {
            factories.add(retValue);
        }
    }

    protected DefinitionsFactory createDefinitionsFactory(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory, LocaleResolver resolver) {
        LocaleDefinitionsFactory factory = this.instantiateDefinitionsFactory(context, applicationContext, contextFactory, resolver);
        factory.setApplicationContext(applicationContext);
        factory.setLocaleResolver(resolver);
        factory.setDefinitionDAO(this.createLocaleDefinitionDao(context, applicationContext, contextFactory, resolver));
        if (factory instanceof Refreshable) {
            ((Refreshable)((Object)factory)).refresh();
        }
        return factory;
    }

    protected LocaleDefinitionsFactory instantiateDefinitionsFactory(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory, LocaleResolver resolver) {
        return new UrlDefinitionsFactory();
    }

    protected BaseLocaleUrlDefinitionDAO instantiateLocaleDefinitionDao(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory, LocaleResolver resolver) {
        return new ResolvingLocaleUrlDefinitionDAO();
    }

    protected DefinitionDAO<Locale> createLocaleDefinitionDao(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory, LocaleResolver resolver) {
        BaseLocaleUrlDefinitionDAO definitionDao = this.instantiateLocaleDefinitionDao(context, applicationContext, contextFactory, resolver);
        definitionDao.setReader(this.createDefinitionsReader(context, applicationContext, contextFactory));
        definitionDao.setSourceURLs(this.getSourceURLs(context, applicationContext, contextFactory));
        definitionDao.setApplicationContext(applicationContext);
        return definitionDao;
    }

    protected LocaleResolver createLocaleResolver(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory) {
        return new DefaultLocaleResolver();
    }

    protected DefinitionsReader createDefinitionsReader(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory) {
        return new DigesterDefinitionsReader();
    }

    protected List<URL> getSourceURLs(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory) {
        ArrayList<URL> retValue = new ArrayList<URL>(1);
        try {
            retValue.add(applicationContext.getResource("/WEB-INF/tiles.xml"));
        }
        catch (IOException e) {
            throw new TilesContainerFactoryException("Cannot get URL: /WEB-INF/tiles.xml", e);
        }
        return retValue;
    }

    protected AttributeEvaluator createEvaluator(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory, LocaleResolver resolver) {
        return new DirectAttributeEvaluator();
    }

    protected PreparerFactory createPreparerFactory(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory) {
        return new BasicPreparerFactory();
    }

    protected RendererFactory createRendererFactory(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory, TilesContainer container, AttributeEvaluator evaluator) {
        BasicRendererFactory retValue = new BasicRendererFactory();
        retValue.setApplicationContext(applicationContext);
        retValue.setContextFactory(contextFactory);
        retValue.setContainer(container);
        retValue.setEvaluator(evaluator);
        retValue.setDefaultRenderer(this.createDefaultAttributeRenderer(context, applicationContext, contextFactory, container, evaluator));
        this.registerAttributeRenderers(retValue, context, applicationContext, contextFactory, container, evaluator);
        return retValue;
    }

    protected AttributeRenderer createDefaultAttributeRenderer(Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory, TilesContainer container, AttributeEvaluator evaluator) {
        UntypedAttributeRenderer retValue = new UntypedAttributeRenderer();
        retValue.setApplicationContext(applicationContext);
        retValue.setContainer(container);
        retValue.setContextFactory(contextFactory);
        retValue.setEvaluator(evaluator);
        return retValue;
    }

    protected void registerAttributeRenderers(BasicRendererFactory rendererFactory, Object context, TilesApplicationContext applicationContext, TilesContextFactory contextFactory, TilesContainer container, AttributeEvaluator evaluator) {
        StringAttributeRenderer stringRenderer = new StringAttributeRenderer();
        stringRenderer.setApplicationContext(applicationContext);
        stringRenderer.setContextFactory(contextFactory);
        stringRenderer.setEvaluator(evaluator);
        rendererFactory.registerRenderer("string", stringRenderer);
        TemplateAttributeRenderer templateRenderer = new TemplateAttributeRenderer();
        templateRenderer.setApplicationContext(applicationContext);
        templateRenderer.setContextFactory(contextFactory);
        templateRenderer.setEvaluator(evaluator);
        rendererFactory.registerRenderer("template", templateRenderer);
        DefinitionAttributeRenderer definitionRenderer = new DefinitionAttributeRenderer();
        definitionRenderer.setApplicationContext(applicationContext);
        definitionRenderer.setContainer(container);
        definitionRenderer.setContextFactory(contextFactory);
        definitionRenderer.setEvaluator(evaluator);
        rendererFactory.registerRenderer("definition", definitionRenderer);
    }
}

