/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.digester;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.ListAttribute;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.digester.DigesterDefinitionsReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigesterDefinitionsReader
implements DefinitionsReader {
    public static final String PARSER_VALIDATE_PARAMETER_NAME = "org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE";
    private static final String DEFINITION_TAG = "tiles-definitions/definition";
    private static final String PUT_TAG = "*/definition/put-attribute";
    private static final String PUT_DEFINITION_TAG = "*/put-attribute/definition";
    private static final String ADD_DEFINITION_TAG = "*/add-attribute/definition";
    private static final String LIST_TAG = "put-list-attribute";
    private static final String DEF_LIST_TAG = "tiles-definitions/definition/put-list-attribute";
    private static final String ADD_LIST_ELE_TAG = "*/add-attribute";
    private static final String NESTED_LIST = "*/add-list-attribute";
    private static final String ADD_WILDCARD = "*/item";
    private static final String BEAN_TAG = "*/bean";
    protected static final String DEFINITION_HANDLER_CLASS = Definition.class.getName();
    protected static final String PUT_ATTRIBUTE_HANDLER_CLASS = Attribute.class.getName();
    protected static final String LIST_HANDLER_CLASS = ListAttribute.class.getName();
    protected Digester digester = new Digester();
    private Map<String, Definition> definitions;
    protected boolean validating = true;
    protected String[] registrations;
    private int anonymousDefinitionIndex = 1;

    public DigesterDefinitionsReader() {
        this.digester.setValidating(this.validating);
        this.digester.setNamespaceAware(true);
        this.digester.setUseContextClassLoader(true);
        this.digester.setErrorHandler((ErrorHandler)new ThrowingErrorHandler());
        String[] registrations = this.getRegistrations();
        for (int i = 0; i < registrations.length; i += 2) {
            URL url = this.getClass().getResource(registrations[i + 1]);
            if (url == null) continue;
            this.digester.register(registrations[i], url.toString());
        }
        this.initSyntax(this.digester);
    }

    @Override
    public Map<String, Definition> read(Object source) {
        InputStream input;
        this.definitions = new HashMap<String, Definition>();
        if (source == null) {
            return null;
        }
        try {
            input = (InputStream)source;
        }
        catch (ClassCastException e) {
            throw new DefinitionsFactoryException("Invalid source type.  Requires java.io.InputStream.", e);
        }
        try {
            this.digester.push((Object)this);
            this.digester.parse(input);
        }
        catch (SAXException e) {
            throw new DefinitionsFactoryException("XML error reading definitions.", e);
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("I/O Error reading definitions.", e);
        }
        finally {
            this.digester.clear();
        }
        return this.definitions;
    }

    @Override
    public void init(Map<String, String> params) {
        String value;
        if (params != null && (value = params.get(PARSER_VALIDATE_PARAMETER_NAME)) != null) {
            this.digester.setValidating(Boolean.valueOf(value).booleanValue());
        }
    }

    protected void initSyntax(Digester digester) {
        this.initDigesterForTilesDefinitionsSyntax(digester);
    }

    private void initDigesterForTilesDefinitionsSyntax(Digester digester) {
        digester.addObjectCreate(DEFINITION_TAG, DEFINITION_HANDLER_CLASS);
        digester.addSetProperties(DEFINITION_TAG);
        digester.addSetNext(DEFINITION_TAG, "addDefinition", DEFINITION_HANDLER_CLASS);
        digester.addObjectCreate(PUT_DEFINITION_TAG, DEFINITION_HANDLER_CLASS);
        digester.addSetProperties(PUT_DEFINITION_TAG);
        digester.addSetRoot(PUT_DEFINITION_TAG, "addDefinition");
        digester.addRule(PUT_DEFINITION_TAG, (Rule)new AddNestedDefinitionRule());
        digester.addObjectCreate(ADD_DEFINITION_TAG, DEFINITION_HANDLER_CLASS);
        digester.addSetProperties(ADD_DEFINITION_TAG);
        digester.addSetRoot(ADD_DEFINITION_TAG, "addDefinition");
        digester.addRule(ADD_DEFINITION_TAG, (Rule)new AddNestedDefinitionRule());
        digester.addObjectCreate(PUT_TAG, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(PUT_TAG, (Rule)new FillAttributeRule());
        digester.addRule(PUT_TAG, (Rule)new PutAttributeRule());
        digester.addCallMethod(PUT_TAG, "setBody", 0);
        digester.addObjectCreate(DEF_LIST_TAG, LIST_HANDLER_CLASS);
        digester.addSetProperties(DEF_LIST_TAG);
        digester.addRule(DEF_LIST_TAG, (Rule)new PutAttributeRule());
        digester.addObjectCreate(ADD_LIST_ELE_TAG, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(ADD_LIST_ELE_TAG, (Rule)new FillAttributeRule());
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addCallMethod(ADD_LIST_ELE_TAG, "setBody", 0);
        digester.addObjectCreate(NESTED_LIST, LIST_HANDLER_CLASS);
        digester.addSetProperties(NESTED_LIST);
        digester.addSetNext(NESTED_LIST, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        String menuItemDefaultClass = "org.apache.tiles.beans.SimpleMenuItem";
        digester.addObjectCreate(ADD_WILDCARD, menuItemDefaultClass, "classtype");
        digester.addSetNext(ADD_WILDCARD, "add", "java.lang.Object");
        digester.addSetProperties(ADD_WILDCARD);
        String beanDefaultClass = "org.apache.tiles.beans.SimpleMenuItem";
        digester.addObjectCreate(BEAN_TAG, beanDefaultClass, "classtype");
        digester.addSetProperties(BEAN_TAG);
        digester.addSetNext(BEAN_TAG, "add", "java.lang.Object");
        digester.addSetProperty("*/bean/set-property", "property", "value");
    }

    public void addDefinition(Definition definition) {
        String name = definition.getName();
        if (name == null) {
            throw new DigesterDefinitionsReaderException("A root definition has been defined with no name");
        }
        this.definitions.put(name, definition);
    }

    protected String[] getRegistrations() {
        if (this.registrations == null) {
            this.registrations = new String[]{"-//Apache Software Foundation//DTD Tiles Configuration 2.0//EN", "/org/apache/tiles/resources/tiles-config_2_0.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 2.1//EN", "/org/apache/tiles/resources/tiles-config_2_1.dtd"};
        }
        return this.registrations;
    }

    protected String getNextUniqueDefinitionName(Map<String, Definition> definitions) {
        String candidate;
        do {
            candidate = "$anonymousDefinition" + this.anonymousDefinitionIndex;
            ++this.anonymousDefinitionIndex;
        } while (definitions.containsKey(candidate));
        return candidate;
    }

    private static class ThrowingErrorHandler
    implements ErrorHandler {
        private ThrowingErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    public class AddNestedDefinitionRule
    extends Rule {
        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            Definition definition = (Definition)this.digester.peek(0);
            if (definition.getName() == null) {
                definition.setName(DigesterDefinitionsReader.this.getNextUniqueDefinitionName(DigesterDefinitionsReader.this.definitions));
            }
            Attribute attribute = (Attribute)this.digester.peek(1);
            attribute.setValue((Object)definition.getName());
            attribute.setRenderer("definition");
        }
    }

    public static class PutAttributeRule
    extends Rule {
        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            Attribute attribute = (Attribute)this.digester.peek(0);
            Definition definition = (Definition)this.digester.peek(1);
            definition.putAttribute(attributes.getValue("name"), attribute, "true".equals(attributes.getValue("cascade")));
        }
    }

    public static class FillAttributeRule
    extends Rule {
        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            Attribute attribute = (Attribute)this.digester.peek();
            attribute.setValue((Object)attributes.getValue("value"));
            attribute.setRole(attributes.getValue("role"));
            attribute.setRenderer(attributes.getValue("type"));
        }
    }
}

