/*
 * $Id: DirectAttributeEvaluator.java 644017 2008-04-02 19:37:58Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tiles.evaluator.impl;

import java.util.Map;

import org.apache.tiles.Attribute;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.evaluator.AttributeEvaluator;

/**
 * Resolves a string and returns the string itself. It is useful for backward
 * compatibility.
 *
 * @version $Rev: 644017 $ $Date: 2008-04-02 21:37:58 +0200 (Wed, 02 Apr 2008) $
 * @since 2.1.0
 */
public class DirectAttributeEvaluator implements AttributeEvaluator {

    /** {@inheritDoc} */
    public void init(Map<String, String> initParameters) {
        // Does nothing.
    }

    /** {@inheritDoc} */
    public Object evaluate(String expression, TilesRequestContext request) {
        return expression;
    }

    /** {@inheritDoc} */
    public Object evaluate(Attribute attribute, TilesRequestContext request) {
        if (attribute == null) {
            throw new IllegalArgumentException("The attribute cannot be null");
        }

        return attribute.getValue();
    }
}
