/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.api.collections.MaintainRoutedAliasCmd;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRoutedAliasUpdateProcessor
extends UpdateRequestProcessor {
    public static final String ALIAS_DISTRIB_UPDATE_PARAM = "alias.update.distrib";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ConcurrentHashMap<String, Semaphore> aliasToSemaphoreMap = new ConcurrentHashMap(4);
    private final String thisCollection;
    private final TimeRoutedAlias timeRoutedAlias;
    private final ZkController zkController;
    private final SolrCmdDistributor cmdDistrib;
    private final CollectionsHandler collHandler;
    private final SolrParams outParamsToLeader;
    private List<Map.Entry<Instant, String>> parsedCollectionsDesc;
    private Aliases parsedCollectionsAliases;

    public static UpdateRequestProcessor wrap(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        String aliasName = req.getCore().getCoreDescriptor().getCoreProperty("routedAliasName", null);
        DistributedUpdateProcessor.DistribPhase shardDistribPhase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get("update.distrib"));
        DistributedUpdateProcessor.DistribPhase aliasDistribPhase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get(ALIAS_DISTRIB_UPDATE_PARAM));
        if (aliasName == null || aliasDistribPhase != DistributedUpdateProcessor.DistribPhase.NONE || shardDistribPhase != DistributedUpdateProcessor.DistribPhase.NONE) {
            return next;
        }
        return new TimeRoutedAliasUpdateProcessor(req, rsp, next, aliasName, aliasDistribPhase);
    }

    protected TimeRoutedAliasUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next, String aliasName, DistributedUpdateProcessor.DistribPhase aliasDistribPhase) {
        super(next);
        assert (aliasDistribPhase == DistributedUpdateProcessor.DistribPhase.NONE);
        SolrCore core = req.getCore();
        this.thisCollection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        CoreContainer cc = core.getCoreContainer();
        this.zkController = cc.getZkController();
        this.cmdDistrib = new SolrCmdDistributor(cc.getUpdateShardHandler());
        this.collHandler = cc.getCollectionsHandler();
        Map aliasProperties = this.zkController.getZkStateReader().getAliases().getCollectionAliasProperties(aliasName);
        if (aliasProperties == null) {
            throw this.newAliasMustExistException();
        }
        try {
            this.timeRoutedAlias = new TimeRoutedAlias(aliasName, aliasProperties);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Routed alias has invalid properties: " + e, (Throwable)e);
        }
        ModifiableSolrParams outParams = new ModifiableSolrParams(req.getParams());
        outParams.remove("optimize");
        outParams.remove("commit");
        outParams.remove("softCommit");
        outParams.remove("prepareCommit");
        outParams.remove("rollback");
        outParams.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.NONE.toString()});
        outParams.set(ALIAS_DISTRIB_UPDATE_PARAM, new String[]{DistributedUpdateProcessor.DistribPhase.TOLEADER.toString()});
        outParams.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)core.getName())});
        this.outParamsToLeader = outParams;
    }

    private String getAliasName() {
        return this.timeRoutedAlias.getAliasName();
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        String targetCollection;
        block6: {
            boolean updated;
            Object routeValue = cmd.getSolrInputDocument().getFieldValue(this.timeRoutedAlias.getRouteField());
            Instant routeTimestamp = this.parseRouteKey(routeValue);
            this.updateParsedCollectionAliases();
            do {
                if ((targetCollection = this.findTargetCollectionGivenTimestamp(routeTimestamp)) == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Doc " + cmd.getPrintableId() + " couldn't be routed with " + this.timeRoutedAlias.getRouteField() + "=" + routeTimestamp);
                }
                Instant mostRecentCollTimestamp = this.parsedCollectionsDesc.get(0).getKey();
                String mostRecentCollName = this.parsedCollectionsDesc.get(0).getValue();
                if (!mostRecentCollName.equals(targetCollection)) break block6;
                Instant maxFutureTime = Instant.now().plusMillis(this.timeRoutedAlias.getMaxFutureMs());
                if (routeTimestamp.isAfter(maxFutureTime)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The document's time routed key of " + routeValue + " is too far in the future given " + "router.maxFutureMs" + "=" + this.timeRoutedAlias.getMaxFutureMs());
                }
                Instant nextCollTimestamp = this.timeRoutedAlias.computeNextCollTimestamp(mostRecentCollTimestamp);
                if (routeTimestamp.isBefore(nextCollTimestamp)) break block6;
                this.createCollectionAfter(mostRecentCollName);
            } while (updated = this.updateParsedCollectionAliases());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "We need to create a new time routed collection but for unknown reasons were unable to do so.");
        }
        assert (targetCollection != null);
        if (this.thisCollection.equals(targetCollection)) {
            super.processAdd(cmd);
        } else {
            SolrCmdDistributor.Node targetLeaderNode = this.lookupShardLeaderOfCollection(targetCollection);
            this.cmdDistrib.distribAdd(cmd, Collections.singletonList(targetLeaderNode), new ModifiableSolrParams(this.outParamsToLeader));
        }
    }

    private Instant parseRouteKey(Object routeKey) {
        Instant docTimestamp;
        if (routeKey instanceof Instant) {
            docTimestamp = (Instant)routeKey;
        } else if (routeKey instanceof Date) {
            docTimestamp = ((Date)routeKey).toInstant();
        } else if (routeKey instanceof CharSequence) {
            docTimestamp = Instant.parse((CharSequence)routeKey);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected type of routeKey: " + routeKey);
        }
        return docTimestamp;
    }

    private boolean updateParsedCollectionAliases() {
        Aliases aliases = this.zkController.getZkStateReader().getAliases();
        if (this.parsedCollectionsAliases != aliases) {
            if (this.parsedCollectionsAliases != null) {
                log.debug("Observing possibly updated alias: {}", (Object)this.getAliasName());
            }
            this.parsedCollectionsDesc = this.timeRoutedAlias.parseCollections(aliases, this::newAliasMustExistException);
            this.parsedCollectionsAliases = aliases;
            return true;
        }
        return false;
    }

    private String findTargetCollectionGivenTimestamp(Instant docTimestamp) {
        for (Map.Entry<Instant, String> entry : this.parsedCollectionsDesc) {
            Instant colStartTime = entry.getKey();
            if (docTimestamp.isBefore(colStartTime)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void createCollectionAfter(String mostRecentCollName) {
        Semaphore semaphore = aliasToSemaphoreMap.computeIfAbsent(this.getAliasName(), n -> new Semaphore(1));
        if (semaphore.tryAcquire()) {
            try {
                MaintainRoutedAliasCmd.remoteInvoke(this.collHandler, this.getAliasName(), mostRecentCollName);
                this.zkController.getZkStateReader().aliasesManager.update();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            finally {
                semaphore.release();
            }
        }
        log.debug("Collection creation is already in progress so we'll wait then try again.");
        try {
            if (!semaphore.tryAcquire(CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT, TimeUnit.MILLISECONDS)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Waited too long for another update thread to be done with collection creation.");
            }
            semaphore.release();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted waiting on collection creation.", (Throwable)e);
        }
    }

    private SolrException newAliasMustExistException() {
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Collection " + this.thisCollection + " created for use with alias " + this.getAliasName() + " which doesn't exist anymore. You cannot write to this unless the alias exists.");
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        List<SolrCmdDistributor.Node> nodes = this.lookupShardLeadersOfCollections();
        this.cmdDistrib.distribDelete(cmd, nodes, new ModifiableSolrParams(this.outParamsToLeader));
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        List<SolrCmdDistributor.Node> nodes = this.lookupShardLeadersOfCollections();
        this.cmdDistrib.distribCommit(cmd, nodes, new ModifiableSolrParams(this.outParamsToLeader));
        this.cmdDistrib.blockAndDoRetries();
    }

    @Override
    public void finish() throws IOException {
        try {
            this.cmdDistrib.finish();
            List<SolrCmdDistributor.Error> errors = this.cmdDistrib.getErrors();
            if (!errors.isEmpty()) {
                throw new DistributedUpdateProcessor.DistributedUpdatesAsyncException(errors);
            }
        }
        finally {
            super.finish();
        }
    }

    @Override
    protected void doClose() {
        try {
            this.cmdDistrib.close();
        }
        finally {
            super.doClose();
        }
    }

    private List<SolrCmdDistributor.Node> lookupShardLeadersOfCollections() {
        Aliases aliases = this.zkController.getZkStateReader().getAliases();
        List collections = (List)aliases.getCollectionAliasListMap().get(this.getAliasName());
        if (collections == null) {
            throw this.newAliasMustExistException();
        }
        return collections.stream().map(this::lookupShardLeaderOfCollection).collect(Collectors.toList());
    }

    private SolrCmdDistributor.Node lookupShardLeaderOfCollection(String collection) {
        Collection activeSlices = this.zkController.getClusterState().getCollection(collection).getActiveSlices();
        if (activeSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot route to collection " + collection);
        }
        Slice slice = (Slice)activeSlices.iterator().next();
        Replica leader = slice.getLeader();
        if (leader == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No 'leader' replica available for shard " + slice.getName() + " of collection " + collection);
        }
        return new SolrCmdDistributor.RetryNode(new ZkCoreNodeProps((ZkNodeProps)leader), this.zkController.getZkStateReader(), collection, null);
    }
}

