/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetQuery;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetSortableMerger;
import org.apache.solr.search.facet.SlotAcc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatednessAgg
extends AggValueSource {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String RELATEDNESS = "relatedness";
    private static final String FG_POP = "foreground_popularity";
    private static final String BG_POP = "background_popularity";
    private static final String FG_SIZE = "foreground_size";
    private static final String FG_COUNT = "foreground_count";
    private static final String BG_SIZE = "background_size";
    private static final String BG_COUNT = "background_count";
    protected final Query fgQ;
    protected final Query bgQ;
    public static final String NAME = "relatedness";

    public RelatednessAgg(Query fgQ, Query bgQ) {
        super("relatedness");
        this.fgQ = fgQ;
        this.bgQ = bgQ;
        if (null == fgQ || null == bgQ) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "relatedness aggregate function requires both foreground & background to be real (non-null) queries");
        }
    }

    public String description() {
        return this.name + "(" + this.fgQ + "," + this.bgQ + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (!Objects.equals(((Object)((Object)this)).getClass(), o.getClass())) {
            return false;
        }
        RelatednessAgg that = (RelatednessAgg)((Object)o);
        return Objects.equals(this.fgQ, that.fgQ) && Objects.equals(this.bgQ, that.bgQ);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.fgQ, this.bgQ);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        throw new UnsupportedOperationException("NOT IMPLEMENTED " + this.name + " " + (Object)((Object)this));
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        ArrayList<Query> fgFilters = new ArrayList<Query>(3);
        fgFilters.add(this.fgQ);
        FacetContext ctx = fcontext;
        while (ctx != null) {
            if (null == ctx.filter) {
                assert (null == ctx.parent && fcontext == ctx || null == ctx.parent.parent && null == ctx.parent.filter);
                break;
            }
            fgFilters.add(ctx.filter);
            ctx = ctx.parent;
        }
        DocSet fgSet = fcontext.searcher.getDocSet(fgFilters);
        DocSet bgSet = fcontext.searcher.getDocSet(this.bgQ);
        return new SKGSlotAcc(fcontext, numSlots, fgSet, bgSet);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    public static double computeRelatedness(long fg_count, long fg_size, long bg_count, long bg_size) {
        double fg_size_d = fg_size;
        double bg_size_d = bg_size;
        double bg_prob = (double)bg_count / bg_size_d;
        double num = (double)fg_count - fg_size_d * bg_prob;
        double denom = Math.sqrt(fg_size_d * bg_prob * (1.0 - bg_prob));
        denom = denom == 0.0 ? 1.0E-10 : denom;
        double z = num / denom;
        double result = 0.2 * RelatednessAgg.sigmoidHelper(z, -80.0, 50.0) + 0.2 * RelatednessAgg.sigmoidHelper(z, -30.0, 30.0) + 0.2 * RelatednessAgg.sigmoidHelper(z, 0.0, 30.0) + 0.2 * RelatednessAgg.sigmoidHelper(z, 30.0, 30.0) + 0.2 * RelatednessAgg.sigmoidHelper(z, 80.0, 50.0);
        return RelatednessAgg.roundTo5Digits(result);
    }

    public static double roundTo5Digits(double val) {
        return (double)Math.round(val * 100000.0) / 100000.0;
    }

    private static double sigmoidHelper(double x, double offset, double scale) {
        return (x + offset) / (scale + Math.abs(x + offset));
    }

    private static final class Merger
    extends FacetSortableMerger {
        private final BucketData mergedData = new BucketData();

        private Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            NamedList shardData = (NamedList)facetResult;
            this.mergedData.incSizes((Long)shardData.remove(RelatednessAgg.FG_SIZE), (Long)shardData.remove(RelatednessAgg.BG_SIZE));
            this.mergedData.incCounts((Long)shardData.remove(RelatednessAgg.FG_COUNT), (Long)shardData.remove(RelatednessAgg.BG_COUNT));
        }

        @Override
        public int compareTo(FacetSortableMerger other, FacetRequest.SortDirection direction) {
            assert (other instanceof Merger);
            Merger that = (Merger)other;
            return this.mergedData.compareTo(that.mergedData);
        }

        @Override
        public Object getMergedResult() {
            return this.mergedData.externalize(false);
        }
    }

    private static final class BucketData
    implements Comparable<BucketData> {
        private long fg_size = 0L;
        private long bg_size = 0L;
        private long fg_count = 0L;
        private long bg_count = 0L;
        private double relatedness = Double.NaN;

        public void incCounts(long fgInc, long bgInc) {
            this.relatedness = Double.NaN;
            this.fg_count += fgInc;
            this.bg_count += bgInc;
        }

        public void incSizes(long fgInc, long bgInc) {
            this.relatedness = Double.NaN;
            this.fg_size += fgInc;
            this.bg_size += bgInc;
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.fg_count, this.bg_count, this.fg_size, this.bg_size);
        }

        public boolean equals(Object other) {
            if (!Objects.equals(this.getClass(), other.getClass())) {
                return false;
            }
            BucketData that = (BucketData)other;
            return Objects.equals(this.fg_count, that.fg_count) && Objects.equals(this.bg_count, that.bg_count) && Objects.equals(this.fg_size, that.fg_size) && Objects.equals(this.bg_size, that.bg_size);
        }

        private double getRelatedness() {
            if (Double.isNaN(this.relatedness)) {
                this.relatedness = RelatednessAgg.computeRelatedness(this.fg_count, this.fg_size, this.bg_count, this.bg_size);
            }
            return this.relatedness;
        }

        @Override
        public int compareTo(BucketData that) {
            int r = Double.compare(this.getRelatedness(), that.getRelatedness());
            if (0 == r) {
                r = Long.compare(this.fg_count, that.fg_count);
            }
            if (0 == r) {
                r = Long.compare(this.bg_count, that.bg_count);
            }
            return r;
        }

        public SimpleOrderedMap externalize(boolean isShardRequest) {
            SimpleOrderedMap result = new SimpleOrderedMap();
            if (isShardRequest) {
                result.add(RelatednessAgg.FG_COUNT, (Object)this.fg_count);
                result.add(RelatednessAgg.BG_COUNT, (Object)this.bg_count);
                result.add(RelatednessAgg.FG_SIZE, (Object)this.fg_size);
                result.add(RelatednessAgg.BG_SIZE, (Object)this.bg_size);
            } else {
                result.add("relatedness", (Object)this.getRelatedness());
                result.add(RelatednessAgg.FG_POP, (Object)RelatednessAgg.roundTo5Digits((double)this.fg_count / (double)this.bg_size));
                result.add(RelatednessAgg.BG_POP, (Object)RelatednessAgg.roundTo5Digits((double)this.bg_count / (double)this.bg_size));
            }
            return result;
        }
    }

    private static final class SKGSlotAcc
    extends SlotAcc {
        private BucketData[] slotvalues;
        private final DocSet fgSet;
        private final DocSet bgSet;
        private final long fgSize;
        private final long bgSize;

        public SKGSlotAcc(FacetContext fcontext, int numSlots, DocSet fgSet, DocSet bgSet) throws IOException {
            super(fcontext);
            this.fgSet = fgSet;
            this.bgSet = bgSet;
            this.fgSize = fgSet.size();
            this.bgSize = bgSet.size();
            this.slotvalues = new BucketData[numSlots];
            this.reset();
        }

        private void processSlot(int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            assert (null != slotContext);
            Query slotQ = slotContext.apply(slot).getSlotQuery();
            if (null == slotQ) {
                assert (this.fcontext.processor.freq instanceof FacetQuery) : this.fcontext.processor.freq;
                assert (null == this.fcontext.parent);
                assert (null == this.fcontext.filter);
            }
            DocSet slotSet = null == slotQ ? this.fcontext.base : this.fcontext.searcher.getDocSet(slotQ);
            BucketData slotVal = new BucketData();
            slotVal.incSizes(this.fgSize, this.bgSize);
            slotVal.incCounts(this.fgSet.intersectionSize(slotSet), this.bgSet.intersectionSize(slotSet));
            this.slotvalues[slot] = slotVal;
        }

        @Override
        public void collect(int perSegDocId, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            if (null == this.slotvalues[slot]) {
                this.processSlot(slot, slotContext);
            }
        }

        @Override
        public int collect(DocSet docs, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            assert (null == this.slotvalues[slot]);
            this.processSlot(slot, slotContext);
            return docs.size();
        }

        @Override
        public int compare(int slotA, int slotB) {
            BucketData a = this.slotvalues[slotA];
            BucketData b = this.slotvalues[slotB];
            assert (null != a);
            assert (null != b);
            return a.compareTo(b);
        }

        @Override
        public Object getValue(int slotNum) {
            BucketData slotVal = this.slotvalues[slotNum];
            if (null == slotVal) {
                slotVal = new BucketData();
                slotVal.incSizes(this.fgSize, this.bgSize);
            }
            SimpleOrderedMap res = slotVal.externalize(this.fcontext.isShard());
            return res;
        }

        @Override
        public void reset() {
            Arrays.fill(this.slotvalues, null);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.slotvalues = resizer.resize(this.slotvalues, null);
        }

        @Override
        public void close() throws IOException {
            this.slotvalues = null;
        }
    }
}

