/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.net.URI;
import java.util.Optional;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.SnapShooter;
import org.apache.solr.handler.admin.CoreAdminHandler;

class BackupCoreOp
implements CoreAdminHandler.CoreAdminOp {
    BackupCoreOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        String name = params.required().get("name");
        String repoName = params.get("repository");
        BackupRepository repository = it.handler.coreContainer.newBackupRepository(Optional.ofNullable(repoName));
        String location = repository.getBackupLocation(params.get("location"));
        if (location == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property");
        }
        String commitName = params.get("commitName");
        URI locationUri = repository.createURI(location);
        try (SolrCore core = it.handler.coreContainer.getCore(cname);){
            SnapShooter snapShooter = new SnapShooter(repository, core, locationUri, name, commitName);
            if (!snapShooter.getBackupRepository().exists(snapShooter.getLocation())) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Directory to contain snapshots doesn't exist: " + snapShooter.getLocation());
            }
            snapShooter.validateCreateSnapshot();
            snapShooter.createSnapshot();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to backup core=" + cname + " because " + e, (Throwable)e);
        }
    }
}

