/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventProcessorStage;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.ExecutePlanAction;
import org.apache.solr.cloud.autoscaling.TriggerAction;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerEventQueue;
import org.apache.solr.cloud.autoscaling.TriggerListener;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledTriggers
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_SCHEDULED_TRIGGER_DELAY_SECONDS = 1;
    public static final int DEFAULT_ACTION_THROTTLE_PERIOD_SECONDS = 5;
    public static final int DEFAULT_COOLDOWN_PERIOD_SECONDS = 5;
    public static final int DEFAULT_TRIGGER_CORE_POOL_SIZE = 4;
    static final Map<String, Object> DEFAULT_PROPERTIES = new HashMap<String, Object>();
    private final Map<String, TriggerWrapper> scheduledTriggerWrappers = new ConcurrentHashMap<String, TriggerWrapper>();
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final ExecutorService actionExecutor;
    private boolean isClosed = false;
    private final AtomicBoolean hasPendingActions = new AtomicBoolean(false);
    private final AtomicLong cooldownStart = new AtomicLong();
    private final AtomicLong cooldownPeriod = new AtomicLong(TimeUnit.SECONDS.toNanos(5L));
    private final AtomicLong triggerDelay = new AtomicLong(1L);
    private final SolrCloudManager cloudManager;
    private final DistribStateManager stateManager;
    private final SolrResourceLoader loader;
    private final Stats queueStats;
    private final TriggerListeners listeners;
    private AutoScalingConfig autoScalingConfig;

    public ScheduledTriggers(SolrResourceLoader loader, SolrCloudManager cloudManager) {
        this.scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(4, new DefaultSolrThreadFactory("ScheduledTrigger"));
        this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        this.scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.actionExecutor = ExecutorUtil.newMDCAwareSingleThreadExecutor((ThreadFactory)new DefaultSolrThreadFactory("AutoscalingActionExecutor"));
        this.cloudManager = cloudManager;
        this.stateManager = cloudManager.getDistribStateManager();
        this.loader = loader;
        this.queueStats = new Stats();
        this.listeners = new TriggerListeners();
        this.cooldownStart.set(cloudManager.getTimeSource().getTimeNs() - this.cooldownPeriod.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoScalingConfig(AutoScalingConfig autoScalingConfig) {
        HashMap<String, Object> currentProps = new HashMap<String, Object>(DEFAULT_PROPERTIES);
        if (this.autoScalingConfig != null) {
            currentProps.putAll(this.autoScalingConfig.getProperties());
        }
        this.listeners.setAutoScalingConfig(autoScalingConfig);
        for (Map.Entry entry : currentProps.entrySet()) {
            String key;
            Map newProps = autoScalingConfig.getProperties();
            if (!newProps.containsKey(key = (String)entry.getKey()) || entry.getValue().equals(newProps.get(key))) continue;
            log.debug("Changing value of autoscaling property: {} from: {} to: {}", new Object[]{key, entry.getValue(), newProps.get(key)});
            switch (key) {
                case "triggerScheduleDelaySeconds": {
                    this.triggerDelay.set(((Number)newProps.get(key)).intValue());
                    ScheduledTriggers scheduledTriggers = this;
                    synchronized (scheduledTriggers) {
                        this.scheduledTriggerWrappers.forEach((s, triggerWrapper) -> {
                            if (triggerWrapper.scheduledFuture.cancel(false)) {
                                triggerWrapper.scheduledFuture = this.scheduledThreadPoolExecutor.scheduleWithFixedDelay((Runnable)triggerWrapper, 0L, this.cloudManager.getTimeSource().convertDelay(TimeUnit.SECONDS, this.triggerDelay.get(), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                            } else {
                                log.debug("Failed to cancel scheduled task: {}", s);
                            }
                        });
                        break;
                    }
                }
                case "triggerCooldownPeriodSeconds": {
                    this.cooldownPeriod.set(TimeUnit.SECONDS.toNanos(((Number)newProps.get(key)).longValue()));
                    break;
                }
                case "triggerCorePoolSize": {
                    this.scheduledThreadPoolExecutor.setCorePoolSize(((Number)newProps.get(key)).intValue());
                }
            }
        }
        this.autoScalingConfig = autoScalingConfig;
        this.cooldownStart.set(this.cloudManager.getTimeSource().getTimeNs() - this.cooldownPeriod.get());
    }

    public synchronized void add(AutoScaling.Trigger newTrigger) throws Exception {
        TriggerWrapper st;
        if (this.isClosed) {
            throw new AlreadyClosedException("ScheduledTriggers has been closed and cannot be used anymore");
        }
        try {
            st = new TriggerWrapper(newTrigger, this.cloudManager, this.queueStats);
        }
        catch (Exception e) {
            if (this.isClosed) {
                throw new AlreadyClosedException("ScheduledTriggers has been closed and cannot be used anymore");
            }
            if (this.cloudManager.isClosed()) {
                log.error("Failed to add trigger " + newTrigger.getName() + " - closing or disconnected from data provider", (Throwable)e);
            } else {
                log.error("Failed to add trigger " + newTrigger.getName(), (Throwable)e);
            }
            return;
        }
        TriggerWrapper triggerWrapper = st;
        TriggerWrapper old = this.scheduledTriggerWrappers.putIfAbsent(newTrigger.getName(), triggerWrapper);
        if (old != null) {
            if (old.trigger.equals(newTrigger)) {
                return;
            }
            IOUtils.closeQuietly((Closeable)old);
            newTrigger.restoreState(old.trigger);
            triggerWrapper.setReplay(false);
            this.scheduledTriggerWrappers.replace(newTrigger.getName(), triggerWrapper);
        }
        newTrigger.setProcessor(event -> {
            TriggerListeners triggerListeners = this.listeners.copy();
            if (this.cloudManager.isClosed()) {
                String msg = String.format(Locale.ROOT, "Ignoring autoscaling event %s because Solr has been shutdown.", event.toString());
                log.warn(msg);
                triggerListeners.fireListeners(event.getSource(), event, TriggerEventProcessorStage.ABORTED, msg);
                return false;
            }
            TriggerWrapper scheduledSource = this.scheduledTriggerWrappers.get(event.getSource());
            if (scheduledSource == null) {
                String msg = String.format(Locale.ROOT, "Ignoring autoscaling event %s because the source trigger: %s doesn't exist.", event.toString(), event.getSource());
                triggerListeners.fireListeners(event.getSource(), event, TriggerEventProcessorStage.FAILED, msg);
                log.warn(msg);
                return false;
            }
            boolean replaying = event.getProperty("replaying") != null ? (Boolean)event.getProperty("replaying") : false;
            AutoScaling.Trigger source = scheduledSource.trigger;
            if (scheduledSource.isClosed || source.isClosed()) {
                String msg = String.format(Locale.ROOT, "Ignoring autoscaling event %s because the source trigger: %s has already been closed", event.toString(), source);
                triggerListeners.fireListeners(event.getSource(), event, TriggerEventProcessorStage.ABORTED, msg);
                log.warn(msg);
                return false;
            }
            if (event.isIgnored()) {
                log.debug("-------- Ignoring event: " + event);
                event.getProperties().put("ignored", true);
                triggerListeners.fireListeners(event.getSource(), event, TriggerEventProcessorStage.IGNORED, "Event was ignored.");
                return true;
            }
            if (this.cooldownStart.get() + this.cooldownPeriod.get() > this.cloudManager.getTimeSource().getTimeNs()) {
                log.debug("-------- Cooldown period - rejecting event: " + event);
                event.getProperties().put("cooldown", true);
                triggerListeners.fireListeners(event.getSource(), event, TriggerEventProcessorStage.IGNORED, "In cooldown period.");
                return false;
            }
            log.debug("++++++++ Cooldown inactive - processing event: " + event);
            if (this.hasPendingActions.compareAndSet(false, true)) {
                this.pauseTriggers();
                boolean enqueued = replaying ? false : triggerWrapper.enqueue(event);
                triggerListeners.fireListeners(event.getSource(), event, TriggerEventProcessorStage.STARTED);
                List<TriggerAction> actions = source.getActions();
                if (actions != null) {
                    if (this.actionExecutor.isShutdown()) {
                        String msg = String.format(Locale.ROOT, "Ignoring autoscaling event %s from trigger %s because the executor has already been closed", event.toString(), source);
                        triggerListeners.fireListeners(event.getSource(), event, TriggerEventProcessorStage.ABORTED, msg);
                        log.warn(msg);
                        return false;
                    }
                    this.actionExecutor.submit(() -> {
                        assert (this.hasPendingActions.get());
                        long eventProcessingStart = this.cloudManager.getTimeSource().getTimeNs();
                        TriggerListeners triggerListeners1 = triggerListeners.copy();
                        log.debug("-- processing actions for " + event);
                        try {
                            this.waitForPendingTasks(newTrigger, actions);
                            ActionContext actionContext = new ActionContext(this.cloudManager, newTrigger, new HashMap<String, Object>());
                            for (TriggerAction action : actions) {
                                List beforeActions = (List)actionContext.getProperties().computeIfAbsent(TriggerEventProcessorStage.BEFORE_ACTION.toString(), k -> new ArrayList());
                                beforeActions.add(action.getName());
                                triggerListeners1.fireListeners(event.getSource(), event, TriggerEventProcessorStage.BEFORE_ACTION, action.getName(), actionContext);
                                try {
                                    action.process(event, actionContext);
                                }
                                catch (Exception e) {
                                    triggerListeners1.fireListeners(event.getSource(), event, TriggerEventProcessorStage.FAILED, action.getName(), actionContext, e, null);
                                    throw new Exception("Error executing action: " + action.getName() + " for trigger event: " + event, e);
                                }
                                List afterActions = (List)actionContext.getProperties().computeIfAbsent(TriggerEventProcessorStage.AFTER_ACTION.toString(), k -> new ArrayList());
                                afterActions.add(action.getName());
                                triggerListeners1.fireListeners(event.getSource(), event, TriggerEventProcessorStage.AFTER_ACTION, action.getName(), actionContext);
                            }
                            if (enqueued) {
                                TriggerEvent ev = triggerWrapper.dequeue();
                                assert (ev.getId().equals(event.getId()));
                            }
                            triggerListeners1.fireListeners(event.getSource(), event, TriggerEventProcessorStage.SUCCEEDED);
                        }
                        catch (Exception e) {
                            log.warn("Exception executing actions", (Throwable)e);
                        }
                        finally {
                            this.cooldownStart.set(this.cloudManager.getTimeSource().getTimeNs());
                            this.hasPendingActions.set(false);
                            this.resumeTriggers(this.cloudManager.getTimeSource().convertDelay(TimeUnit.NANOSECONDS, this.cooldownPeriod.get(), TimeUnit.MILLISECONDS));
                        }
                        log.debug("-- processing took {} ms for event id={}", (Object)TimeUnit.NANOSECONDS.toMillis(this.cloudManager.getTimeSource().getTimeNs() - eventProcessingStart), (Object)event.id);
                    });
                } else {
                    TriggerEvent ev;
                    if (enqueued && !(ev = triggerWrapper.dequeue()).getId().equals(event.getId())) {
                        throw new RuntimeException("Wrong event dequeued, queue of " + triggerWrapper.trigger.getName() + " is broken! Expected event=" + event + " but got " + ev);
                    }
                    triggerListeners.fireListeners(event.getSource(), event, TriggerEventProcessorStage.SUCCEEDED);
                    this.hasPendingActions.set(false);
                    this.resumeTriggers(0L);
                }
                return true;
            }
            triggerListeners.fireListeners(event.getSource(), event, TriggerEventProcessorStage.IGNORED, "Already processing another event.");
            return false;
        });
        newTrigger.init();
        triggerWrapper.scheduledFuture = this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(triggerWrapper, 0L, this.cloudManager.getTimeSource().convertDelay(TimeUnit.SECONDS, this.triggerDelay.get(), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public synchronized void pauseTriggers() {
        if (log.isDebugEnabled()) {
            log.debug("Pausing all triggers: {}", this.scheduledTriggerWrappers.keySet());
        }
        this.scheduledTriggerWrappers.forEach((s, triggerWrapper) -> triggerWrapper.scheduledFuture.cancel(false));
    }

    public synchronized void resumeTriggers(long afterDelayMillis) {
        this.scheduledTriggerWrappers.forEach((s, triggerWrapper) -> {
            if (triggerWrapper.scheduledFuture.isCancelled()) {
                log.debug("Resuming trigger: {} after {}ms", s, (Object)afterDelayMillis);
                triggerWrapper.scheduledFuture = this.scheduledThreadPoolExecutor.scheduleWithFixedDelay((Runnable)triggerWrapper, afterDelayMillis, this.cloudManager.getTimeSource().convertDelay(TimeUnit.SECONDS, this.triggerDelay.get(), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            }
        });
    }

    private void waitForPendingTasks(AutoScaling.Trigger newTrigger, List<TriggerAction> actions) throws AlreadyClosedException {
        DistribStateManager stateManager = this.cloudManager.getDistribStateManager();
        try {
            for (TriggerAction action : actions) {
                if (!(action instanceof ExecutePlanAction)) continue;
                String parentPath = "/autoscaling/triggerState/" + newTrigger.getName() + "/" + action.getName();
                if (stateManager.hasData(parentPath)) {
                    List children = stateManager.listData(parentPath);
                    if (children == null) continue;
                    for (String child : children) {
                        String path = parentPath + '/' + child;
                        VersionedData data = stateManager.getData(path, null);
                        if (data == null) continue;
                        Map map = (Map)Utils.fromJSON((byte[])data.getData());
                        String requestid = (String)map.get("requestid");
                        try {
                            RequestStatusState state;
                            log.debug("Found pending task with requestid={}", (Object)requestid);
                            CollectionAdminRequest.RequestStatusResponse statusResponse = ExecutePlanAction.waitForTaskToFinish(this.cloudManager, requestid, 120L, TimeUnit.SECONDS);
                            if (statusResponse == null || (state = statusResponse.getRequestStatus()) != RequestStatusState.COMPLETED && state != RequestStatusState.FAILED && state != RequestStatusState.NOT_FOUND) continue;
                            stateManager.removeData(path, -1);
                        }
                        catch (Exception e) {
                            if (this.cloudManager.isClosed()) {
                                throw e;
                            }
                            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                            if (rootCause instanceof IllegalStateException && rootCause.getMessage().contains("Connection pool shut down")) {
                                throw e;
                            }
                            if (rootCause instanceof TimeoutException && rootCause.getMessage().contains("Could not connect to ZooKeeper")) {
                                throw e;
                            }
                            log.error("Unexpected exception while waiting for pending task with requestid: " + requestid + " to finish", (Throwable)e);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Thread interrupted", (Throwable)e);
        }
        catch (Exception e) {
            if (this.cloudManager.isClosed()) {
                throw new AlreadyClosedException("The Solr instance has been shutdown");
            }
            log.error("Unexpected exception while waiting for pending tasks to finish", (Throwable)e);
        }
    }

    public synchronized void removeAll() {
        this.getScheduledTriggerNames().forEach(t -> {
            log.info("-- removing trigger: " + t);
            this.remove((String)t);
        });
    }

    public synchronized void remove(String triggerName) {
        TriggerWrapper removed = this.scheduledTriggerWrappers.remove(triggerName);
        IOUtils.closeQuietly((Closeable)removed);
        this.removeTriggerZKData(triggerName);
    }

    private void removeTriggerZKData(String triggerName) {
        String statePath = "/autoscaling/triggerState/" + triggerName;
        String eventsPath = "/autoscaling/events/" + triggerName;
        try {
            this.stateManager.removeRecursively(statePath, true, true);
        }
        catch (Exception e) {
            log.warn("Failed to remove state for removed trigger " + statePath, (Throwable)e);
        }
        try {
            this.stateManager.removeRecursively(eventsPath, true, true);
        }
        catch (Exception e) {
            log.warn("Failed to remove events for removed trigger " + eventsPath, (Throwable)e);
        }
    }

    public synchronized Set<String> getScheduledTriggerNames() {
        return Collections.unmodifiableSet(new HashSet<String>(this.scheduledTriggerWrappers.keySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ScheduledTriggers scheduledTriggers = this;
        synchronized (scheduledTriggers) {
            this.isClosed = true;
            for (TriggerWrapper triggerWrapper : this.scheduledTriggerWrappers.values()) {
                IOUtils.closeQuietly((Closeable)triggerWrapper);
            }
            this.scheduledTriggerWrappers.clear();
        }
        log.debug("Shutting down scheduled thread pool executor now");
        this.scheduledThreadPoolExecutor.shutdownNow();
        log.debug("Shutting down action executor now");
        this.actionExecutor.shutdownNow();
        this.listeners.close();
        log.debug("Awaiting termination for action executor");
        ExecutorUtil.awaitTermination((ExecutorService)this.actionExecutor);
        log.debug("Awaiting termination for scheduled thread pool executor");
        ExecutorUtil.awaitTermination((ExecutorService)this.scheduledThreadPoolExecutor);
        log.debug("ScheduledTriggers closed completely");
    }

    static {
        DEFAULT_PROPERTIES.put("triggerScheduleDelaySeconds", 1);
        DEFAULT_PROPERTIES.put("triggerCooldownPeriodSeconds", 5);
        DEFAULT_PROPERTIES.put("triggerCorePoolSize", 4);
        DEFAULT_PROPERTIES.put("actionThrottlePeriodSeconds", 5);
    }

    private class TriggerListeners {
        Map<String, Map<TriggerEventProcessorStage, List<TriggerListener>>> listenersPerStage = new HashMap<String, Map<TriggerEventProcessorStage, List<TriggerListener>>>();
        Map<String, TriggerListener> listenersPerName = new HashMap<String, TriggerListener>();
        ReentrantLock updateLock = new ReentrantLock();

        public TriggerListeners() {
        }

        private TriggerListeners(Map<String, Map<TriggerEventProcessorStage, List<TriggerListener>>> listenersPerStage, Map<String, TriggerListener> listenersPerName) {
            this.listenersPerStage = new HashMap<String, Map<TriggerEventProcessorStage, List<TriggerListener>>>();
            listenersPerStage.forEach((n, listeners) -> {
                Map perStage = this.listenersPerStage.computeIfAbsent((String)n, name -> new HashMap());
                listeners.forEach((s, lst) -> {
                    List newLst = perStage.computeIfAbsent(s, stage -> new ArrayList());
                    newLst.addAll(lst);
                });
            });
            this.listenersPerName = new HashMap<String, TriggerListener>(listenersPerName);
        }

        public TriggerListeners copy() {
            return new TriggerListeners(this.listenersPerStage, this.listenersPerName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setAutoScalingConfig(AutoScalingConfig autoScalingConfig) {
            this.updateLock.lock();
            this.listenersPerStage.clear();
            try {
                Set triggerNames = autoScalingConfig.getTriggerConfigs().keySet();
                Map configs = autoScalingConfig.getTriggerListenerConfigs();
                Set listenerNames = configs.entrySet().stream().map(entry -> ((AutoScalingConfig.TriggerListenerConfig)entry.getValue()).name).collect(Collectors.toSet());
                Iterator<Map.Entry<String, TriggerListener>> it = this.listenersPerName.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, TriggerListener> entry2 = it.next();
                    String name = entry2.getKey();
                    TriggerListener listener = entry2.getValue();
                    if (triggerNames.contains(listener.getConfig().trigger) && listenerNames.contains(name)) continue;
                    try {
                        listener.close();
                    }
                    catch (Exception e) {
                        log.warn("Exception closing old listener " + listener.getConfig(), (Throwable)e);
                    }
                    it.remove();
                }
                for (Map.Entry entry3 : configs.entrySet()) {
                    AutoScalingConfig.TriggerListenerConfig config = (AutoScalingConfig.TriggerListenerConfig)entry3.getValue();
                    if (!triggerNames.contains(config.trigger)) {
                        log.debug("-- skipping listener for non-existent trigger: {}", (Object)config);
                        continue;
                    }
                    TriggerListener oldListener = this.listenersPerName.get(config.name);
                    TriggerListener listener = null;
                    if (oldListener != null) {
                        if (!oldListener.getConfig().equals((Object)config)) {
                            try {
                                oldListener.close();
                            }
                            catch (Exception e) {
                                log.warn("Exception closing old listener " + oldListener.getConfig(), (Throwable)e);
                            }
                        } else {
                            listener = oldListener;
                        }
                    }
                    if (listener == null) {
                        String clazz = config.listenerClass;
                        try {
                            listener = ScheduledTriggers.this.loader.newInstance(clazz, TriggerListener.class);
                        }
                        catch (Exception e) {
                            log.warn("Invalid TriggerListener class name '" + clazz + "', skipping...", (Throwable)e);
                        }
                        if (listener != null) {
                            try {
                                listener.configure(ScheduledTriggers.this.loader, ScheduledTriggers.this.cloudManager, config);
                                listener.init();
                                this.listenersPerName.put(config.name, listener);
                            }
                            catch (Exception e) {
                                log.warn("Error initializing TriggerListener " + config, (Throwable)e);
                                IOUtils.closeQuietly((Closeable)listener);
                                listener = null;
                            }
                        }
                    }
                    if (listener == null) continue;
                    for (TriggerEventProcessorStage stage : config.stages) {
                        this.addPerStage(config.trigger, stage, listener);
                    }
                    if (!config.beforeActions.isEmpty()) {
                        this.addPerStage(config.trigger, TriggerEventProcessorStage.BEFORE_ACTION, listener);
                    }
                    if (config.afterActions.isEmpty()) continue;
                    this.addPerStage(config.trigger, TriggerEventProcessorStage.AFTER_ACTION, listener);
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }

        private void addPerStage(String triggerName, TriggerEventProcessorStage stage, TriggerListener listener) {
            Map perStage = this.listenersPerStage.computeIfAbsent(triggerName, k -> new HashMap());
            List lst = perStage.computeIfAbsent(stage, k -> new ArrayList(3));
            lst.add(listener);
        }

        void reset() {
            this.updateLock.lock();
            try {
                this.listenersPerStage.clear();
                for (TriggerListener listener : this.listenersPerName.values()) {
                    IOUtils.closeQuietly((Closeable)listener);
                }
                this.listenersPerName.clear();
            }
            finally {
                this.updateLock.unlock();
            }
        }

        void close() {
            this.reset();
        }

        List<TriggerListener> getTriggerListeners(String trigger, TriggerEventProcessorStage stage) {
            Map<TriggerEventProcessorStage, List<TriggerListener>> perStage = this.listenersPerStage.get(trigger);
            if (perStage == null) {
                return Collections.emptyList();
            }
            List<TriggerListener> lst = perStage.get(stage);
            if (lst == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(lst);
        }

        void fireListeners(String trigger, TriggerEvent event, TriggerEventProcessorStage stage) {
            this.fireListeners(trigger, event, stage, null, null, null, null);
        }

        void fireListeners(String trigger, TriggerEvent event, TriggerEventProcessorStage stage, String message) {
            this.fireListeners(trigger, event, stage, null, null, null, message);
        }

        void fireListeners(String trigger, TriggerEvent event, TriggerEventProcessorStage stage, String actionName, ActionContext context) {
            this.fireListeners(trigger, event, stage, actionName, context, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireListeners(String trigger, TriggerEvent event, TriggerEventProcessorStage stage, String actionName, ActionContext context, Throwable error, String message) {
            this.updateLock.lock();
            try {
                for (TriggerListener listener : this.getTriggerListeners(trigger, stage)) {
                    if (!listener.isEnabled()) continue;
                    if (actionName != null) {
                        AutoScalingConfig.TriggerListenerConfig config = listener.getConfig();
                        if (stage == TriggerEventProcessorStage.BEFORE_ACTION ? !config.beforeActions.contains(actionName) : stage == TriggerEventProcessorStage.AFTER_ACTION && !config.afterActions.contains(actionName)) continue;
                    }
                    try {
                        listener.onEvent(event, stage, actionName, context, error, message);
                    }
                    catch (Exception e) {
                        log.warn("Exception running listener " + listener.getConfig(), (Throwable)e);
                    }
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
    }

    private class TriggerWrapper
    implements Runnable,
    Closeable {
        AutoScaling.Trigger trigger;
        ScheduledFuture<?> scheduledFuture;
        TriggerEventQueue queue;
        boolean replay;
        volatile boolean isClosed;

        TriggerWrapper(AutoScaling.Trigger trigger, SolrCloudManager cloudManager, Stats stats) throws IOException {
            this.trigger = trigger;
            this.queue = new TriggerEventQueue(cloudManager, trigger.getName(), stats);
            this.replay = true;
            this.isClosed = false;
        }

        public void setReplay(boolean replay) {
            this.replay = replay;
        }

        public boolean enqueue(TriggerEvent event) {
            if (this.isClosed) {
                throw new AlreadyClosedException("ScheduledTrigger " + this.trigger.getName() + " has been closed.");
            }
            return this.queue.offerEvent(event);
        }

        public TriggerEvent dequeue() {
            if (this.isClosed) {
                throw new AlreadyClosedException("ScheduledTrigger " + this.trigger.getName() + " has been closed.");
            }
            TriggerEvent event = this.queue.pollEvent();
            return event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.isClosed) {
                throw new AlreadyClosedException("ScheduledTrigger " + this.trigger.getName() + " has been closed.");
            }
            if (!ScheduledTriggers.this.hasPendingActions.get()) {
                TriggerWrapper triggerWrapper = this;
                synchronized (triggerWrapper) {
                    if (this.replay) {
                        TriggerEvent event;
                        while ((event = this.queue.peekEvent()) != null) {
                            event.getProperties().put("replaying", true);
                            if (!this.trigger.getProcessor().process(event)) {
                                log.error("Failed to re-play event, discarding: " + event);
                            }
                            this.queue.pollEvent();
                        }
                        try {
                            this.trigger.restoreState();
                        }
                        catch (Exception e) {
                            log.error("Error restoring trigger state " + this.trigger.getName(), (Throwable)e);
                        }
                        this.replay = false;
                    }
                    try {
                        this.trigger.run();
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception from trigger: " + this.trigger.getName(), (Throwable)e);
                    }
                    finally {
                        this.trigger.saveState();
                    }
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.isClosed = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
            IOUtils.closeQuietly((Closeable)this.trigger);
        }
    }
}

