/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ZkDistributedQueue;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.util.TestInjection;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitShardCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public SplitShardCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.split(state, message, results);
    }

    public boolean split(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        String collectionName = message.getStr("collection");
        log.info("Split shard invoked");
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        zkStateReader.forceUpdateCollection(collectionName);
        AtomicReference<String> slice = new AtomicReference<String>();
        slice.set(message.getStr("shard"));
        String splitKey = message.getStr("split.key");
        DocCollection collection = clusterState.getCollection(collectionName);
        PolicyHelper.SessionWrapper sessionWrapper = null;
        Slice parentSlice = SplitShardCmd.getParentSlice(clusterState, collectionName, slice, splitKey);
        Replica parentShardLeader = null;
        try {
            parentShardLeader = zkStateReader.getLeaderRetry(collectionName, slice.get(), 10000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Stat leaderZnodeStat = zkStateReader.getZkClient().exists("/live_nodes/" + parentShardLeader.getNodeName(), null, true);
        if (leaderZnodeStat == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard leader node: " + parentShardLeader.getNodeName() + " is not live anymore!");
        }
        ArrayList<DocRouter.Range> subRanges = new ArrayList<DocRouter.Range>();
        ArrayList<String> subSlices = new ArrayList<String>();
        ArrayList<String> subShardNames = new ArrayList<String>();
        String rangesStr = SplitShardCmd.fillRanges(this.ocmh.cloudManager, message, collection, parentSlice, subRanges, subSlices, subShardNames);
        try {
            Object m;
            ZkDistributedQueue inQueue;
            String subShardName;
            int i;
            boolean oldShardsDeleted = false;
            for (String subSlice : subSlices) {
                Slice oSlice = collection.getSlice(subSlice);
                if (oSlice == null) continue;
                Slice.State state = oSlice.getState();
                if (state == Slice.State.ACTIVE) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sub-shard: " + subSlice + " exists in active state. Aborting split shard.");
                }
                if (state != Slice.State.CONSTRUCTION && state != Slice.State.RECOVERY) continue;
                log.info("Sub-shard: {} already exists therefore requesting its deletion", (Object)subSlice);
                HashMap<String, String> propMap2 = new HashMap<String, String>();
                propMap2.put("operation", "deleteshard");
                propMap2.put("collection", collectionName);
                propMap2.put("shard", subSlice);
                ZkNodeProps m2 = new ZkNodeProps(propMap2);
                try {
                    this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETESHARD).call(clusterState, m2, new NamedList());
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to delete already existing sub shard: " + subSlice, (Throwable)e);
                }
                oldShardsDeleted = true;
            }
            if (oldShardsDeleted) {
                clusterState = zkStateReader.getClusterState();
                collection = clusterState.getCollection(collectionName);
            }
            String asyncId = message.getStr("async");
            HashMap<String, String> requestMap = new HashMap<String, String>();
            String nodeName = parentShardLeader.getNodeName();
            for (int i2 = 0; i2 < subRanges.size(); ++i2) {
                String subSlice = (String)subSlices.get(i2);
                String subShardName2 = (String)subShardNames.get(i2);
                DocRouter.Range subRange = (DocRouter.Range)subRanges.get(i2);
                log.info("Creating slice " + (String)subSlice + " of collection " + collectionName + " on " + nodeName);
                HashMap<String, Object> propMap3 = new HashMap<String, Object>();
                propMap3.put("operation", CollectionParams.CollectionAction.CREATESHARD.toLower());
                propMap3.put("shard", subSlice);
                propMap3.put("collection", collectionName);
                propMap3.put("shard_range", subRange.toString());
                propMap3.put("shard_state", Slice.State.CONSTRUCTION.toString());
                propMap3.put("shard_parent", parentSlice.getName());
                propMap3.put("shard_parent_node", parentShardLeader.getNodeName());
                propMap3.put("shard_parent_zk_session", leaderZnodeStat.getEphemeralOwner());
                ZkDistributedQueue inQueue2 = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
                inQueue2.offer(Utils.toJSON((Object)new ZkNodeProps(propMap3)));
                this.ocmh.waitForNewShard(collectionName, subSlice);
                clusterState = zkStateReader.getClusterState();
                log.info("Adding replica " + subShardName2 + " as part of slice " + (String)subSlice + " of collection " + collectionName + " on " + nodeName);
                propMap3 = new HashMap();
                propMap3.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                propMap3.put("collection", collectionName);
                propMap3.put("shard", subSlice);
                propMap3.put("node", nodeName);
                propMap3.put("name", subShardName2);
                propMap3.put("waitForFinalState", Boolean.toString(waitForFinalState));
                for (Object key : message.keySet()) {
                    if (!((String)key).startsWith("property.")) continue;
                    propMap3.put((String)key, message.getStr((String)key));
                }
                if (asyncId != null) {
                    propMap3.put("async", asyncId);
                }
                this.ocmh.addReplica(clusterState, new ZkNodeProps(propMap3), results, null);
            }
            ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD failed to create subshard leaders", asyncId, requestMap);
            for (String subShardName2 : subShardNames) {
                log.info("Asking parent leader to wait for: " + subShardName2 + " to be alive on: " + nodeName);
                String coreNodeName = this.ocmh.waitForCoreNodeName(collectionName, nodeName, subShardName2);
                CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                cmd.setCoreName(subShardName2);
                cmd.setNodeName(nodeName);
                cmd.setCoreNodeName(coreNodeName);
                cmd.setState(Replica.State.ACTIVE);
                cmd.setCheckLive(Boolean.valueOf(true));
                cmd.setOnlyIfLeader(true);
                ModifiableSolrParams p = new ModifiableSolrParams(cmd.getParams());
                this.ocmh.sendShardRequest(nodeName, p, shardHandler, asyncId, requestMap);
            }
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD timed out waiting for subshard leaders to come up", asyncId, requestMap);
            log.info("Successfully created all sub-shards for collection " + collectionName + " parent shard: " + slice + " on: " + parentShardLeader);
            log.info("Splitting shard " + parentShardLeader.getName() + " as part of slice " + slice + " of collection " + collectionName + " on " + parentShardLeader);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.SPLIT.toString()});
            params.set("core", new String[]{parentShardLeader.getStr("core")});
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                params.add("targetCore", new String[]{subShardName});
            }
            params.set("ranges", new String[]{rangesStr});
            this.ocmh.sendShardRequest(parentShardLeader.getNodeName(), params, shardHandler, asyncId, requestMap);
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD failed to invoke SPLIT core admin command", asyncId, requestMap);
            log.info("Index on shard: " + nodeName + " split into two successfully");
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                log.info("Applying buffered updates on : " + subShardName);
                params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
                params.set("name", new String[]{subShardName});
                this.ocmh.sendShardRequest(nodeName, params, shardHandler, asyncId, requestMap);
            }
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD failed while asking sub shard leaders to apply buffered updates", asyncId, requestMap);
            log.info("Successfully applied buffered updates on : " + subShardNames);
            int repFactor = parentSlice.getReplicas().size();
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            nodeList.remove(nodeName);
            List<ReplicaPosition> replicaPositions = Assign.identifyNodes(this.ocmh.cloudManager, clusterState, new ArrayList<String>(clusterState.getLiveNodes()), collectionName, new ZkNodeProps(collection.getProperties()), subSlices, repFactor - 1, 0, 0);
            sessionWrapper = PolicyHelper.getLastSessionWrapper((boolean)true);
            ArrayList replicas = new ArrayList((repFactor - 1) * 2);
            for (ReplicaPosition replicaPosition : replicaPositions) {
                String sliceName = replicaPosition.shard;
                String string = replicaPosition.node;
                String solrCoreName = collectionName + "_" + sliceName + "_replica" + replicaPosition.index;
                log.info("Creating replica shard " + (String)solrCoreName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + string);
                ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toLower(), "collection", collectionName, "shard", sliceName, "core", solrCoreName, "state", Replica.State.DOWN.toString(), "base_url", zkStateReader.getBaseUrlForNodeName(string), "node_name", string, "waitForFinalState", Boolean.toString(waitForFinalState)});
                Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)props));
                HashMap<String, Object> propMap4 = new HashMap<String, Object>();
                propMap4.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                propMap4.put("collection", collectionName);
                propMap4.put("shard", sliceName);
                propMap4.put("node", string);
                propMap4.put("name", solrCoreName);
                for (String key : message.keySet()) {
                    if (!key.startsWith("property.")) continue;
                    propMap4.put(key, message.getStr(key));
                }
                if (asyncId != null) {
                    propMap4.put("async", asyncId);
                }
                propMap4.put("skipCreateReplicaInClusterState", "true");
                propMap4.put("waitForFinalState", Boolean.toString(waitForFinalState));
                replicas.add(propMap4);
            }
            assert (TestInjection.injectSplitFailureBeforeReplicaCreation());
            long ephemeralOwner = leaderZnodeStat.getEphemeralOwner();
            leaderZnodeStat = zkStateReader.getZkClient().exists("/live_nodes/" + parentShardLeader.getNodeName(), null, true);
            if (leaderZnodeStat == null || ephemeralOwner != leaderZnodeStat.getEphemeralOwner()) {
                inQueue = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                for (String subSlice : subSlices) {
                    hashMap.put(subSlice, Slice.State.RECOVERY_FAILED.toString());
                }
                hashMap.put("collection", collectionName);
                m = new ZkNodeProps(hashMap);
                inQueue.offer(Utils.toJSON((Object)m));
                if (leaderZnodeStat == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard leader node: " + parentShardLeader.getNodeName() + " is not live anymore!");
                }
                if (ephemeralOwner != leaderZnodeStat.getEphemeralOwner()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The zk session id for the shard leader node: " + parentShardLeader.getNodeName() + " has changed from " + ephemeralOwner + " to " + leaderZnodeStat.getEphemeralOwner() + ". This can cause data loss so we must abort the split");
                }
            }
            if (repFactor == 1) {
                log.info("Replication factor is 1 so switching shard states");
                inQueue = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                hashMap.put(slice.get(), Slice.State.INACTIVE.toString());
                for (String subSlice : subSlices) {
                    hashMap.put(subSlice, Slice.State.ACTIVE.toString());
                }
                hashMap.put("collection", collectionName);
                m = new ZkNodeProps(hashMap);
                inQueue.offer(Utils.toJSON((Object)m));
            } else {
                log.info("Requesting shard state be set to 'recovery'");
                inQueue = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                for (String subSlice : subSlices) {
                    hashMap.put(subSlice, Slice.State.RECOVERY.toString());
                }
                hashMap.put("collection", collectionName);
                m = new ZkNodeProps(hashMap);
                inQueue.offer(Utils.toJSON((Object)m));
            }
            for (Map map : replicas) {
                this.ocmh.addReplica(clusterState, new ZkNodeProps(map), results, null);
            }
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD failed to create subshard replicas", asyncId, requestMap);
            log.info("Successfully created all replica shards for all sub-slices " + subSlices);
            this.ocmh.commit(results, slice.get(), parentShardLeader);
            boolean bl = true;
            return bl;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing split operation for collection: " + collectionName + " parent shard: " + slice, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
        }
        finally {
            if (sessionWrapper != null) {
                sessionWrapper.release();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Slice getParentSlice(ClusterState clusterState, String collectionName, AtomicReference<String> slice, String splitKey) {
        Slice parentSlice;
        DocRouter router;
        DocCollection collection = clusterState.getCollection(collectionName);
        DocRouter docRouter = router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        if (slice.get() == null) {
            if (!(router instanceof CompositeIdRouter)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Split by route key can only be used with CompositeIdRouter or subclass. Found router: " + router.getClass().getName());
            Collection searchSlices = router.getSearchSlicesSingle(splitKey, (SolrParams)new ModifiableSolrParams(), collection);
            if (searchSlices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to find an active shard for split.key: " + splitKey);
            }
            if (searchSlices.size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Splitting a split.key: " + splitKey + " which spans multiple shards is not supported");
            }
            parentSlice = (Slice)searchSlices.iterator().next();
            slice.set(parentSlice.getName());
            log.info("Split by route.key: {}, parent shard is: {} ", (Object)splitKey, slice);
        } else {
            parentSlice = collection.getSlice(slice.get());
        }
        if (parentSlice != null) return parentSlice;
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
    }

    public static String fillRanges(SolrCloudManager cloudManager, ZkNodeProps message, DocCollection collection, Slice parentSlice, List<DocRouter.Range> subRanges, List<String> subSlices, List<String> subShardNames) {
        int i;
        String splitKey = message.getStr("split.key");
        DocRouter.Range range = parentSlice.getRange();
        if (range == null) {
            range = new PlainIdRouter().fullRange();
        }
        DocRouter router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        String rangesStr = message.getStr("ranges");
        if (rangesStr != null) {
            String[] ranges = rangesStr.split(",");
            if (ranges.length == 0 || ranges.length == 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least two ranges specified to split a shard");
            }
            for (int i2 = 0; i2 < ranges.length; ++i2) {
                String r = ranges[i2];
                try {
                    subRanges.add(DocRouter.DEFAULT.fromString(r));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception in parsing hexadecimal hash range: " + r, (Throwable)e);
                }
                if (subRanges.get(i2).isSubsetOf(range)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash range: " + r + " is not a subset of parent shard's range: " + range.toString());
            }
            ArrayList<DocRouter.Range> temp = new ArrayList<DocRouter.Range>(subRanges);
            Collections.sort(temp);
            if (!range.equals((Object)new DocRouter.Range(((DocRouter.Range)temp.get((int)0)).min, ((DocRouter.Range)temp.get((int)(temp.size() - 1))).max))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " do not cover the entire range of parent shard: " + range);
            }
            for (i = 1; i < temp.size(); ++i) {
                if (((DocRouter.Range)temp.get((int)(i - 1))).max + 1 == ((DocRouter.Range)temp.get((int)i)).min) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " either overlap with each other or do not cover the entire range of parent shard: " + range);
            }
        } else if (splitKey != null) {
            if (router instanceof CompositeIdRouter) {
                CompositeIdRouter compositeIdRouter = (CompositeIdRouter)router;
                List tmpSubRanges = compositeIdRouter.partitionRangeByKey(splitKey, range);
                if (tmpSubRanges.size() == 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " has a hash range that is exactly equal to hash range of shard: " + parentSlice.getName());
                }
                for (DocRouter.Range subRange : tmpSubRanges) {
                    if (subRange.min != subRange.max) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " must be a compositeId");
                }
                subRanges.addAll(tmpSubRanges);
                log.info("Partitioning parent shard " + parentSlice.getName() + " range: " + parentSlice.getRange() + " yields: " + subRanges);
                rangesStr = "";
                for (i = 0; i < subRanges.size(); ++i) {
                    DocRouter.Range subRange;
                    subRange = subRanges.get(i);
                    rangesStr = rangesStr + subRange.toString();
                    if (i >= subRanges.size() - 1) continue;
                    rangesStr = rangesStr + ',';
                }
            }
        } else {
            subRanges.addAll(router.partitionRange(2, range));
        }
        for (int i3 = 0; i3 < subRanges.size(); ++i3) {
            String subSlice = parentSlice.getName() + "_" + i3;
            subSlices.add(subSlice);
            String subShardName = Assign.buildSolrCoreName(cloudManager.getDistribStateManager(), collection, subSlice, Replica.Type.NRT);
            subShardNames.add(subShardName);
        }
        return rangesStr;
    }
}

