/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.api.collections.DeleteReplicaCmd;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.api.collections.ReplaceNodeCmd;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.NamedList;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteNodeCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public DeleteNodeCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.ocmh.checkRequired(message, "node");
        String node = message.getStr("node");
        if (!state.liveNodesContain(node)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source Node: " + node + " is not live");
        }
        List<ZkNodeProps> sourceReplicas = ReplaceNodeCmd.getReplicasOfNode(node, state);
        List<String> singleReplicas = DeleteNodeCmd.verifyReplicaAvailability(sourceReplicas, state);
        if (!singleReplicas.isEmpty()) {
            results.add("failure", (Object)("Can't delete the only existing non-PULL replica(s) on node " + node + ": " + singleReplicas.toString()));
        } else {
            DeleteNodeCmd.cleanupReplicas(results, state, sourceReplicas, this.ocmh, node, message.getStr("async"));
        }
    }

    static List<String> verifyReplicaAvailability(List<ZkNodeProps> sourceReplicas, ClusterState state) {
        ArrayList<String> res = new ArrayList<String>();
        for (ZkNodeProps sourceReplica : sourceReplicas) {
            String coll = sourceReplica.getStr("collection");
            String shard = sourceReplica.getStr("shard");
            String replicaName = sourceReplica.getStr("replica");
            DocCollection collection = state.getCollection(coll);
            Slice slice = collection.getSlice(shard);
            if (slice.getReplicas().size() < 2) {
                res.add(coll + "/" + shard + "/" + replicaName + ", type=" + sourceReplica.getStr("type"));
                continue;
            }
            int otherNonPullReplicas = 0;
            for (Replica r : slice.getReplicas()) {
                if (r.getName().equals(replicaName) || r.getType().equals((Object)Replica.Type.PULL)) continue;
                ++otherNonPullReplicas;
            }
            if (otherNonPullReplicas != 0) continue;
            res.add(coll + "/" + shard + "/" + replicaName + ", type=" + sourceReplica.getStr("type"));
        }
        return res;
    }

    static void cleanupReplicas(NamedList results, ClusterState clusterState, List<ZkNodeProps> sourceReplicas, OverseerCollectionMessageHandler ocmh, String node, String async) throws InterruptedException {
        CountDownLatch cleanupLatch = new CountDownLatch(sourceReplicas.size());
        for (ZkNodeProps sourceReplica : sourceReplicas) {
            String coll = sourceReplica.getStr("collection");
            String shard = sourceReplica.getStr("shard");
            String type = sourceReplica.getStr("type");
            log.info("Deleting replica type={} for collection={} shard={} on node={}", new Object[]{type, coll, shard, node});
            NamedList deleteResult = new NamedList();
            try {
                if (async != null) {
                    sourceReplica = sourceReplica.plus("async", (Object)async);
                }
                ((DeleteReplicaCmd)ocmh.commandMap.get(CollectionParams.CollectionAction.DELETEREPLICA)).deleteReplica(clusterState, sourceReplica.plus("parallel", (Object)"true"), deleteResult, () -> {
                    cleanupLatch.countDown();
                    if (deleteResult.get("failure") != null) {
                        NamedList namedList = results;
                        synchronized (namedList) {
                            results.add("failure", (Object)String.format(Locale.ROOT, "Failed to delete replica for collection=%s shard=%s on node=%s", coll, shard, node));
                        }
                    }
                });
            }
            catch (KeeperException e) {
                log.warn("Error deleting ", (Throwable)e);
                cleanupLatch.countDown();
            }
            catch (Exception e) {
                log.warn("Error deleting ", (Throwable)e);
                cleanupLatch.countDown();
                throw e;
            }
        }
        log.debug("Waiting for delete node action to complete");
        cleanupLatch.await(5L, TimeUnit.MINUTES);
    }
}

