/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.NonExistentCoreException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.admin.MetricsHistoryHandler;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCollectionCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;
    private final TimeSource timeSource;

    public DeleteCollectionCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
        this.timeSource = ocmh.cloudManager.getTimeSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String collection = message.getStr("name");
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        this.checkNotReferencedByAlias(zkStateReader, collection);
        boolean deleteHistory = message.getBool("deleteMetricsHistory", true);
        boolean removeCounterNode = true;
        try {
            MetricsHistoryHandler historyHandler;
            SolrZkClient zkClient = zkStateReader.getZkClient();
            SolrSnapshotManager.cleanupCollectionLevelSnapshots(zkClient, collection);
            if (zkStateReader.getClusterState().getCollectionOrNull(collection) == null && zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                return;
            }
            if (deleteHistory && (historyHandler = this.ocmh.overseer.getCoreContainer().getMetricsHistoryHandler()) != null) {
                String registry = SolrMetricManager.getRegistryName(SolrInfoBean.Group.collection, collection);
                historyHandler.removeHistory(registry);
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
            params.set("deleteInstanceDir", true);
            params.set("deleteDataDir", true);
            params.set("deleteMetricsHistory", deleteHistory);
            String asyncId = message.getStr("async");
            HashMap<String, String> requestMap = null;
            if (asyncId != null) {
                requestMap = new HashMap<String, String>();
            }
            HashSet<String> okayExceptions = new HashSet<String>(1);
            okayExceptions.add(NonExistentCoreException.class.getName());
            List<Replica> failedReplicas = this.ocmh.collectionCmd(message, params, results, null, asyncId, requestMap, okayExceptions);
            for (Replica failedRepilca : failedReplicas) {
                boolean isSharedFS = failedRepilca.getBool("shared_storage", false) && failedRepilca.get("dataDir") != null;
                if (!isSharedFS) continue;
                removeCounterNode = false;
                break;
            }
            ZkNodeProps m = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collection});
            Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)m));
            TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS, this.timeSource);
            boolean removed = false;
            while (!timeout.hasTimedOut()) {
                timeout.sleep(100L);
                removed = !zkStateReader.getClusterState().hasCollection(collection);
                if (!removed) continue;
                timeout.sleep(500L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + collection);
            }
        }
        finally {
            try {
                String collectionPath = ZkStateReader.getCollectionPathRoot((String)collection);
                if (zkStateReader.getZkClient().exists(collectionPath, true).booleanValue()) {
                    if (removeCounterNode) {
                        zkStateReader.getZkClient().clean(collectionPath);
                    } else {
                        String counterNodePath = Assign.getCounterNodePath(collection);
                        zkStateReader.getZkClient().clean(collectionPath, s -> !s.equals(counterNodePath));
                    }
                }
            }
            catch (InterruptedException e) {
                SolrException.log((Logger)log, (String)("Cleaning up collection in zk was interrupted:" + collection), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                SolrException.log((Logger)log, (String)("Problem cleaning up collection in zk:" + collection), (Throwable)e);
            }
        }
    }

    private void checkNotReferencedByAlias(ZkStateReader zkStateReader, String collection) throws Exception {
        String alias = this.referencedByAlias(collection, zkStateReader.getAliases());
        if (alias != null) {
            zkStateReader.aliasesManager.update();
            alias = this.referencedByAlias(collection, zkStateReader.getAliases());
            if (alias != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Collection : " + collection + " is part of alias " + alias + " remove or modify the alias before removing this collection.");
            }
        }
    }

    private String referencedByAlias(String collection, Aliases aliases) {
        return aliases.getCollectionAliasListMap().entrySet().stream().filter(e -> ((List)e.getValue()).contains(collection)).map(Map.Entry::getKey).findFirst().orElse(null);
    }
}

