/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.NonExistentCoreException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Pair;
import org.apache.solr.core.CoreContainer;

public class TestInjection {
    private static final Pattern ENABLED_PERCENT = Pattern.compile("(true|false)(?:\\:(\\d+))?$", 2);
    private static final Random RANDOM;
    public static String nonGracefullClose;
    public static String failReplicaRequests;
    public static String failUpdateRequests;
    public static String nonExistentCoreExceptionAfterUnload;
    private static Set<Timer> timers;

    public static void reset() {
        nonGracefullClose = null;
        failReplicaRequests = null;
        failUpdateRequests = null;
        nonExistentCoreExceptionAfterUnload = null;
        for (Timer timer : timers) {
            timer.cancel();
        }
    }

    public static boolean injectNonGracefullClose(CoreContainer cc) {
        if (cc.isShutDown() && nonGracefullClose != null) {
            Pair<Boolean, Integer> pair = TestInjection.parseValue(nonGracefullClose);
            boolean enabled = (Boolean)pair.getKey();
            int chanceIn100 = (Integer)pair.getValue();
            if (enabled && RANDOM.nextInt(100) >= 100 - chanceIn100) {
                if (RANDOM.nextBoolean()) {
                    throw new TestShutdownFailError("Test exception for non graceful close");
                }
                final Thread cthread = Thread.currentThread();
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(RANDOM.nextInt(1000));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        cthread.interrupt();
                        timers.remove(this);
                        this.cancel();
                    }
                };
                Timer timer = new Timer();
                timers.add(timer);
                timer.schedule(task, RANDOM.nextInt(500));
            }
        }
        return true;
    }

    public static boolean injectFailReplicaRequests() {
        if (failReplicaRequests != null) {
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failReplicaRequests);
            boolean enabled = (Boolean)pair.getKey();
            int chanceIn100 = (Integer)pair.getValue();
            if (enabled && RANDOM.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test update fail");
            }
        }
        return true;
    }

    public static boolean injectFailUpdateRequests() {
        if (failUpdateRequests != null) {
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failUpdateRequests);
            boolean enabled = (Boolean)pair.getKey();
            int chanceIn100 = (Integer)pair.getValue();
            if (enabled && RANDOM.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test update fail");
            }
        }
        return true;
    }

    public static boolean injectNonExistentCoreExceptionAfterUnload(String cname) {
        if (nonExistentCoreExceptionAfterUnload != null) {
            Pair<Boolean, Integer> pair = TestInjection.parseValue(nonExistentCoreExceptionAfterUnload);
            boolean enabled = (Boolean)pair.getKey();
            int chanceIn100 = (Integer)pair.getValue();
            if (enabled && RANDOM.nextInt(100) >= 100 - chanceIn100) {
                throw new NonExistentCoreException("Core not found to unload: " + cname);
            }
        }
        return true;
    }

    private static Pair<Boolean, Integer> parseValue(String raw) {
        Matcher m = ENABLED_PERCENT.matcher(raw);
        if (!m.matches()) {
            throw new RuntimeException("No match, probably bad syntax: " + raw);
        }
        String val = m.group(1);
        String percent = "100";
        if (m.groupCount() == 2) {
            percent = m.group(2);
        }
        return new Pair((Object)Boolean.parseBoolean(val), (Object)Integer.parseInt(percent));
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
        nonGracefullClose = null;
        failReplicaRequests = null;
        failUpdateRequests = null;
        nonExistentCoreExceptionAfterUnload = null;
        timers = Collections.synchronizedSet(new HashSet());
    }

    public static class TestShutdownFailError
    extends OutOfMemoryError {
        public TestShutdownFailError(String msg) {
            super(msg);
        }
    }
}

