/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoKeys {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, PublicKey> keys;
    private Exception exception;

    public CryptoKeys(Map<String, byte[]> trustedKeys) throws Exception {
        HashMap<String, PublicKey> m = new HashMap<String, PublicKey>();
        for (Map.Entry<String, byte[]> e : trustedKeys.entrySet()) {
            m.put(e.getKey(), CryptoKeys.getX509PublicKey(e.getValue()));
        }
        this.keys = m;
    }

    public String verify(String sig, ByteBuffer data) {
        this.exception = null;
        for (Map.Entry<String, PublicKey> entry : this.keys.entrySet()) {
            try {
                boolean verified = CryptoKeys.verify(entry.getValue(), Base64.base64ToByteArray((String)sig), data);
                log.info("verified {} ", (Object)verified);
                if (!verified) continue;
                return entry.getKey();
            }
            catch (Exception e) {
                this.exception = e;
                log.info("NOT verified  ");
            }
        }
        return null;
    }

    public static PublicKey getX509PublicKey(byte[] buf) throws Exception {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(buf);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verify(PublicKey publicKey, byte[] sig, ByteBuffer data) throws InvalidKeyException, SignatureException {
        int oldPos = data.position();
        Signature signature = null;
        try {
            boolean verify;
            signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(publicKey);
            signature.update(data);
            boolean bl = verify = signature.verify(sig);
            return bl;
        }
        catch (NoSuchAlgorithmException e) {
        }
        finally {
            data.position(oldPos);
        }
        return false;
    }

    private static byte[][] evpBytesTokey(int key_len, int iv_len, MessageDigest md, byte[] salt, byte[] data, int count) {
        byte[][] both = new byte[2][];
        byte[] key = new byte[key_len];
        int key_ix = 0;
        byte[] iv = new byte[iv_len];
        int iv_ix = 0;
        both[0] = key;
        both[1] = iv;
        byte[] md_buf = null;
        int nkey = key_len;
        int niv = iv_len;
        int i = 0;
        if (data == null) {
            return both;
        }
        int addmd = 0;
        do {
            md.reset();
            if (addmd++ > 0) {
                md.update(md_buf);
            }
            md.update(data);
            if (null != salt) {
                md.update(salt, 0, 8);
            }
            md_buf = md.digest();
            for (i = 1; i < count; ++i) {
                md.reset();
                md.update(md_buf);
                md_buf = md.digest();
            }
            if (nkey > 0) {
                for (i = 0; nkey != 0 && i != md_buf.length; --nkey, ++i) {
                    key[key_ix++] = md_buf[i];
                }
            }
            if (niv <= 0 || i == md_buf.length) continue;
            while (niv != 0 && i != md_buf.length) {
                iv[iv_ix++] = md_buf[i];
                --niv;
                ++i;
            }
        } while (nkey != 0 || niv != 0);
        for (i = 0; i < md_buf.length; ++i) {
            md_buf[i] = 0;
        }
        return both;
    }

    public static String decodeAES(String base64CipherTxt, String pwd) {
        int[] strengths = new int[]{256, 192, 128};
        Exception e = null;
        for (int strength : strengths) {
            try {
                return CryptoKeys.decodeAES(base64CipherTxt, pwd, strength);
            }
            catch (Exception exp) {
                e = exp;
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error decoding ", e);
    }

    public static String decodeAES(String base64CipherTxt, String pwd, int keySizeBits) {
        Charset ASCII = Charset.forName("ASCII");
        boolean INDEX_KEY = false;
        boolean INDEX_IV = true;
        boolean ITERATIONS = true;
        int SALT_OFFSET = 8;
        int SALT_SIZE = 8;
        int CIPHERTEXT_OFFSET = 16;
        try {
            byte[] headerSaltAndCipherText = Base64.base64ToByteArray((String)base64CipherTxt);
            byte[] salt = Arrays.copyOfRange(headerSaltAndCipherText, 8, 16);
            byte[] encrypted = Arrays.copyOfRange(headerSaltAndCipherText, 16, headerSaltAndCipherText.length);
            Cipher aesCBC = Cipher.getInstance("AES/CBC/PKCS5Padding");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[][] keyAndIV = CryptoKeys.evpBytesTokey(keySizeBits / 8, aesCBC.getBlockSize(), md5, salt, pwd.getBytes(ASCII), 1);
            SecretKeySpec key = new SecretKeySpec(keyAndIV[0], "AES");
            IvParameterSpec iv = new IvParameterSpec(keyAndIV[1]);
            aesCBC.init(2, (Key)key, iv);
            byte[] decrypted = aesCBC.doFinal(encrypted);
            return new String(decrypted, ASCII);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException("Bad password, algorithm, mode or padding; no salt, wrong number of iterations or corrupted ciphertext.", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("Bad algorithm, mode or corrupted (resized) ciphertext.", e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublicKey deserializeX509PublicKey(String pubKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.base64ToByteArray((String)pubKey));
            return keyFactory.generatePublic(publicKeySpec);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public static byte[] decryptRSA(byte[] buffer, PublicKey pubKey) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher rsaCipher = null;
        try {
            rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        rsaCipher.init(2, pubKey);
        return rsaCipher.doFinal(buffer, 0, buffer.length);
    }

    public static void main(String[] args) throws Exception {
        RSAKeyPair keyPair = new RSAKeyPair();
        System.out.println(keyPair.getPublicKeyStr());
        PublicKey pk = CryptoKeys.deserializeX509PublicKey(keyPair.getPublicKeyStr());
        byte[] payload = "Hello World!".getBytes(StandardCharsets.UTF_8);
        byte[] encrypted = keyPair.encrypt(ByteBuffer.wrap(payload));
        String cipherBase64 = Base64.byteArrayToBase64((byte[])encrypted);
        System.out.println("encrypted: " + cipherBase64);
        System.out.println("signed: " + Base64.byteArrayToBase64((byte[])keyPair.signSha256(payload)));
        System.out.println("decrypted " + new String(CryptoKeys.decryptRSA(encrypted, pk), StandardCharsets.UTF_8));
    }

    public static class RSAKeyPair {
        private final String pubKeyStr;
        private final PublicKey publicKey;
        private final PrivateKey privateKey;
        private final SecureRandom random = new SecureRandom();

        public RSAKeyPair() {
            KeyPairGenerator keyGen = null;
            try {
                keyGen = KeyPairGenerator.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            keyGen.initialize(512);
            KeyPair keyPair = keyGen.genKeyPair();
            this.privateKey = keyPair.getPrivate();
            this.publicKey = keyPair.getPublic();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(this.publicKey.getEncoded());
            this.pubKeyStr = Base64.byteArrayToBase64((byte[])x509EncodedKeySpec.getEncoded());
        }

        public String getPublicKeyStr() {
            return this.pubKeyStr;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public byte[] encrypt(ByteBuffer buffer) {
            try {
                Cipher rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
                rsaCipher.init(1, this.privateKey);
                return rsaCipher.doFinal(buffer.array(), buffer.position(), buffer.limit());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }

        public byte[] signSha256(byte[] bytes) throws InvalidKeyException, SignatureException {
            Signature dsa = null;
            try {
                dsa = Signature.getInstance("SHA256withRSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            dsa.initSign(this.privateKey);
            dsa.update(bytes, 0, bytes.length);
            return dsa.sign();
        }
    }
}

