/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.IndexFingerprint;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerSync {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean debug = log.isDebugEnabled();
    private List<String> replicas;
    private int nUpdates;
    private int maxUpdates;
    private UpdateHandler uhandler;
    private UpdateLog ulog;
    private HttpShardHandlerFactory shardHandlerFactory;
    private ShardHandler shardHandler;
    private List<SyncShardRequest> requests = new ArrayList<SyncShardRequest>();
    private List<Long> startingVersions;
    private List<Long> ourUpdates;
    private Set<Long> ourUpdateSet;
    private Set<Long> requestedUpdateSet;
    private long ourLowThreshold;
    private long ourHighThreshold;
    private long ourHighest;
    private final boolean cantReachIsSuccess;
    private final boolean getNoVersionsIsSuccess;
    private final boolean doFingerprint;
    private final HttpClient client;
    private final boolean onlyIfActive;
    private SolrCore core;
    private static Comparator<Long> absComparator = new Comparator<Long>(){

        @Override
        public int compare(Long o1, Long o2) {
            long l2;
            long l1 = Math.abs(o1);
            if (l1 > (l2 = Math.abs(o2))) {
                return -1;
            }
            if (l1 < l2) {
                return 1;
            }
            return 0;
        }
    };
    private static Comparator<Object> updateRecordComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            long l2;
            if (!(o1 instanceof List)) {
                return 1;
            }
            if (!(o2 instanceof List)) {
                return -1;
            }
            List lst1 = (List)o1;
            List lst2 = (List)o2;
            long l1 = Math.abs((Long)lst1.get(1));
            if (l1 > (l2 = Math.abs((Long)lst2.get(1)))) {
                return 1;
            }
            if (l1 < l2) {
                return -1;
            }
            return 0;
        }
    };

    public PeerSync(SolrCore core, List<String> replicas, int nUpdates) {
        this(core, replicas, nUpdates, false, true);
    }

    public PeerSync(SolrCore core, List<String> replicas, int nUpdates, boolean cantReachIsSuccess, boolean getNoVersionsIsSuccess) {
        this(core, replicas, nUpdates, cantReachIsSuccess, getNoVersionsIsSuccess, false, true);
    }

    public PeerSync(SolrCore core, List<String> replicas, int nUpdates, boolean cantReachIsSuccess, boolean getNoVersionsIsSuccess, boolean onlyIfActive, boolean doFingerprint) {
        this.core = core;
        this.replicas = replicas;
        this.nUpdates = nUpdates;
        this.maxUpdates = nUpdates;
        this.cantReachIsSuccess = cantReachIsSuccess;
        this.getNoVersionsIsSuccess = getNoVersionsIsSuccess;
        this.doFingerprint = doFingerprint;
        this.client = core.getCoreDescriptor().getCoreContainer().getUpdateShardHandler().getHttpClient();
        this.onlyIfActive = onlyIfActive;
        this.uhandler = core.getUpdateHandler();
        this.ulog = this.uhandler.getUpdateLog();
        this.shardHandlerFactory = (HttpShardHandlerFactory)core.getCoreDescriptor().getCoreContainer().getShardHandlerFactory();
        this.shardHandler = this.shardHandlerFactory.getShardHandler(this.client);
    }

    public void setStartingVersions(List<Long> startingVersions) {
        this.startingVersions = startingVersions;
    }

    public long percentile(List<Long> arr, float frac) {
        int elem = (int)((float)arr.size() * frac);
        return Math.abs(arr.get(elem));
    }

    private String msg() {
        ZkController zkController = this.uhandler.core.getCoreDescriptor().getCoreContainer().getZkController();
        String myURL = "";
        if (zkController != null) {
            myURL = zkController.getBaseUrl();
        }
        return "PeerSync: core=" + this.uhandler.core.getName() + " url=" + myURL + " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync() {
        if (this.ulog == null) {
            return false;
        }
        MDCLoggingContext.setCore(this.core);
        try {
            ShardResponse srsp;
            log.info(this.msg() + "START replicas=" + this.replicas + " nUpdates=" + this.nUpdates);
            if (debug && this.startingVersions != null) {
                log.debug(this.msg() + "startingVersions=" + this.startingVersions.size() + " " + this.startingVersions);
            }
            for (String string : this.replicas) {
                this.requestVersions(string);
            }
            Throwable throwable = null;
            try (UpdateLog.RecentUpdates recentUpdates2 = this.ulog.getRecentUpdates();){
                this.ourUpdates = recentUpdates2.getVersions(this.nUpdates);
            }
            catch (Throwable x2) {
                Throwable throwable2 = x2;
                throw x2;
            }
            Collections.sort(this.ourUpdates, absComparator);
            if (this.startingVersions != null) {
                if (this.startingVersions.size() == 0) {
                    log.warn("no frame of reference to tell if we've missed updates");
                    boolean recentUpdates2 = false;
                    return recentUpdates2;
                }
                Collections.sort(this.startingVersions, absComparator);
                this.ourLowThreshold = this.percentile(this.startingVersions, 0.8f);
                this.ourHighThreshold = this.percentile(this.startingVersions, 0.2f);
                long smallestNewUpdate = Math.abs(this.ourUpdates.get(this.ourUpdates.size() - 1));
                if (Math.abs(this.startingVersions.get(0)) < smallestNewUpdate) {
                    log.warn(this.msg() + "too many updates received since start - startingUpdates no longer overlaps with our currentUpdates");
                    boolean x2 = false;
                    return x2;
                }
                ArrayList<Long> newList = new ArrayList<Long>(this.ourUpdates);
                for (Long ver : this.startingVersions) {
                    if (Math.abs(ver) >= smallestNewUpdate) continue;
                    newList.add(ver);
                }
                this.ourUpdates = newList;
                Collections.sort(this.ourUpdates, absComparator);
            } else if (this.ourUpdates.size() > 0) {
                this.ourLowThreshold = this.percentile(this.ourUpdates, 0.8f);
                this.ourHighThreshold = this.percentile(this.ourUpdates, 0.2f);
            } else {
                log.info(this.msg() + "DONE.  We have no versions.  sync failed.");
                boolean smallestNewUpdate = false;
                return smallestNewUpdate;
            }
            this.ourHighest = this.ourUpdates.get(0);
            this.ourUpdateSet = new HashSet<Long>(this.ourUpdates);
            this.requestedUpdateSet = new HashSet<Long>();
            while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
                boolean bl = this.handleResponse(srsp);
                if (bl) continue;
                log.info(this.msg() + "DONE. sync failed");
                this.shardHandler.cancelAll();
                boolean newList = false;
                return newList;
            }
            boolean success = true;
            for (SyncShardRequest sreq : this.requests) {
                if (!sreq.doFingerprintComparison || (success = this.compareFingerprint(sreq))) continue;
                break;
            }
            log.info(this.msg() + "DONE. sync " + (success ? "succeeded" : "failed"));
            boolean bl = success;
            return bl;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    private void requestVersions(String replica) {
        SyncShardRequest sreq = new SyncShardRequest();
        this.requests.add(sreq);
        sreq.purpose = 1;
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getVersions", this.nUpdates);
        sreq.params.set("fingerprint", this.doFingerprint);
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    private boolean handleResponse(ShardResponse srsp) {
        ShardRequest sreq = srsp.getShardRequest();
        if (srsp.getException() != null) {
            if (this.cantReachIsSuccess && sreq.purpose == 1 && srsp.getException() instanceof SolrServerException) {
                Throwable solrException = ((SolrServerException)srsp.getException()).getRootCause();
                boolean connectTimeoutExceptionInChain = this.connectTimeoutExceptionInChain(srsp.getException());
                if (connectTimeoutExceptionInChain || solrException instanceof ConnectException || solrException instanceof ConnectTimeoutException || solrException instanceof NoHttpResponseException || solrException instanceof SocketException) {
                    log.warn(this.msg() + " couldn't connect to " + srsp.getShardAddress() + ", counting as success", srsp.getException());
                    return true;
                }
            }
            if (this.cantReachIsSuccess && sreq.purpose == 1 && srsp.getException() instanceof SolrException && ((SolrException)srsp.getException()).code() == 503) {
                log.warn(this.msg() + " got a 503 from " + srsp.getShardAddress() + ", counting as success", srsp.getException());
                return true;
            }
            if (this.cantReachIsSuccess && sreq.purpose == 1 && srsp.getException() instanceof SolrException && ((SolrException)srsp.getException()).code() == 404) {
                log.warn(this.msg() + " got a 404 from " + srsp.getShardAddress() + ", counting as success. " + "Perhaps /get is not registered?", srsp.getException());
                return true;
            }
            log.warn(this.msg() + " exception talking to " + srsp.getShardAddress() + ", failed", srsp.getException());
            return false;
        }
        if (sreq.purpose == 1) {
            return this.handleVersions(srsp);
        }
        return this.handleUpdates(srsp);
    }

    private boolean connectTimeoutExceptionInChain(Throwable exception) {
        Throwable t = exception;
        while (true) {
            if (t instanceof ConnectTimeoutException) {
                return true;
            }
            Throwable cause = t.getCause();
            if (cause == null) break;
            t = cause;
        }
        return false;
    }

    private boolean handleVersions(ShardResponse srsp) {
        List otherVersions = (List)srsp.getSolrResponse().getResponse().get("versions");
        SyncShardRequest sreq = (SyncShardRequest)srsp.getShardRequest();
        sreq.reportedVersions = otherVersions;
        Object fingerprint = srsp.getSolrResponse().getResponse().get("fingerprint");
        log.info(this.msg() + " Received " + otherVersions.size() + " versions from " + sreq.shards[0] + " fingerprint:" + fingerprint);
        if (fingerprint != null) {
            sreq.fingerprint = IndexFingerprint.fromObject(fingerprint);
        }
        if (otherVersions.size() == 0) {
            return this.getNoVersionsIsSuccess;
        }
        boolean completeList = otherVersions.size() < this.nUpdates;
        Collections.sort(otherVersions, absComparator);
        if (debug) {
            log.debug(this.msg() + " sorted versions from " + sreq.shards[0] + " = " + otherVersions);
        }
        long otherHigh = this.percentile(otherVersions, 0.2f);
        long otherLow = this.percentile(otherVersions, 0.8f);
        long otherHighest = (Long)otherVersions.get(0);
        if (this.ourHighThreshold < otherLow) {
            log.info(this.msg() + " Our versions are too old. ourHighThreshold=" + this.ourHighThreshold + " otherLowThreshold=" + otherLow + " ourHighest=" + this.ourHighest + " otherHighest=" + otherHighest);
            return false;
        }
        if (this.ourLowThreshold > otherHigh) {
            log.info(this.msg() + " Our versions are newer. ourLowThreshold=" + this.ourLowThreshold + " otherHigh=" + otherHigh + " ourHighest=" + this.ourHighest + " otherHighest=" + otherHighest);
            return true;
        }
        ArrayList<Long> toRequest = new ArrayList<Long>();
        for (Long otherVersion : otherVersions) {
            if (!completeList && Math.abs(otherVersion) < this.ourLowThreshold) break;
            if (this.ourUpdateSet.contains(otherVersion) || this.requestedUpdateSet.contains(otherVersion)) continue;
            toRequest.add(otherVersion);
            this.requestedUpdateSet.add(otherVersion);
        }
        sreq.requestedUpdates = toRequest;
        if (toRequest.isEmpty()) {
            log.info(this.msg() + " No additional versions requested. ourLowThreshold=" + this.ourLowThreshold + " otherHigh=" + otherHigh + " ourHighest=" + this.ourHighest + " otherHighest=" + otherHighest);
            if (this.doFingerprint) {
                sreq.doFingerprintComparison = true;
            }
            return true;
        }
        if (toRequest.size() > this.maxUpdates) {
            log.info(this.msg() + " Failing due to needing too many updates:" + this.maxUpdates);
            return false;
        }
        return this.requestUpdates(srsp, toRequest);
    }

    private boolean compareFingerprint(SyncShardRequest sreq) {
        if (sreq.fingerprint == null) {
            return true;
        }
        try {
            IndexFingerprint ourFingerprint = IndexFingerprint.getFingerprint(this.core, Long.MAX_VALUE);
            int cmp = IndexFingerprint.compare(ourFingerprint, sreq.fingerprint);
            log.info("Fingerprint comparison: " + cmp);
            return cmp == 0;
        }
        catch (IOException e) {
            log.error(this.msg() + "Error getting index fingerprint", (Throwable)e);
            return false;
        }
    }

    private boolean requestUpdates(ShardResponse srsp, List<Long> toRequest) {
        String replica = srsp.getShardRequest().shards[0];
        log.info(this.msg() + "Requesting updates from " + replica + "n=" + toRequest.size() + " versions=" + toRequest);
        ShardRequest sreq = srsp.getShardRequest();
        sreq.purpose = 0;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getUpdates", new String[]{StrUtils.join(toRequest, (char)',')});
        sreq.params.set("onlyIfActive", this.onlyIfActive);
        sreq.responses.clear();
        this.shardHandler.submit(sreq, sreq.shards[0], sreq.params);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleUpdates(ShardResponse srsp) {
        List updates = (List)srsp.getSolrResponse().getResponse().get("updates");
        SyncShardRequest sreq = (SyncShardRequest)srsp.getShardRequest();
        if (updates.size() < sreq.requestedUpdates.size()) {
            log.error(this.msg() + " Requested " + sreq.requestedUpdates.size() + " updates from " + sreq.shards[0] + " but retrieved " + updates.size());
            return false;
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
        params.set("peersync", true);
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.uhandler.core, (SolrParams)params);
        SolrQueryResponse rsp = new SolrQueryResponse();
        UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessingChain(null);
        UpdateRequestProcessor proc = processorChain.createProcessor(req, rsp);
        Collections.sort(updates, updateRecordComparator);
        Object o = null;
        long lastVersion = 0L;
        try {
            block20: for (Object obj : updates) {
                o = obj;
                List entry = o;
                if (debug) {
                    log.debug(this.msg() + "raw update record " + o);
                }
                int oper = (Integer)entry.get(0) & 0xF;
                long version = (Long)entry.get(1);
                if (version == lastVersion && version != 0L) continue;
                lastVersion = version;
                switch (oper) {
                    case 1: {
                        SolrInputDocument sdoc = (SolrInputDocument)entry.get(entry.size() - 1);
                        UpdateCommand cmd = new AddUpdateCommand(req);
                        ((AddUpdateCommand)cmd).solrDoc = sdoc;
                        cmd.setVersion(version);
                        cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                        if (debug) {
                            log.debug(this.msg() + "add " + cmd + " id " + sdoc.getField("id"));
                        }
                        proc.processAdd((AddUpdateCommand)cmd);
                        continue block20;
                    }
                    case 2: {
                        byte[] idBytes = (byte[])entry.get(2);
                        UpdateCommand cmd = new DeleteUpdateCommand(req);
                        ((DeleteUpdateCommand)cmd).setIndexedId(new BytesRef(idBytes));
                        cmd.setVersion(version);
                        cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                        if (debug) {
                            log.debug(this.msg() + "delete " + cmd + " " + new BytesRef(idBytes).utf8ToString());
                        }
                        proc.processDelete((DeleteUpdateCommand)cmd);
                        continue block20;
                    }
                    case 3: {
                        String query = (String)entry.get(2);
                        UpdateCommand cmd = new DeleteUpdateCommand(req);
                        ((DeleteUpdateCommand)cmd).query = query;
                        cmd.setVersion(version);
                        cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                        if (debug) {
                            log.debug(this.msg() + "deleteByQuery " + cmd);
                        }
                        proc.processDelete((DeleteUpdateCommand)cmd);
                        continue block20;
                    }
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
            }
        }
        catch (IOException e) {
            sreq.updateException = e;
            log.error(this.msg() + "Error applying updates from " + sreq.shards + " ,update=" + o, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            sreq.updateException = e;
            log.error(this.msg() + "Error applying updates from " + sreq.shards + " ,update=" + o, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                proc.finish();
            }
            catch (Exception e) {
                sreq.updateException = e;
                log.error(this.msg() + "Error applying updates from " + sreq.shards + " ,finish()", (Throwable)e);
                return false;
            }
        }
        return this.compareFingerprint(sreq);
    }

    public static void sync(SolrCore core, List<String> replicas, int nUpdates) {
        ShardHandlerFactory shardHandlerFactory = core.getCoreDescriptor().getCoreContainer().getShardHandlerFactory();
        ShardHandler shardHandler = shardHandlerFactory.getShardHandler();
        for (String replica : replicas) {
            ShardRequest sreq = new ShardRequest();
            sreq.shards = new String[]{replica};
            sreq.params = new ModifiableSolrParams();
            sreq.params.set("qt", new String[]{"/get"});
            sreq.params.set("distrib", false);
            sreq.params.set("getVersions", nUpdates);
            shardHandler.submit(sreq, replica, sreq.params);
        }
        for (String replica : replicas) {
            ShardResponse srsp = shardHandler.takeCompletedOrError();
        }
    }

    private static class SyncShardRequest
    extends ShardRequest {
        List<Long> reportedVersions;
        IndexFingerprint fingerprint;
        boolean doFingerprintComparison;
        List<Long> requestedUpdates;
        Exception updateException;

        private SyncShardRequest() {
        }
    }
}

