/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.hdfs;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsLocalityReporter
implements SolrInfoMBean {
    public static final String LOCALITY_BYTES_TOTAL = "locality.bytes.total";
    public static final String LOCALITY_BYTES_LOCAL = "locality.bytes.local";
    public static final String LOCALITY_BYTES_RATIO = "locality.bytes.ratio";
    public static final String LOCALITY_BLOCKS_TOTAL = "locality.blocks.total";
    public static final String LOCALITY_BLOCKS_LOCAL = "locality.blocks.local";
    public static final String LOCALITY_BLOCKS_RATIO = "locality.blocks.ratio";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String hostname;
    private final ConcurrentMap<HdfsDirectory, ConcurrentMap<FileStatus, BlockLocation[]>> cache = new ConcurrentHashMap<HdfsDirectory, ConcurrentMap<FileStatus, BlockLocation[]>>();

    public void setHost(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public String getName() {
        return "hdfs-locality";
    }

    @Override
    public String getVersion() {
        return this.getClass().getPackage().getSpecificationVersion();
    }

    @Override
    public String getDescription() {
        return "Provides metrics for HDFS data locality.";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.OTHER;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        long totalBytes = 0L;
        long localBytes = 0L;
        int totalCount = 0;
        int localCount = 0;
        Iterator iterator = this.cache.keySet().iterator();
        while (iterator.hasNext()) {
            HdfsDirectory hdfsDirectory = (HdfsDirectory)((Object)iterator.next());
            if (hdfsDirectory.isClosed()) {
                iterator.remove();
                continue;
            }
            try {
                this.refreshDirectory(hdfsDirectory);
                Map blockMap = (Map)this.cache.get((Object)hdfsDirectory);
                Iterator i$ = blockMap.values().iterator();
                while (i$.hasNext()) {
                    BlockLocation[] locations;
                    for (BlockLocation bl : locations = (BlockLocation[])i$.next()) {
                        totalBytes += bl.getLength();
                        ++totalCount;
                        if (!Arrays.asList(bl.getHosts()).contains(this.hostname)) continue;
                        localBytes += bl.getLength();
                        ++localCount;
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Could not retrieve locality information for {} due to exception: {}", (Object)hdfsDirectory.getHdfsDirPath(), (Object)e);
            }
        }
        return this.createStatistics(totalBytes, localBytes, totalCount, localCount);
    }

    private NamedList<Number> createStatistics(long totalBytes, long localBytes, int totalCount, int localCount) {
        SimpleOrderedMap statistics = new SimpleOrderedMap();
        statistics.add(LOCALITY_BYTES_TOTAL, (Object)totalBytes);
        statistics.add(LOCALITY_BYTES_LOCAL, (Object)localBytes);
        if (localBytes == 0L) {
            statistics.add(LOCALITY_BYTES_RATIO, (Object)0);
        } else {
            statistics.add(LOCALITY_BYTES_RATIO, (Object)((double)localBytes / (double)totalBytes));
        }
        statistics.add(LOCALITY_BLOCKS_TOTAL, (Object)totalCount);
        statistics.add(LOCALITY_BLOCKS_LOCAL, (Object)localCount);
        if (localCount == 0) {
            statistics.add(LOCALITY_BLOCKS_RATIO, (Object)0);
        } else {
            statistics.add(LOCALITY_BLOCKS_RATIO, (Object)((double)localCount / (double)totalCount));
        }
        return statistics;
    }

    public void registerDirectory(HdfsDirectory dir) {
        logger.info("Registering direcotry {} for locality metrics.", (Object)dir.getHdfsDirPath().toString());
        this.cache.put(dir, new ConcurrentHashMap());
    }

    private void refreshDirectory(HdfsDirectory dir) throws IOException {
        Map directoryCache = (Map)this.cache.get((Object)dir);
        Set cachedStatuses = directoryCache.keySet();
        FileSystem fs = dir.getFileSystem();
        FileStatus[] statuses = fs.listStatus(dir.getHdfsDirPath());
        List<FileStatus> statusList = Arrays.asList(statuses);
        logger.debug("Updating locality information for: {}", statusList);
        cachedStatuses.retainAll(statusList);
        for (FileStatus status : statusList) {
            if (status.isDirectory() || directoryCache.containsKey(status)) continue;
            BlockLocation[] locations = fs.getFileBlockLocations(status, 0L, status.getLen());
            directoryCache.put(status, locations);
        }
    }
}

