/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.lucene.store.DataInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsFileReader
extends DataInput {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Path path;
    private FSDataInputStream inputStream;
    private long length;
    private boolean isClone;

    public HdfsFileReader(FileSystem fileSystem, Path path, int bufferSize) throws IOException {
        this.path = path;
        LOG.debug("Opening reader on {}", (Object)path);
        if (!fileSystem.exists(path)) {
            throw new FileNotFoundException(path.toString());
        }
        this.inputStream = fileSystem.open(path, bufferSize);
        FileStatus fileStatus = fileSystem.getFileStatus(path);
        this.length = fileStatus.getLen();
    }

    public HdfsFileReader(FileSystem fileSystem, Path path) throws IOException {
        this(fileSystem, path, 8192);
    }

    public long length() {
        return this.length;
    }

    public void seek(long pos) throws IOException {
        this.inputStream.seek(pos);
    }

    public void close() throws IOException {
        if (!this.isClone) {
            this.inputStream.close();
        }
        LOG.debug("Closing reader on {}", (Object)this.path);
    }

    public byte readByte() throws IOException {
        LOG.warn("Should not be used!");
        return this.inputStream.readByte();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int lenRead = this.inputStream.read(b, offset, len);
            offset += lenRead;
            len -= lenRead;
        }
    }

    public static long getLength(FileSystem fileSystem, Path path) throws IOException {
        FileStatus fileStatus = fileSystem.getFileStatus(path);
        return fileStatus.getLen();
    }

    public DataInput clone() {
        HdfsFileReader reader = (HdfsFileReader)super.clone();
        reader.isClone = true;
        return reader;
    }
}

