/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;

public class SimpleMLTQParser
extends QParser {
    private static final Pattern splitList = Pattern.compile(",| ");

    public SimpleMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() {
        String defaultField = this.req.getSchema().getUniqueKeyField().getName();
        String uniqueValue = this.localParams.get("v");
        String[] qf = this.localParams.getParams("qf");
        SolrIndexSearcher searcher = this.req.getSearcher();
        Query docIdQuery = this.createIdQuery(defaultField, uniqueValue);
        Map<Object, Object> boostFields = new HashMap();
        try {
            TopDocs td = searcher.search(docIdQuery, 1);
            if (td.totalHits != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request. Could not fetch document with id [" + uniqueValue + "]");
            }
            ScoreDoc[] scoreDocs = td.scoreDocs;
            MoreLikeThis mlt = new MoreLikeThis((IndexReader)this.req.getSearcher().getIndexReader());
            if (this.localParams.getInt("mintf") != null) {
                mlt.setMinTermFreq(this.localParams.getInt("mintf").intValue());
            }
            if (this.localParams.getInt("mindf") != null) {
                mlt.setMinDocFreq(this.localParams.getInt("mindf").intValue());
            }
            if (this.localParams.get("minwl") != null) {
                mlt.setMinWordLen(this.localParams.getInt("minwl").intValue());
            }
            if (this.localParams.get("maxwl") != null) {
                mlt.setMaxWordLen(this.localParams.getInt("maxwl").intValue());
            }
            if (this.localParams.get("maxqt") != null) {
                mlt.setMaxQueryTerms(this.localParams.getInt("maxqt").intValue());
            }
            if (this.localParams.get("maxntp") != null) {
                mlt.setMaxNumTokensParsed(this.localParams.getInt("maxntp").intValue());
            }
            if (this.localParams.get("maxdf") != null) {
                mlt.setMaxDocFreq(this.localParams.getInt("maxdf").intValue());
            }
            if (this.localParams.get("boost") != null) {
                mlt.setBoost(this.localParams.getBool("boost").booleanValue());
                boostFields = SolrPluginUtils.parseFieldBoosts(qf);
            }
            ArrayList<String> fields = new ArrayList<String>();
            if (qf != null) {
                for (String fieldName : qf) {
                    String[] strings;
                    if (StringUtils.isEmpty((String)fieldName)) continue;
                    for (String string : strings = splitList.split(fieldName)) {
                        if (StringUtils.isEmpty((String)string)) continue;
                        fields.add(string);
                    }
                }
            } else {
                Map<String, SchemaField> fieldNames = this.req.getSearcher().getSchema().getFields();
                for (String fieldName : fieldNames.keySet()) {
                    if (!fieldNames.get(fieldName).indexed() || !fieldNames.get(fieldName).stored() || fieldNames.get(fieldName).getType().getNumericType() != null) continue;
                    fields.add(fieldName);
                }
            }
            if (fields.size() < 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires at least one similarity field: qf");
            }
            mlt.setFieldNames(fields.toArray(new String[fields.size()]));
            mlt.setAnalyzer(this.req.getSchema().getIndexAnalyzer());
            Query rawMLTQuery = mlt.like(scoreDocs[0].doc);
            BooleanQuery boostedMLTQuery = (BooleanQuery)rawMLTQuery;
            if (boostFields.size() > 0) {
                BooleanQuery.Builder newQ = new BooleanQuery.Builder();
                newQ.setDisableCoord(boostedMLTQuery.isCoordDisabled());
                newQ.setMinimumNumberShouldMatch(boostedMLTQuery.getMinimumNumberShouldMatch());
                for (BooleanClause clause : boostedMLTQuery) {
                    Float fieldBoost;
                    Query q = clause.getQuery();
                    float originalBoost = 1.0f;
                    if (q instanceof BoostQuery) {
                        BoostQuery bq = (BoostQuery)q;
                        q = bq.getQuery();
                        originalBoost = bq.getBoost();
                    }
                    q = (fieldBoost = (Float)boostFields.get(((TermQuery)q).getTerm().field())) != null ? new BoostQuery(q, fieldBoost.floatValue() * originalBoost) : clause.getQuery();
                    newQ.add(q, clause.getOccur());
                }
                boostedMLTQuery = newQ.build();
            }
            BooleanQuery.Builder realMLTQuery = new BooleanQuery.Builder();
            realMLTQuery.setDisableCoord(true);
            realMLTQuery.add((Query)boostedMLTQuery, BooleanClause.Occur.MUST);
            realMLTQuery.add(docIdQuery, BooleanClause.Occur.MUST_NOT);
            return realMLTQuery.build();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request" + e.getMessage());
        }
    }

    private Query createIdQuery(String defaultField, String uniqueValue) {
        return new TermQuery(this.req.getSchema().getField(defaultField).getType().getNumericType() != null ? this.createNumericTerm(defaultField, uniqueValue) : new Term(defaultField, uniqueValue));
    }

    private Term createNumericTerm(String field, String uniqueValue) {
        BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
        bytesRefBuilder.grow(6);
        NumericUtils.intToPrefixCoded((int)Integer.parseInt(uniqueValue), (int)0, (BytesRefBuilder)bytesRefBuilder);
        return new Term(field, bytesRefBuilder);
    }
}

