/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryContext;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.BlockJoin;
import org.apache.solr.search.facet.CountSlotAcc;
import org.apache.solr.search.facet.CountSlotArrAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetTopParser;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.util.RTimer;

public class FacetProcessor<FacetRequestT extends FacetRequest> {
    protected SimpleOrderedMap<Object> response;
    protected FacetContext fcontext;
    protected FacetRequestT freq;
    LinkedHashMap<String, SlotAcc> accMap;
    protected SlotAcc[] accs;
    protected CountSlotAcc countAcc;

    FacetProcessor(FacetContext fcontext, FacetRequestT freq) {
        this.fcontext = fcontext;
        this.freq = freq;
    }

    public void process() throws IOException {
        this.handleDomainChanges();
    }

    public static FacetProcessor<?> createProcessor(SolrQueryRequest req, Map<String, Object> params, DocSet docs) {
        FacetTopParser parser = new FacetTopParser(req);
        FacetRequest facetRequest = null;
        try {
            facetRequest = ((FacetParser)parser).parse(params);
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
        }
        FacetContext fcontext = new FacetContext();
        fcontext.base = docs;
        fcontext.req = req;
        fcontext.searcher = req.getSearcher();
        fcontext.qcontext = QueryContext.newContext(fcontext.searcher);
        return facetRequest.createFacetProcessor(fcontext);
    }

    protected void handleDomainChanges() throws IOException {
        if (((FacetRequest)this.freq).domain == null) {
            return;
        }
        this.handleFilterExclusions();
        this.handleBlockJoin();
    }

    private void handleBlockJoin() throws IOException {
        DocSet result;
        Query parentQuery;
        if (!((FacetRequest)this.freq).domain.toChildren && !((FacetRequest)this.freq).domain.toParent) {
            return;
        }
        String parentStr = ((FacetRequest)this.freq).domain.parents;
        try {
            QParser parser = QParser.getParser(parentStr, null, this.fcontext.req);
            parentQuery = parser.getQuery();
        }
        catch (SyntaxError err) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing block join parent specification: " + parentStr);
        }
        BitDocSet parents = this.fcontext.searcher.getDocSetBits(parentQuery);
        DocSet input = this.fcontext.base;
        if (((FacetRequest)this.freq).domain.toChildren) {
            BitDocSet filt = this.fcontext.searcher.getDocSetBits((Query)new MatchAllDocsQuery());
            result = BlockJoin.toChildren(input, parents, filt, this.fcontext.qcontext);
        } else {
            result = BlockJoin.toParents(input, parents, this.fcontext.qcontext);
        }
        this.fcontext.base = result;
    }

    private void handleFilterExclusions() throws IOException {
        List<String> excludeTags = ((FacetRequest)this.freq).domain.excludeTags;
        if (excludeTags == null || excludeTags.size() == 0) {
            return;
        }
        ResponseBuilder rb = SolrRequestInfo.getRequestInfo().getResponseBuilder();
        Map tagMap = (Map)rb.req.getContext().get("tags");
        if (tagMap == null) {
            return;
        }
        IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
        for (String excludeTag : excludeTags) {
            Object olst = tagMap.get(excludeTag);
            if (!(olst instanceof Collection)) continue;
            for (Object o : (Collection)olst) {
                if (!(o instanceof QParser)) continue;
                QParser qp = (QParser)o;
                try {
                    excludeSet.put(qp.getQuery(), Boolean.TRUE);
                }
                catch (SyntaxError syntaxError) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
                }
            }
        }
        if (excludeSet.size() == 0) {
            return;
        }
        ArrayList<Query> qlist = new ArrayList<Query>();
        if (!excludeSet.containsKey(rb.getQuery())) {
            qlist.add(rb.getQuery());
        }
        if (rb.getFilters() != null) {
            for (Query q : rb.getFilters()) {
                if (excludeSet.containsKey(q)) continue;
                qlist.add(q);
            }
        }
        FacetContext curr = this.fcontext;
        while (curr != null) {
            if (curr.filter != null) {
                qlist.add(curr.filter);
            }
            curr = curr.parent;
        }
        this.fcontext.base = this.fcontext.searcher.getDocSet(qlist);
    }

    public Object getResponse() {
        return null;
    }

    protected void createAccs(int docCount, int slotCount) throws IOException {
        this.accMap = new LinkedHashMap();
        if (this.countAcc == null) {
            this.countAcc = new CountSlotArrAcc(this.fcontext, slotCount);
            this.countAcc.key = "count";
        }
        for (Map.Entry<String, AggValueSource> entry : ((FacetRequest)this.freq).getFacetStats().entrySet()) {
            SlotAcc acc = entry.getValue().createSlotAcc(this.fcontext, docCount, slotCount);
            acc.key = entry.getKey();
            this.accMap.put(acc.key, acc);
        }
        this.accs = new SlotAcc[this.accMap.size()];
        int i = 0;
        for (SlotAcc acc : this.accMap.values()) {
            this.accs[i++] = acc;
        }
    }

    protected void resetStats() {
        this.countAcc.reset();
        for (SlotAcc acc : this.accs) {
            acc.reset();
        }
    }

    protected void processStats(SimpleOrderedMap<Object> bucket, DocSet docs, int docCount) throws IOException {
        if (docCount == 0 && !((FacetRequest)this.freq).processEmpty || ((FacetRequest)this.freq).getFacetStats().size() == 0) {
            bucket.add("count", (Object)docCount);
            return;
        }
        this.createAccs(docCount, 1);
        int collected = this.collect(docs, 0);
        this.countAcc.incrementCount(0, collected);
        assert (collected == docCount);
        this.addStats(bucket, 0);
    }

    protected void processSubs(SimpleOrderedMap<Object> response, Query filter, DocSet domain) throws IOException {
        if (domain == null || domain.size() == 0 && !((FacetRequest)this.freq).processEmpty) {
            return;
        }
        for (Map.Entry<String, FacetRequest> sub : ((FacetRequest)this.freq).getSubFacets().entrySet()) {
            FacetContext subContext = this.fcontext.sub(filter, domain);
            FacetProcessor subProcessor = sub.getValue().createFacetProcessor(subContext);
            if (this.fcontext.getDebugInfo() != null) {
                FacetDebugInfo fdebug = new FacetDebugInfo();
                subContext.setDebugInfo(fdebug);
                this.fcontext.getDebugInfo().addChild(fdebug);
                fdebug.setReqDescription(sub.getValue().getFacetDescription());
                fdebug.setProcessor(subProcessor.getClass().getSimpleName());
                if (subContext.filter != null) {
                    fdebug.setFilter(subContext.filter.toString());
                }
                RTimer timer = new RTimer();
                subProcessor.process();
                long timeElapsed = (long)timer.getTime();
                fdebug.setElapse(timeElapsed);
                fdebug.putInfoItem("domainSize", subContext.base.size());
            } else {
                subProcessor.process();
            }
            response.add(sub.getKey(), subProcessor.getResponse());
        }
    }

    int collect(DocSet docs, int slot) throws IOException {
        int count = 0;
        SolrIndexSearcher searcher = this.fcontext.searcher;
        List leaves = searcher.getIndexReader().leaves();
        Iterator ctxIt = leaves.iterator();
        LeafReaderContext ctx = null;
        int segBase = 0;
        int adjustedMax = 0;
        DocIterator docsIt = docs.iterator();
        while (docsIt.hasNext()) {
            int doc = docsIt.nextDoc();
            if (doc >= adjustedMax) {
                int segMax;
                do {
                    if ((ctx = (LeafReaderContext)ctxIt.next()) != null) continue;
                    throw new RuntimeException("INTERNAL FACET ERROR");
                } while (doc >= (adjustedMax = (segBase = ctx.docBase) + (segMax = ctx.reader().maxDoc())));
                assert (doc >= ctx.docBase);
                this.setNextReader(ctx);
            }
            ++count;
            this.collect(doc - segBase, slot);
        }
        return count;
    }

    void collect(int segDoc, int slot) throws IOException {
        if (this.accs != null) {
            for (SlotAcc acc : this.accs) {
                acc.collect(segDoc, slot);
            }
        }
    }

    void setNextReader(LeafReaderContext ctx) throws IOException {
        for (SlotAcc acc : this.accs) {
            acc.setNextReader(ctx);
        }
    }

    void addStats(SimpleOrderedMap<Object> target, int slotNum) throws IOException {
        int count = this.countAcc.getCount(slotNum);
        target.add("count", (Object)count);
        if (count > 0 || ((FacetRequest)this.freq).processEmpty) {
            for (SlotAcc acc : this.accs) {
                acc.setValues(target, slotNum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillBucket(SimpleOrderedMap<Object> bucket, Query q, DocSet result) throws IOException {
        int count;
        boolean needDocSet;
        boolean bl = needDocSet = ((FacetRequest)this.freq).getFacetStats().size() > 0 || ((FacetRequest)this.freq).getSubFacets().size() > 0;
        if (result != null) {
            count = result.size();
        } else if (needDocSet) {
            result = q == null ? this.fcontext.base : this.fcontext.searcher.getDocSet(q, this.fcontext.base);
            count = result.size();
        } else {
            count = q == null ? this.fcontext.base.size() : this.fcontext.searcher.numDocs(q, this.fcontext.base);
        }
        try {
            this.processStats(bucket, result, count);
            this.processSubs(bucket, q, result);
        }
        finally {
            if (result != null) {
                result = null;
            }
        }
    }

    public static DocSet getFieldMissing(SolrIndexSearcher searcher, DocSet docs, String fieldName) throws IOException {
        SchemaField sf = searcher.getSchema().getField(fieldName);
        DocSet hasVal = searcher.getDocSet(sf.getType().getRangeQuery(null, sf, null, null, false, false));
        DocSet answer = docs.andNot(hasVal);
        return answer;
    }

    public static Query getFieldMissingQuery(SolrIndexSearcher searcher, String fieldName) throws IOException {
        SchemaField sf = searcher.getSchema().getField(fieldName);
        Query hasVal = sf.getType().getRangeQuery(null, sf, null, null, false, false);
        BooleanQuery.Builder noVal = new BooleanQuery.Builder();
        noVal.add(hasVal, BooleanClause.Occur.MUST_NOT);
        return noVal.build();
    }
}

