/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.SimpleOrderedMap;

public class FacetDebugInfo {
    String processor;
    long elapse;
    String filter;
    Map<String, Object> info;
    final List<FacetDebugInfo> children = new ArrayList<FacetDebugInfo>();
    Map<String, Object> reqDescription;

    public FacetDebugInfo() {
        this.info = new LinkedHashMap<String, Object>();
    }

    public void addChild(FacetDebugInfo child) {
        this.children.add(child);
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public void setElapse(long elapse) {
        this.elapse = elapse;
    }

    public void setReqDescription(Map<String, Object> reqDescription) {
        this.reqDescription = reqDescription;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void putInfoItem(String key, Object value) {
        this.info.put(key, value);
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public SimpleOrderedMap getFacetDebugInfo() {
        SimpleOrderedMap info = new SimpleOrderedMap();
        if (this.filter != null) {
            info.add("filter", (Object)this.filter);
        }
        info.add("processor", (Object)this.processor);
        info.add("elapse", (Object)this.elapse);
        if (this.reqDescription != null) {
            info.addAll(this.reqDescription);
        }
        info.addAll(this.info);
        if (this.children != null && this.children.size() > 0) {
            ArrayList<SimpleOrderedMap> subfacet = new ArrayList<SimpleOrderedMap>();
            info.add("sub-facet", subfacet);
            for (FacetDebugInfo child : this.children) {
                subfacet.add(child.getFacetDebugInfo());
            }
        }
        return info;
    }

    public String toString() {
        return "facet debug info: processor " + this.processor + " elapse " + this.elapse + "ms";
    }
}

