/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.parser.QueryParser;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.StrParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.WrappedQuery;

public class QueryParsing {
    public static final String OP = "q.op";
    public static final String V = "v";
    public static final String F = "f";
    public static final String TYPE = "type";
    public static final String DEFTYPE = "defType";
    public static final String LOCALPARAM_START = "{!";
    public static final char LOCALPARAM_END = '}';
    public static final String VAL_EXPLICIT = "__VAL_EXPLICIT__";

    public static QueryParser.Operator getQueryParserDefaultOperator(IndexSchema sch, String override) {
        String val = override;
        if (null == val) {
            val = sch.getQueryParserDefaultOperator();
        }
        return "AND".equals(val) ? QueryParser.Operator.AND : QueryParser.Operator.OR;
    }

    public static String getDefaultField(IndexSchema s, String df) {
        return df != null ? df : s.getDefaultSearchFieldName();
    }

    @Deprecated
    public static int parseLocalParams(String txt, int start, Map<String, String> target, SolrParams params) throws SyntaxError {
        return QueryParsing.parseLocalParams(txt, start, target, params, LOCALPARAM_START, '}');
    }

    @Deprecated
    public static int parseLocalParams(String txt, int start, Map<String, String> target, SolrParams params, String startString, char endChar) throws SyntaxError {
        ModifiableSolrParams newTarget = new ModifiableSolrParams();
        int retVal = QueryParsing.parseLocalParams(txt, start, newTarget, params, startString, endChar);
        for (String param : newTarget.getParameterNames()) {
            for (String value : newTarget.getParams(param)) {
                target.put(param, value);
            }
        }
        return retVal;
    }

    public static int parseLocalParams(String txt, int start, ModifiableSolrParams target, SolrParams params) throws SyntaxError {
        return QueryParsing.parseLocalParams(txt, start, target, params, LOCALPARAM_START, '}');
    }

    public static int parseLocalParams(String txt, int start, ModifiableSolrParams target, SolrParams params, String startString, char endChar) throws SyntaxError {
        int off = start;
        if (!txt.startsWith(startString, off)) {
            return start;
        }
        StrParser p = new StrParser(txt, start, txt.length());
        p.pos += startString.length();
        char ch;
        while ((ch = p.peek()) != endChar) {
            String id = p.getId();
            if (id.length() == 0) {
                throw new SyntaxError("Expected ending character '" + endChar + "' parsing local params '" + txt + '\"');
            }
            String val = null;
            ch = p.peek();
            if (ch != '=') {
                val = id;
                id = TYPE;
            } else {
                ++p.pos;
                ch = p.peek();
                boolean deref = false;
                if (ch == '$') {
                    ++p.pos;
                    ch = p.peek();
                    deref = true;
                }
                if (ch == '\"' || ch == '\'') {
                    val = p.getQuotedString();
                } else {
                    int valStart = p.pos;
                    while (true) {
                        if (p.pos >= p.end) {
                            throw new SyntaxError("Missing end to unquoted value starting at " + valStart + " str='" + txt + "'");
                        }
                        char c = p.val.charAt(p.pos);
                        if (c == endChar || Character.isWhitespace(c)) {
                            val = p.val.substring(valStart, p.pos);
                            break;
                        }
                        ++p.pos;
                    }
                }
                if (deref && params != null) {
                    val = params.get(val);
                }
            }
            if (target == null) continue;
            target.add(id, new String[]{val});
        }
        return p.pos + 1;
    }

    public static String encodeLocalParamVal(String val) {
        int i;
        int len = val.length();
        if (len > 0 && val.charAt(0) != '$') {
            char ch;
            for (i = 0; i < len && !Character.isWhitespace(ch = val.charAt(i)) && ch != '}'; ++i) {
            }
        }
        if (i >= len) {
            return val;
        }
        StringBuilder sb = new StringBuilder(val.length() + 4);
        sb.append('\'');
        for (i = 0; i < len; ++i) {
            char ch = val.charAt(i);
            if (ch == '\'') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static SolrParams getLocalParams(String txt, SolrParams params) throws SyntaxError {
        if (txt == null || !txt.startsWith(LOCALPARAM_START)) {
            return null;
        }
        ModifiableSolrParams localParams = new ModifiableSolrParams();
        int start = QueryParsing.parseLocalParams(txt, 0, localParams, params);
        String val = localParams.get(V);
        if (val == null) {
            val = txt.substring(start);
            localParams.set(V, new String[]{val});
        }
        return localParams;
    }

    static FieldType writeFieldName(String name, IndexSchema schema, Appendable out, int flags) throws IOException {
        FieldType ft = null;
        ft = schema.getFieldTypeNoEx(name);
        out.append(name);
        if (ft == null) {
            out.append("(UNKNOWN FIELD " + name + ')');
        }
        out.append(':');
        return ft;
    }

    static void writeFieldVal(String val, FieldType ft, Appendable out, int flags) throws IOException {
        if (ft != null) {
            try {
                out.append(ft.indexedToReadable(val));
            }
            catch (Exception e) {
                out.append("EXCEPTION(val=");
                out.append(val);
                out.append(")");
            }
        } else {
            out.append(val);
        }
    }

    static void writeFieldVal(BytesRef val, FieldType ft, Appendable out, int flags) throws IOException {
        if (ft != null) {
            try {
                CharsRefBuilder readable = new CharsRefBuilder();
                ft.indexedToReadable(val, readable);
                out.append((CharSequence)readable.get());
            }
            catch (Exception e) {
                out.append("EXCEPTION(val=");
                out.append(val.utf8ToString());
                out.append(")");
            }
        } else {
            out.append(val.utf8ToString());
        }
    }

    public static void toString(Query query, IndexSchema schema, Appendable out, int flags) throws IOException {
        Object q;
        boolean writeBoost = true;
        float boost = 1.0f;
        if (query instanceof BoostQuery) {
            BoostQuery bq = (BoostQuery)query;
            query = bq.getQuery();
            boost = bq.getBoost();
        }
        if (query instanceof TermQuery) {
            q = (TermQuery)query;
            Term t = q.getTerm();
            FieldType ft = QueryParsing.writeFieldName(t.field(), schema, out, flags);
            QueryParsing.writeFieldVal(t.bytes(), ft, out, flags);
        } else if (query instanceof TermRangeQuery) {
            q = (TermRangeQuery)query;
            String fname = q.getField();
            FieldType ft = QueryParsing.writeFieldName(fname, schema, out, flags);
            out.append(q.includesLower() ? (char)'[' : '{');
            BytesRef lt = q.getLowerTerm();
            BytesRef ut = q.getUpperTerm();
            if (lt == null) {
                out.append('*');
            } else {
                QueryParsing.writeFieldVal(lt, ft, out, flags);
            }
            out.append(" TO ");
            if (ut == null) {
                out.append('*');
            } else {
                QueryParsing.writeFieldVal(ut, ft, out, flags);
            }
            out.append(q.includesUpper() ? (char)']' : '}');
        } else if (query instanceof NumericRangeQuery) {
            q = (NumericRangeQuery)query;
            String fname = q.getField();
            FieldType ft = QueryParsing.writeFieldName(fname, schema, out, flags);
            out.append(q.includesMin() ? (char)'[' : '{');
            Number lt = q.getMin();
            Number ut = q.getMax();
            if (lt == null) {
                out.append('*');
            } else {
                out.append(lt.toString());
            }
            out.append(" TO ");
            if (ut == null) {
                out.append('*');
            } else {
                out.append(ut.toString());
            }
            out.append(q.includesMax() ? (char)']' : '}');
        } else if (query instanceof BooleanQuery) {
            q = (BooleanQuery)query;
            boolean needParens = false;
            if (q.getMinimumNumberShouldMatch() != 0 || q.isCoordDisabled()) {
                needParens = true;
            }
            if (needParens) {
                out.append('(');
            }
            boolean first = true;
            for (BooleanClause c : q.clauses()) {
                if (!first) {
                    out.append(' ');
                } else {
                    first = false;
                }
                if (c.isProhibited()) {
                    out.append('-');
                } else if (c.isRequired()) {
                    out.append('+');
                }
                Query subQuery = c.getQuery();
                boolean wrapQuery = false;
                if (subQuery instanceof BooleanQuery) {
                    wrapQuery = true;
                }
                if (wrapQuery) {
                    out.append('(');
                }
                QueryParsing.toString(subQuery, schema, out, flags);
                if (!wrapQuery) continue;
                out.append(')');
            }
            if (needParens) {
                out.append(')');
            }
            if (q.getMinimumNumberShouldMatch() > 0) {
                out.append('~');
                out.append(Integer.toString(q.getMinimumNumberShouldMatch()));
            }
            if (q.isCoordDisabled()) {
                out.append("/no_coord");
            }
        } else if (query instanceof PrefixQuery) {
            q = (PrefixQuery)query;
            Term prefix = q.getPrefix();
            FieldType ft = QueryParsing.writeFieldName(prefix.field(), schema, out, flags);
            out.append(prefix.text());
            out.append('*');
        } else if (query instanceof WildcardQuery) {
            out.append(query.toString());
            writeBoost = false;
        } else if (query instanceof FuzzyQuery) {
            out.append(query.toString());
            writeBoost = false;
        } else if (query instanceof ConstantScoreQuery) {
            out.append(query.toString());
            writeBoost = false;
        } else if (query instanceof WrappedQuery) {
            q = (WrappedQuery)query;
            out.append(((ExtendedQueryBase)q).getOptions());
            QueryParsing.toString(((WrappedQuery)q).getWrappedQuery(), schema, out, flags);
            writeBoost = false;
        } else {
            out.append(query.getClass().getSimpleName() + '(' + query.toString() + ')');
            writeBoost = false;
        }
        if (writeBoost && boost != 1.0f) {
            out.append("^");
            out.append(Float.toString(boost));
        }
    }

    public static String toString(Query query, IndexSchema schema) {
        try {
            StringBuilder sb = new StringBuilder();
            QueryParsing.toString(query, schema, sb, 0);
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> toString(List<Query> queries, IndexSchema schema) {
        ArrayList<String> out = new ArrayList<String>(queries.size());
        for (Query q : queries) {
            out.add(QueryParsing.toString(q, schema));
        }
        return out;
    }
}

