/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.BitsFilteredPostingsEnum;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.HashDocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortedIntDocSet;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RefCounted;

class JoinQuery
extends Query {
    String fromField;
    String toField;
    String fromIndex;
    Query q;
    long fromCoreOpenTime;

    public JoinQuery(String fromField, String toField, String fromIndex, Query subQuery) {
        this.fromField = fromField;
        this.toField = toField;
        this.fromIndex = fromIndex;
        this.q = subQuery;
    }

    public Query getQuery() {
        return this.q;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return super.rewrite(reader);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new JoinQueryWeight((SolrIndexSearcher)searcher);
    }

    public String toString(String field) {
        return "{!join from=" + this.fromField + " to=" + this.toField + (this.fromIndex != null ? " fromIndex=" + this.fromIndex : "") + "}" + this.q.toString();
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JoinQuery other = (JoinQuery)((Object)o);
        return this.fromField.equals(other.fromField) && this.toField.equals(other.toField) && this.q.equals((Object)other.q) && (this.fromIndex == other.fromIndex || this.fromIndex != null && this.fromIndex.equals(other.fromIndex)) && this.fromCoreOpenTime == other.fromCoreOpenTime;
    }

    public int hashCode() {
        int h = super.hashCode();
        h = h * 31 + this.q.hashCode();
        h = h * 31 + (int)this.fromCoreOpenTime;
        h = h * 31 + this.fromField.hashCode();
        h = h * 31 + this.toField.hashCode();
        return h;
    }

    private class JoinQueryWeight
    extends ConstantScoreWeight {
        SolrIndexSearcher fromSearcher;
        RefCounted<SolrIndexSearcher> fromRef;
        SolrIndexSearcher toSearcher;
        private Similarity similarity;
        ResponseBuilder rb;
        DocSet resultSet;
        Filter filter;
        int fromSetSize;
        long resultListDocs;
        int fromTermCount;
        long fromTermTotalDf;
        int fromTermDirectCount;
        int fromTermHits;
        long fromTermHitsTotalDf;
        int toTermHits;
        long toTermHitsTotalDf;
        int toTermDirectCount;
        int smallSetsDeferred;

        public JoinQueryWeight(SolrIndexSearcher searcher) {
            super((Query)JoinQuery.this);
            this.fromSearcher = searcher;
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            if (info != null) {
                this.rb = info.getResponseBuilder();
            }
            if (JoinQuery.this.fromIndex == null) {
                this.fromSearcher = searcher;
            } else {
                if (info == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join must have SolrRequestInfo");
                }
                CoreContainer container = searcher.getCore().getCoreDescriptor().getCoreContainer();
                final SolrCore fromCore = container.getCore(JoinQuery.this.fromIndex);
                if (fromCore == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + JoinQuery.this.fromIndex);
                }
                if (info.getReq().getCore() == fromCore) {
                    this.fromSearcher = searcher;
                } else {
                    this.fromRef = fromCore.getSearcher(false, true, null);
                    this.fromSearcher = this.fromRef.get();
                }
                if (this.fromRef != null) {
                    final RefCounted<SolrIndexSearcher> ref = this.fromRef;
                    info.addCloseHook(new Closeable(){

                        @Override
                        public void close() {
                            ref.decref();
                        }
                    });
                }
                info.addCloseHook(new Closeable(){

                    @Override
                    public void close() {
                        fromCore.close();
                    }
                });
            }
            this.toSearcher = searcher;
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            DocIdSet readerSet;
            if (this.filter == null) {
                boolean debug = this.rb != null && this.rb.isDebug();
                RTimer timer = debug ? new RTimer() : null;
                this.resultSet = this.getDocSet();
                if (timer != null) {
                    timer.stop();
                }
                if (debug) {
                    SimpleOrderedMap dbg = new SimpleOrderedMap();
                    dbg.add("time", (Object)((long)timer.getTime()));
                    dbg.add("fromSetSize", (Object)this.fromSetSize);
                    dbg.add("toSetSize", (Object)this.resultSet.size());
                    dbg.add("fromTermCount", (Object)this.fromTermCount);
                    dbg.add("fromTermTotalDf", (Object)this.fromTermTotalDf);
                    dbg.add("fromTermDirectCount", (Object)this.fromTermDirectCount);
                    dbg.add("fromTermHits", (Object)this.fromTermHits);
                    dbg.add("fromTermHitsTotalDf", (Object)this.fromTermHitsTotalDf);
                    dbg.add("toTermHits", (Object)this.toTermHits);
                    dbg.add("toTermHitsTotalDf", (Object)this.toTermHitsTotalDf);
                    dbg.add("toTermDirectCount", (Object)this.toTermDirectCount);
                    dbg.add("smallSetsDeferred", (Object)this.smallSetsDeferred);
                    dbg.add("toSetDocsAdded", (Object)this.resultListDocs);
                    this.rb.addDebug(dbg, "join", JoinQuery.this.toString());
                }
                this.filter = this.resultSet.getTopFilter();
            }
            if ((readerSet = this.filter.getDocIdSet(context, null)) == null) {
                return null;
            }
            DocIdSetIterator readerSetIterator = readerSet.iterator();
            if (readerSetIterator == null) {
                return null;
            }
            return new ConstantScoreScorer((Weight)this, this.score(), readerSetIterator);
        }

        public DocSet getDocSet() throws IOException {
            Fields toFields;
            FixedBitSet resultBits = null;
            int minDocFreqFrom = Math.max(5, this.fromSearcher.maxDoc() >> 13);
            int minDocFreqTo = Math.max(5, this.toSearcher.maxDoc() >> 13);
            int maxSortedIntSize = Math.max(10, this.toSearcher.maxDoc() >> 10);
            DocSet fromSet = this.fromSearcher.getDocSet(JoinQuery.this.q);
            this.fromSetSize = fromSet.size();
            ArrayList<DocSet> resultList = new ArrayList<DocSet>(10);
            DocSet fastForRandomSet = fromSet;
            if (minDocFreqFrom > 0 && fromSet instanceof SortedIntDocSet) {
                SortedIntDocSet sset = (SortedIntDocSet)fromSet;
                fastForRandomSet = new HashDocSet(sset.getDocs(), 0, sset.size());
            }
            Fields fromFields = this.fromSearcher.getLeafReader().fields();
            Fields fields = toFields = this.fromSearcher == this.toSearcher ? fromFields : this.toSearcher.getLeafReader().fields();
            if (fromFields == null) {
                return DocSet.EMPTY;
            }
            Terms terms = fromFields.terms(JoinQuery.this.fromField);
            Terms toTerms = toFields.terms(JoinQuery.this.toField);
            if (terms == null || toTerms == null) {
                return DocSet.EMPTY;
            }
            String prefixStr = TrieField.getMainValuePrefix(this.fromSearcher.getSchema().getFieldType(JoinQuery.this.fromField));
            BytesRef prefix = prefixStr == null ? null : new BytesRef((CharSequence)prefixStr);
            BytesRef term = null;
            TermsEnum termsEnum = terms.iterator();
            TermsEnum toTermsEnum = toTerms.iterator();
            SolrIndexSearcher.DocsEnumState fromDeState = null;
            SolrIndexSearcher.DocsEnumState toDeState = null;
            if (prefix == null) {
                term = termsEnum.next();
            } else if (termsEnum.seekCeil(prefix) != TermsEnum.SeekStatus.END) {
                term = termsEnum.term();
            }
            Bits fromLiveDocs = this.fromSearcher.getLeafReader().getLiveDocs();
            Bits toLiveDocs = this.fromSearcher == this.toSearcher ? fromLiveDocs : this.toSearcher.getLeafReader().getLiveDocs();
            fromDeState = new SolrIndexSearcher.DocsEnumState();
            fromDeState.fieldName = JoinQuery.this.fromField;
            fromDeState.liveDocs = fromLiveDocs;
            fromDeState.termsEnum = termsEnum;
            fromDeState.postingsEnum = null;
            fromDeState.minSetSizeCached = minDocFreqFrom;
            toDeState = new SolrIndexSearcher.DocsEnumState();
            toDeState.fieldName = JoinQuery.this.toField;
            toDeState.liveDocs = toLiveDocs;
            toDeState.termsEnum = toTermsEnum;
            toDeState.postingsEnum = null;
            toDeState.minSetSizeCached = minDocFreqTo;
            while (term != null && (prefix == null || StringHelper.startsWith((BytesRef)term, (BytesRef)prefix))) {
                boolean intersects;
                block37: {
                    ++this.fromTermCount;
                    intersects = false;
                    int freq = termsEnum.docFreq();
                    ++this.fromTermTotalDf;
                    if (freq < minDocFreqFrom) {
                        ++this.fromTermDirectCount;
                        fromDeState.postingsEnum = fromDeState.termsEnum.postings(fromDeState.postingsEnum, 0);
                        PostingsEnum postingsEnum = fromDeState.postingsEnum;
                        if (postingsEnum instanceof MultiPostingsEnum) {
                            MultiPostingsEnum.EnumWithSlice[] subs = ((MultiPostingsEnum)postingsEnum).getSubs();
                            int numSubs = ((MultiPostingsEnum)postingsEnum).getNumSubs();
                            for (int subindex = 0; subindex < numSubs; ++subindex) {
                                int docid;
                                MultiPostingsEnum.EnumWithSlice sub = subs[subindex];
                                if (sub.postingsEnum == null) continue;
                                int base = sub.slice.start;
                                while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                    if (!fastForRandomSet.exists(docid + base)) continue;
                                    intersects = true;
                                    break block37;
                                }
                            }
                        } else {
                            int docid;
                            while ((docid = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                if (!fastForRandomSet.exists(docid)) continue;
                                intersects = true;
                                break;
                            }
                        }
                    } else {
                        DocSet fromTermSet = this.fromSearcher.getDocSet(fromDeState);
                        intersects = fromSet.intersects(fromTermSet);
                    }
                }
                if (intersects) {
                    ++this.fromTermHits;
                    ++this.fromTermHitsTotalDf;
                    TermsEnum.SeekStatus status = toTermsEnum.seekCeil(term);
                    if (status == TermsEnum.SeekStatus.END) break;
                    if (status == TermsEnum.SeekStatus.FOUND) {
                        ++this.toTermHits;
                        int df = toTermsEnum.docFreq();
                        this.toTermHitsTotalDf += (long)df;
                        if (resultBits == null && (long)df + this.resultListDocs > (long)maxSortedIntSize && resultList.size() > 0) {
                            resultBits = new FixedBitSet(this.toSearcher.maxDoc());
                        }
                        if (toTermsEnum.docFreq() >= minDocFreqTo || resultBits == null) {
                            DocSet toTermSet = this.toSearcher.getDocSet(toDeState);
                            this.resultListDocs += (long)toTermSet.size();
                            if (resultBits != null) {
                                toTermSet.addAllTo(new BitDocSet(resultBits));
                            } else if (toTermSet instanceof BitDocSet) {
                                resultBits = ((BitDocSet)toTermSet).bits.clone();
                            } else {
                                resultList.add(toTermSet);
                            }
                        } else {
                            ++this.toTermDirectCount;
                            toDeState.postingsEnum = toDeState.termsEnum.postings(toDeState.postingsEnum, 0);
                            toDeState.postingsEnum = BitsFilteredPostingsEnum.wrap(toDeState.postingsEnum, toDeState.liveDocs);
                            PostingsEnum postingsEnum = toDeState.postingsEnum;
                            if (postingsEnum instanceof MultiPostingsEnum) {
                                MultiPostingsEnum.EnumWithSlice[] subs = ((MultiPostingsEnum)postingsEnum).getSubs();
                                int numSubs = ((MultiPostingsEnum)postingsEnum).getNumSubs();
                                for (int subindex = 0; subindex < numSubs; ++subindex) {
                                    int docid;
                                    MultiPostingsEnum.EnumWithSlice sub = subs[subindex];
                                    if (sub.postingsEnum == null) continue;
                                    int base = sub.slice.start;
                                    while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                        ++this.resultListDocs;
                                        resultBits.set(docid + base);
                                    }
                                }
                            } else {
                                int docid;
                                while ((docid = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                    ++this.resultListDocs;
                                    resultBits.set(docid);
                                }
                            }
                        }
                    }
                }
                term = termsEnum.next();
            }
            this.smallSetsDeferred = resultList.size();
            if (resultBits != null) {
                BitDocSet bitSet = new BitDocSet(resultBits);
                for (DocSet set : resultList) {
                    set.addAllTo(bitSet);
                }
                return bitSet;
            }
            if (resultList.size() == 0) {
                return DocSet.EMPTY;
            }
            if (resultList.size() == 1) {
                return (DocSet)resultList.get(0);
            }
            int sz = 0;
            for (DocSet set : resultList) {
                sz += set.size();
            }
            int[] docs = new int[sz];
            int pos = 0;
            for (DocSet set : resultList) {
                System.arraycopy(((SortedIntDocSet)set).getDocs(), 0, docs, pos, set.size());
                pos += set.size();
            }
            Arrays.sort(docs);
            int[] dedup = new int[sz];
            pos = 0;
            int last = -1;
            for (int doc : docs) {
                if (doc != last) {
                    dedup[pos++] = doc;
                }
                last = doc;
            }
            if (pos != dedup.length) {
                dedup = Arrays.copyOf(dedup, pos);
            }
            return new SortedIntDocSet(dedup, dedup.length);
        }
    }
}

