/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.function.ValueSourceRangeFilter;

public class FunctionRangeQuery
extends SolrConstantScoreQuery
implements PostFilter {
    final ValueSourceRangeFilter rangeFilt;

    public FunctionRangeQuery(ValueSourceRangeFilter filter) {
        super(filter);
        this.rangeFilt = filter;
    }

    @Override
    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        Map fcontext = ValueSource.newContext((IndexSearcher)searcher);
        return new FunctionRangeCollector(fcontext);
    }

    class FunctionRangeCollector
    extends DelegatingCollector {
        final Map fcontext;
        ValueSourceScorer scorer;
        int maxdoc;

        public FunctionRangeCollector(Map fcontext) {
            this.fcontext = fcontext;
        }

        @Override
        public void collect(int doc) throws IOException {
            assert (doc < this.maxdoc);
            if (this.scorer.matches(doc)) {
                this.leafDelegate.collect(doc);
            }
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.maxdoc = context.reader().maxDoc();
            FunctionValues dv = FunctionRangeQuery.this.rangeFilt.getValueSource().getValues(this.fcontext, context);
            this.scorer = dv.getRangeScorer((IndexReader)context.reader(), FunctionRangeQuery.this.rangeFilt.getLowerVal(), FunctionRangeQuery.this.rangeFilt.getUpperVal(), FunctionRangeQuery.this.rangeFilt.isIncludeLower(), FunctionRangeQuery.this.rangeFilt.isIncludeUpper());
        }
    }
}

