/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.collation.CollationKeyAnalyzer;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.DocValuesRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

public class CollationField
extends FieldType {
    private Analyzer analyzer;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.properties |= 2;
        this.setup(schema.getResourceLoader(), args);
        super.init(schema, args);
    }

    private void setup(ResourceLoader loader, Map<String, String> args) {
        String custom = args.remove("custom");
        String language = args.remove("language");
        String country = args.remove("country");
        String variant = args.remove("variant");
        String strength = args.remove("strength");
        String decomposition = args.remove("decomposition");
        if (custom == null && language == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Either custom or language is required.");
        }
        if (custom != null && (language != null || country != null || variant != null)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot specify both language and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        Collator collator = language != null ? this.createFromLocale(language, country, variant) : this.createFromRules(custom, loader);
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("identical")) {
                collator.setStrength(3);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid strength: " + strength);
            }
        }
        if (decomposition != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                collator.setDecomposition(0);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                collator.setDecomposition(1);
            } else if (decomposition.equalsIgnoreCase("full")) {
                collator.setDecomposition(2);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid decomposition: " + decomposition);
            }
        }
        this.analyzer = new CollationKeyAnalyzer(collator);
    }

    private Collator createFromLocale(String language, String country, String variant) {
        if (language != null && country == null && variant != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "To specify variant, country is required");
        }
        Locale locale = language != null && country != null && variant != null ? new Locale(language, country, variant) : (language != null && country != null ? new Locale(language, country) : new Locale(language));
        return Collator.getInstance(locale);
    }

    private Collator createFromRules(String fileName, ResourceLoader loader) {
        InputStream input = null;
        try {
            input = loader.openResource(fileName);
            String rules = IOUtils.toString((InputStream)input, (String)"UTF-8");
            RuleBasedCollator ruleBasedCollator = new RuleBasedCollator(rules);
            return ruleBasedCollator;
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        return this.getStringSort(field, top);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return UninvertingReader.Type.SORTED_SET_BINARY;
        }
        return UninvertingReader.Type.SORTED;
    }

    @Override
    public Analyzer getIndexAnalyzer() {
        return this.analyzer;
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return this.analyzer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BytesRef getCollationKey(String field, String text) {
        try (TokenStream source = this.analyzer.tokenStream(field, text);){
            source.reset();
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)source.getAttribute(TermToBytesRefAttribute.class);
            if (!source.incrementToken()) {
                throw new IllegalArgumentException("analyzer returned no terms for text: " + text);
            }
            BytesRef bytes = BytesRef.deepCopyOf((BytesRef)termAtt.getBytesRef());
            assert (!source.incrementToken());
            source.end();
            BytesRef bytesRef = bytes;
            return bytesRef;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to analyze text: " + text, e);
        }
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        BytesRef high;
        String f = field.getName();
        BytesRef low = part1 == null ? null : this.getCollationKey(f, part1);
        BytesRef bytesRef = high = part2 == null ? null : this.getCollationKey(f, part2);
        if (!field.indexed() && field.hasDocValues()) {
            return DocValuesRangeQuery.newBytesRefRange((String)field.getName(), (BytesRef)low, (BytesRef)high, (boolean)minInclusive, (boolean)maxInclusive);
        }
        return new TermRangeQuery(field.getName(), low, high, minInclusive, maxInclusive);
    }

    @Override
    public void checkSchemaField(SchemaField field) {
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object value, float boost) {
        if (field.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            fields.add(this.createField(field, value, boost));
            BytesRef bytes = this.getCollationKey(field.getName(), value.toString());
            if (field.multiValued()) {
                fields.add((IndexableField)new SortedSetDocValuesField(field.getName(), bytes));
            } else {
                fields.add((IndexableField)new SortedDocValuesField(field.getName(), bytes));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(field, value, boost));
    }

    @Override
    public Object marshalSortValue(Object value) {
        return CollationField.marshalBase64SortValue(value);
    }

    @Override
    public Object unmarshalSortValue(Object value) {
        return CollationField.unmarshalBase64SortValue(value);
    }
}

