/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialArgsParser;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.util.DistanceUnits;
import org.apache.solr.util.MapListener;
import org.apache.solr.util.SpatialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpatialFieldType<T extends SpatialStrategy>
extends FieldType
implements SpatialQueryable {
    public static final String SCORE_PARAM = "score";
    public static final String FILTER_PARAM = "filter";
    public static final String DISTANCE = "distance";
    public static final String RECIP_DISTANCE = "recipDistance";
    public static final String NONE = "none";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SpatialContext ctx;
    protected SpatialArgsParser argsParser;
    private final Cache<String, T> fieldStrategyCache = CacheBuilder.newBuilder().build();
    protected DistanceUnits distanceUnits;
    @Deprecated
    protected String units;
    protected final Set<String> supportedScoreModes;

    protected AbstractSpatialFieldType() {
        this(Collections.emptySet());
    }

    protected AbstractSpatialFieldType(Set<String> moreScoreModes) {
        TreeSet<String> set = new TreeSet<String>();
        set.add(NONE);
        set.add(DISTANCE);
        set.add(RECIP_DISTANCE);
        set.addAll(DistanceUnits.getSupportedUnits());
        set.addAll(moreScoreModes);
        this.supportedScoreModes = Collections.unmodifiableSet(set);
    }

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        String distanceUnitsStr;
        super.init(schema, args);
        if (this.ctx == null) {
            MapListener<String, String> argsWrap = new MapListener<String, String>(args);
            this.ctx = SpatialContextFactory.makeSpatialContext(argsWrap, (ClassLoader)schema.getResourceLoader().getClassLoader());
            args.keySet().removeAll(argsWrap.getSeenKeys());
        }
        String unitsErrMsg = "units parameter is deprecated, please use distanceUnits instead for field types with class " + this.getClass().getSimpleName();
        this.units = args.remove("units");
        if (this.units != null) {
            if ("degrees".equals(this.units)) {
                log.warn(unitsErrMsg);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, unitsErrMsg);
            }
        }
        if ((distanceUnitsStr = args.remove("distanceUnits")) == null) {
            this.distanceUnits = this.units != null ? DistanceUnits.BACKCOMPAT : (this.ctx.isGeo() ? DistanceUnits.KILOMETERS : DistanceUnits.DEGREES);
        } else {
            if (this.units != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, unitsErrMsg);
            }
            this.distanceUnits = this.parseDistanceUnits(distanceUnitsStr);
            if (this.distanceUnits == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Must specify distanceUnits as one of " + DistanceUnits.getSupportedUnits() + " on field types with class " + this.getClass().getSimpleName());
            }
        }
        this.argsParser = this.newSpatialArgsParser();
    }

    public DistanceUnits parseDistanceUnits(String str) {
        if (str == null) {
            return this.distanceUnits;
        }
        return DistanceUnits.valueOf(str);
    }

    protected SpatialArgsParser newSpatialArgsParser() {
        return new SpatialArgsParser(){

            protected Shape parseShape(String str, SpatialContext ctx) throws ParseException {
                return AbstractSpatialFieldType.this.parseShape(str);
            }
        };
    }

    public final Field createField(SchemaField field, Object val, float boost) {
        throw new IllegalStateException("instead call createFields() because isPolyField() is true");
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object val, float boost) {
        Shape shape;
        String shapeStr = null;
        if (val instanceof Shape) {
            shape = (Shape)val;
        } else {
            shapeStr = val.toString();
            shape = this.parseShape(shapeStr);
        }
        if (shape == null) {
            log.debug("Field {}: null shape for input: {}", (Object)field, val);
            return Collections.emptyList();
        }
        ArrayList<IndexableField> result = new ArrayList<IndexableField>();
        if (field.indexed()) {
            T strategy = this.getStrategy(field.getName());
            result.addAll(Arrays.asList(strategy.createIndexableFields(shape)));
        }
        if (field.stored()) {
            result.add((IndexableField)new StoredField(field.getName(), this.getStoredValue(shape, shapeStr)));
        }
        return result;
    }

    protected String getStoredValue(Shape shape, String shapeStr) {
        return shapeStr == null ? this.shapeToString(shape) : shapeStr;
    }

    protected Shape parseShape(String str) {
        if (str.length() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "empty string shape");
        }
        if (Character.isLetter(str.charAt(0))) {
            try {
                return this.ctx.readShapeFromWkt(str);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (!message.contains(str)) {
                    message = "Couldn't parse shape '" + str + "' because: " + message;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message, (Throwable)e);
            }
        }
        return SpatialUtils.parsePointSolrException(str, this.ctx);
    }

    protected String shapeToString(Shape shape) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Getting a String from a Shape is no longer possible. See javadocs for commentary.");
    }

    protected abstract T newSpatialStrategy(String var1);

    @Override
    public final boolean isPolyField() {
        return true;
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        Point pt = SpatialUtils.parsePointSolrException(options.pointStr, this.ctx);
        double distDeg = DistanceUtils.dist2Degrees((double)options.distance, (double)options.radius);
        Circle shape = this.ctx.makeCircle(pt, distDeg);
        if (options.bbox) {
            shape = shape.getBoundingBox();
        }
        SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, (Shape)shape);
        return this.getQueryFromSpatialArgs(parser, options.field, spatialArgs);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        if (!minInclusive || !maxInclusive) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both sides of spatial range query must be inclusive: " + field.getName());
        }
        Point p1 = SpatialUtils.parsePointSolrException(part1, this.ctx);
        Point p2 = SpatialUtils.parsePointSolrException(part2, this.ctx);
        Rectangle bbox = this.ctx.makeRectangle(p1, p2);
        SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, (Shape)bbox);
        return this.getQueryFromSpatialArgs(parser, field, spatialArgs);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A ValueSource isn't directly available from this field. Instead try a query using the distance as the score.");
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return this.getQueryFromSpatialArgs(parser, field, this.parseSpatialArgs(parser, externalVal));
    }

    protected SpatialArgs parseSpatialArgs(QParser parser, String externalVal) {
        try {
            SpatialArgs args = this.argsParser.parse(externalVal, this.ctx);
            if (args.getDistErr() != null) {
                args.setDistErr(Double.valueOf(args.getDistErr() * this.distanceUnits.multiplierFromThisUnitToDegrees()));
            }
            return args;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    protected Query getQueryFromSpatialArgs(QParser parser, SchemaField field, SpatialArgs spatialArgs) {
        T strategy = this.getStrategy(field.getName());
        SolrParams localParams = parser.getLocalParams();
        String scoreParam = localParams == null ? null : localParams.get(SCORE_PARAM);
        ValueSource valueSource = this.getValueSourceFromSpatialArgs(parser, field, spatialArgs, scoreParam, strategy);
        if (valueSource == null) {
            return strategy.makeQuery(spatialArgs);
        }
        FunctionQuery functionQuery = new FunctionQuery(valueSource);
        if (localParams != null && !localParams.getBool(FILTER_PARAM, true)) {
            return functionQuery;
        }
        Query filterQuery = strategy.makeQuery(spatialArgs);
        return new BooleanQuery.Builder().add((Query)functionQuery, BooleanClause.Occur.MUST).add(filterQuery, BooleanClause.Occur.FILTER).build();
    }

    @Override
    public double getSphereRadius() {
        return this.distanceUnits.getEarthRadius();
    }

    public Set<String> getSupportedScoreModes() {
        return this.supportedScoreModes;
    }

    protected ValueSource getValueSourceFromSpatialArgs(QParser parser, SchemaField field, SpatialArgs spatialArgs, String score, T strategy) {
        double multiplier;
        if (score == null) {
            return null;
        }
        switch (score) {
            case "": 
            case "none": {
                return null;
            }
            case "recipDistance": {
                return strategy.makeRecipDistanceValueSource(spatialArgs.getShape());
            }
            case "distance": {
                multiplier = this.distanceUnits.multiplierFromDegreesToThisUnit();
                break;
            }
            default: {
                DistanceUnits du = this.parseDistanceUnits(score);
                if (du != null) {
                    multiplier = du.multiplierFromDegreesToThisUnit();
                    break;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'score' local-param must be one of " + this.supportedScoreModes + ", it was: " + score);
            }
        }
        return strategy.makeDistanceValueSource(spatialArgs.getShape().getCenter(), multiplier);
    }

    public T getStrategy(final String fieldName) {
        try {
            return (T)((SpatialStrategy)this.fieldStrategyCache.get((Object)fieldName, new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return AbstractSpatialFieldType.this.newSpatialStrategy(fieldName);
                }
            }));
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sorting not supported on SpatialField: " + field.getName() + ", instead try sorting by query.");
    }

    public DistanceUnits getDistanceUnits() {
        return this.distanceUnits;
    }
}

