/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.PUTable;
import org.apache.solr.rest.schema.BaseFieldResource;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.noggit.ObjectBuilder;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFieldResource
extends BaseFieldResource
implements GETable,
PUTable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String fieldNamePattern;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.fieldNamePattern = (String)this.getRequestAttributes().get("name");
            try {
                this.fieldNamePattern = null == this.fieldNamePattern ? "" : DynamicFieldResource.urlDecode(this.fieldNamePattern.trim()).trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceException((Throwable)e);
            }
        }
    }

    @Override
    public Representation get() {
        try {
            if (this.fieldNamePattern.isEmpty()) {
                String message = "Dynamic field name is missing";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Dynamic field name is missing");
            }
            SchemaField field = null;
            for (SchemaField prototype : this.getSchema().getDynamicFieldPrototypes()) {
                if (!prototype.getName().equals(this.fieldNamePattern)) continue;
                field = prototype;
                break;
            }
            if (null == field) {
                String message = "Dynamic field '" + this.fieldNamePattern + "' not found.";
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, message);
            }
            this.getSolrResponse().add("dynamicField", this.getFieldProperties(field));
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Representation put(Representation entity) {
        try {
            String bodyFieldName;
            if (!this.getSchema().isMutable()) {
                String message = "This IndexSchema is not mutable.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This IndexSchema is not mutable.");
            }
            if (null == entity.getMediaType()) {
                entity.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (!entity.getMediaType().equals((Object)MediaType.APPLICATION_JSON, true)) {
                String message = "Only media type " + MediaType.APPLICATION_JSON.toString() + " is accepted." + "  Request has media type " + entity.getMediaType().toString() + ".";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            Object object = ObjectBuilder.fromJSON((String)entity.getText());
            if (!(object instanceof Map)) {
                String message = "Invalid JSON type " + object.getClass().getName() + ", expected Map of the form" + " (ignore the backslashes): {\"type\":\"text_general\", ...}, either with or" + " without a \"name\" mapping.  If the \"name\" is specified, it must match the" + " name given in the request URL: /schema/dynamicfields/(name)";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            Map map = (Map)object;
            if (1 == map.size() && map.containsKey("dynamicField")) {
                map = (Map)map.get("dynamicField");
            }
            if (null != (bodyFieldName = (String)map.remove("name")) && !this.fieldNamePattern.equals(bodyFieldName)) {
                String message = "Dynamic field name in the request body '" + bodyFieldName + "' doesn't match dynamic field name in the request URL '" + this.fieldNamePattern + "'";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            String fieldType = (String)map.remove("type");
            if (null == fieldType) {
                String message = "Missing 'type' mapping.";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            ManagedIndexSchema oldSchema = (ManagedIndexSchema)this.getSchema();
            Object copies = map.get("copyFields");
            List<String> copyFieldNames = null;
            if (copies != null) {
                if (copies instanceof List) {
                    copyFieldNames = (List<String>)copies;
                } else if (copies instanceof String) {
                    copyFieldNames = Collections.singletonList(copies.toString());
                } else {
                    String message = "Invalid 'copyFields' type.";
                    log.error(message);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
            }
            if (copyFieldNames != null) {
                map.remove("copyFields");
            }
            IndexSchema newSchema = null;
            boolean success = false;
            while (!success) {
                try {
                    SchemaField newDynamicField = oldSchema.newDynamicField(this.fieldNamePattern, fieldType, map);
                    Object object2 = oldSchema.getSchemaUpdateLock();
                    synchronized (object2) {
                        newSchema = oldSchema.addDynamicFields(Collections.singletonList(newDynamicField), Collections.singletonMap(newDynamicField.getName(), copyFieldNames), true);
                        if (null == newSchema) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to add dynamic field.");
                        }
                        this.getSolrCore().setLatestSchema(newSchema);
                        success = true;
                    }
                }
                catch (ManagedIndexSchema.SchemaChangedInZkException e) {
                    log.debug("Schema changed while processing request, retrying");
                    oldSchema = (ManagedIndexSchema)this.getSolrCore().getLatestSchema();
                }
            }
            this.waitForSchemaUpdateToPropagate(newSchema);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }
}

