/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrReturnFields;

public class SolrQueryResponse {
    public static final String NAME = "response";
    public static final String RESPONSE_HEADER_PARTIAL_RESULTS_KEY = "partialResults";
    private static final String RESPONSE_HEADER_KEY = "responseHeader";
    private static final String RESPONSE_KEY = "response";
    protected NamedList<Object> values = new SimpleOrderedMap();
    protected NamedList<Object> toLog = new SimpleOrderedMap();
    protected ReturnFields returnFields;
    private final NamedList<String> headers = new SimpleOrderedMap();
    protected Exception err;
    protected boolean httpCaching = true;

    public NamedList getValues() {
        return this.values;
    }

    public void setAllValues(NamedList<Object> nameValuePairs) {
        this.values = nameValuePairs;
    }

    public void setReturnFields(ReturnFields fields) {
        this.returnFields = fields;
    }

    public ReturnFields getReturnFields() {
        if (this.returnFields == null) {
            this.returnFields = new SolrReturnFields();
        }
        return this.returnFields;
    }

    public void add(String name, Object val) {
        this.values.add(name, val);
    }

    public void setException(Exception e) {
        this.err = e;
    }

    public Exception getException() {
        return this.err;
    }

    public void addResponseHeader(NamedList<Object> header) {
        this.values.add(RESPONSE_HEADER_KEY, header);
    }

    public void removeResponseHeader() {
        this.values.remove(RESPONSE_HEADER_KEY);
    }

    public NamedList<Object> getResponseHeader() {
        SimpleOrderedMap header = (SimpleOrderedMap)this.values.get(RESPONSE_HEADER_KEY);
        return header;
    }

    public void addResponse(Object response) {
        this.values.add("response", response);
    }

    public Object getResponse() {
        return this.values.get("response");
    }

    public void addToLog(String name, Object val) {
        this.toLog.add(name, val);
    }

    public NamedList<Object> getToLog() {
        return this.toLog;
    }

    public String getToLogAsString(String logid) {
        StringBuilder sb = new StringBuilder(logid);
        for (int i = 0; i < this.toLog.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            String name = this.toLog.getName(i);
            Object val = this.toLog.getVal(i);
            if (name != null) {
                sb.append(name).append('=');
            }
            sb.append(val);
        }
        return sb.toString();
    }

    public void setHttpCaching(boolean httpCaching) {
        this.httpCaching = httpCaching;
    }

    public boolean isHttpCaching() {
        return this.httpCaching;
    }

    public void setHttpHeader(String name, String value) {
        this.headers.removeAll(name);
        this.headers.add(name, (Object)value);
    }

    public void addHttpHeader(String name, String value) {
        this.headers.add(name, (Object)value);
    }

    public String getHttpHeader(String name) {
        return (String)this.headers.get(name);
    }

    public Collection<String> getHttpHeaders(String name) {
        return this.headers.getAll(name);
    }

    public String removeHttpHeader(String name) {
        return (String)this.headers.remove(name);
    }

    public Collection<String> removeHttpHeaders(String name) {
        return this.headers.removeAll(name);
    }

    public Iterator<Map.Entry<String, String>> httpHeaders() {
        return this.headers.iterator();
    }
}

