/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryResponseWriter
implements BinaryQueryResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse response) throws IOException {
        Resolver resolver = new Resolver(req, response.getReturnFields());
        Boolean omitHeader = req.getParams().getBool("omitHeader");
        if (omitHeader != null && omitHeader.booleanValue()) {
            response.removeResponseHeader();
        }
        new JavaBinCodec((JavaBinCodec.ObjectResolver)resolver).setWritableDocFields((JavaBinCodec.WritableDocFields)resolver).marshal((Object)response.getValues(), out);
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        throw new RuntimeException("This is a binary writer , Cannot write to a characterstream");
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/octet-stream";
    }

    @Override
    public void init(NamedList args) {
    }

    public static NamedList<Object> getParsedResponse(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            Resolver resolver = new Resolver(req, rsp.getReturnFields());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new JavaBinCodec((JavaBinCodec.ObjectResolver)resolver).setWritableDocFields((JavaBinCodec.WritableDocFields)resolver).marshal((Object)rsp.getValues(), (OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            return (NamedList)new JavaBinCodec((JavaBinCodec.ObjectResolver)resolver).unmarshal((InputStream)in);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class Resolver
    implements JavaBinCodec.ObjectResolver,
    JavaBinCodec.WritableDocFields {
        protected final SolrQueryRequest solrQueryRequest;
        protected IndexSchema schema;
        protected SolrIndexSearcher searcher;
        protected final ReturnFields returnFields;

        public Resolver(SolrQueryRequest req, ReturnFields returnFields) {
            this.solrQueryRequest = req;
            this.returnFields = returnFields;
        }

        public Object resolve(Object o, JavaBinCodec codec) throws IOException {
            if (o instanceof ResultContext) {
                this.writeResults((ResultContext)o, codec);
                return null;
            }
            if (o instanceof DocList) {
                ResultContext ctx = new ResultContext();
                ctx.docs = (DocList)o;
                this.writeResults(ctx, codec);
                return null;
            }
            if (o instanceof IndexableField) {
                if (this.schema == null) {
                    this.schema = this.solrQueryRequest.getSchema();
                }
                IndexableField f = (IndexableField)o;
                SchemaField sf = this.schema.getFieldOrNull(f.name());
                try {
                    o = DocsStreamer.getValue(sf, f);
                }
                catch (Exception e) {
                    LOG.warn("Error reading a field : " + o, (Throwable)e);
                }
            }
            return o;
        }

        public boolean isWritable(String name) {
            return this.returnFields.wantsField(name);
        }

        public boolean wantsAllFields() {
            return this.returnFields.wantsAllFields();
        }

        protected void writeResultsBody(ResultContext res, JavaBinCodec codec) throws IOException {
            codec.writeTag((byte)-128, res.docs.size());
            DocsStreamer docStreamer = new DocsStreamer(res.docs, res.query, this.solrQueryRequest, this.returnFields);
            while (docStreamer.hasNext()) {
                SolrDocument doc = docStreamer.next();
                codec.writeSolrDocument(doc);
            }
        }

        public void writeResults(ResultContext ctx, JavaBinCodec codec) throws IOException {
            codec.writeTag((byte)12);
            boolean wantsScores = this.returnFields.wantsScore() && ctx.docs.hasScores();
            ArrayList<Number> l = new ArrayList<Number>(3);
            l.add(Long.valueOf(ctx.docs.matches()));
            l.add(Long.valueOf(ctx.docs.offset()));
            Float maxScore = null;
            if (wantsScores) {
                maxScore = Float.valueOf(ctx.docs.maxScore());
            }
            l.add(maxScore);
            codec.writeArray(l);
            this.writeResultsBody(ctx, codec);
        }
    }
}

