/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SolrIndexSearcher;

public class FilterQuery
extends ExtendedQueryBase {
    protected final Query q;

    public FilterQuery(Query q) {
        this.q = q;
    }

    public Query getQuery() {
        return this.q;
    }

    public int hashCode() {
        return this.q.hashCode() + -1058646507;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FilterQuery)) {
            return false;
        }
        FilterQuery fq = (FilterQuery)obj;
        return this.q.equals((Object)fq.q);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("filter(");
        sb.append(this.q.toString(""));
        sb.append(')');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query newQ = this.q.rewrite(reader);
        if (newQ != this.q) {
            return new FilterQuery(newQ);
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needScores) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            return new BoostQuery((Query)new ConstantScoreQuery(this.q), 0.0f).createWeight(searcher, needScores);
        }
        SolrIndexSearcher solrSearcher = (SolrIndexSearcher)searcher;
        DocSet docs = solrSearcher.getDocSet(this.q);
        return new BoostQuery((Query)new SolrConstantScoreQuery(docs.getTopFilter()), 0.0f).createWeight(searcher, needScores);
    }
}

