/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.FieldFacetStats;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.request.DocValuesStats;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.hll.HLL;
import org.apache.solr.util.hll.HLLType;

public class StatsField {
    private static final EnumSet<Stat> CALCDISTINCT_PSUEDO_STAT = EnumSet.of(Stat.countDistinct, Stat.distinctValues);
    public static final Set<Stat> DEFAULT_STATS = Collections.unmodifiableSet(EnumSet.of(Stat.min, new Stat[]{Stat.max, Stat.missing, Stat.sum, Stat.count, Stat.mean, Stat.sumOfSquares, Stat.stddev}));
    private final SolrIndexSearcher searcher;
    private final ResponseBuilder rb;
    private final String originalParam;
    private final SolrParams localParams;
    private final ValueSource valueSource;
    private final SchemaField schemaField;
    private final String key;
    private final boolean topLevelCalcDistinct;
    private final String[] facets;
    private final List<String> tagList;
    private final List<String> excludeTagList;
    private final EnumSet<Stat> statsToCalculate = EnumSet.noneOf(Stat.class);
    private final EnumSet<Stat> statsInResponse = EnumSet.noneOf(Stat.class);
    private final List<Double> percentilesList = new ArrayList<Double>();
    private final boolean isShard;
    private double tdigestCompression = 100.0;
    private HllOptions hllOpts;

    public StatsField(ResponseBuilder rb, String statsParam) {
        this.rb = rb;
        this.searcher = rb.req.getSearcher();
        this.originalParam = statsParam;
        SolrParams params = rb.req.getParams();
        try {
            this.isShard = params.getBool("isShard", false);
            SolrParams localParams = QueryParsing.getLocalParams(this.originalParam, params);
            if (null == localParams) {
                ModifiableSolrParams customParams = new ModifiableSolrParams();
                customParams.add("v", new String[]{this.originalParam});
                localParams = customParams;
            }
            this.localParams = localParams;
            String parserName = localParams.get("type");
            SchemaField sf = null;
            ValueSource vs = null;
            if (StringUtils.isBlank((String)parserName)) {
                sf = this.searcher.getSchema().getField(localParams.get("v"));
            } else {
                QParserPlugin qplug = rb.req.getCore().getQueryPlugin(parserName);
                QParser qp = qplug.createParser(localParams.get("v"), localParams, params, rb.req);
                vs = StatsField.extractValueSource(qp.parse());
                sf = StatsField.extractSchemaField(vs, this.searcher.getSchema());
                if (null != sf) {
                    vs = null;
                }
            }
            assert (null == vs ^ null == sf) : "exactly one of vs & sf must be null";
            this.schemaField = sf;
            this.valueSource = vs;
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to parse stats.field: " + this.originalParam + " due to: " + e.getMessage(), (Throwable)e);
        }
        this.key = this.localParams.get("key", this.localParams.get("v", this.originalParam));
        this.topLevelCalcDistinct = null == this.schemaField ? params.getBool("stats.calcdistinct", false) : params.getFieldBool(this.schemaField.getName(), "stats.calcdistinct", false);
        this.populateStatsSets();
        String[] facets = params.getFieldParams(this.key, "stats.facet");
        this.facets = null == facets ? new String[]{} : facets;
        String tagStr = this.localParams.get("tag");
        this.tagList = null == tagStr ? Collections.emptyList() : StrUtils.splitSmart((String)tagStr, (char)',');
        String excludeStr = this.localParams.get("ex");
        List<String> list = this.excludeTagList = null == excludeStr ? Collections.emptyList() : StrUtils.splitSmart((String)excludeStr, (char)',');
        assert (null == this.valueSource ^ null == this.schemaField) : "exactly one of valueSource & schemaField must be null";
    }

    private static ValueSource extractValueSource(Query q) {
        return q instanceof FunctionQuery ? ((FunctionQuery)q).getValueSource() : new QueryValueSource(q, 0.0f);
    }

    private static SchemaField extractSchemaField(ValueSource vs, IndexSchema schema) {
        if (vs instanceof FieldCacheSource) {
            String fieldName = ((FieldCacheSource)vs).getField();
            return schema.getField(fieldName);
        }
        return null;
    }

    public String getOutputKey() {
        return this.key;
    }

    public DocSet computeBaseDocSet() throws IOException {
        DocSet docs = this.rb.getResults().docSet;
        Map tagMap = (Map)this.rb.req.getContext().get("tags");
        if (this.excludeTagList.isEmpty() || null == tagMap) {
            return docs;
        }
        IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
        for (String excludeTag : this.excludeTagList) {
            Object olst = tagMap.get(excludeTag);
            if (!(olst instanceof Collection)) continue;
            for (Object o : (Collection)olst) {
                if (!(o instanceof QParser)) continue;
                QParser qp = (QParser)o;
                try {
                    excludeSet.put(qp.getQuery(), Boolean.TRUE);
                }
                catch (SyntaxError e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Excluded query can't be parsed: " + this.originalParam + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (excludeSet.size() == 0) {
            return docs;
        }
        ArrayList<Query> qlist = new ArrayList<Query>();
        if (!excludeSet.containsKey(this.rb.getQuery())) {
            qlist.add(this.rb.getQuery());
        }
        if (this.rb.getFilters() != null) {
            for (Query q : this.rb.getFilters()) {
                if (excludeSet.containsKey(q)) continue;
                qlist.add(q);
            }
        }
        return this.searcher.getDocSet(qlist);
    }

    public StatsValues computeLocalStatsValues(DocSet base) throws IOException {
        if (this.statsToCalculate.isEmpty()) {
            return StatsValuesFactory.createStatsValues(this);
        }
        if (null != this.schemaField && (this.schemaField.multiValued() || this.schemaField.getType().multiValuedFieldCache())) {
            return DocValuesStats.getCounts(this.searcher, this, base, this.facets);
        }
        return this.computeLocalValueSourceStats(base);
    }

    private StatsValues computeLocalValueSourceStats(DocSet base) throws IOException {
        IndexSchema schema = this.searcher.getSchema();
        StatsValues allstats = StatsValuesFactory.createStatsValues(this);
        ArrayList<FieldFacetStats> facetStats = new ArrayList<FieldFacetStats>();
        for (String facetField : this.facets) {
            SchemaField fsf = schema.getField(facetField);
            if (fsf.multiValued()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Stats can only facet on single-valued fields, not: " + facetField);
            }
            facetStats.add(new FieldFacetStats(this.searcher, fsf, this));
        }
        Iterator ctxIt = this.searcher.getIndexReader().leaves().iterator();
        LeafReaderContext ctx = null;
        DocIterator docsIt = base.iterator();
        while (docsIt.hasNext()) {
            int doc = docsIt.nextDoc();
            if (ctx == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                while ((ctx = (LeafReaderContext)ctxIt.next()) == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                }
                assert (doc >= ctx.docBase);
                allstats.setNextReader(ctx);
                for (FieldFacetStats f : facetStats) {
                    f.setNextReader(ctx);
                }
            }
            allstats.accumulate(doc - ctx.docBase);
            for (FieldFacetStats f : facetStats) {
                f.facet(doc - ctx.docBase);
            }
        }
        for (FieldFacetStats f : facetStats) {
            allstats.addFacet(f.name, f.facetStatsValues);
        }
        return allstats;
    }

    public SolrIndexSearcher getSearcher() {
        return this.searcher;
    }

    public SchemaField getSchemaField() {
        return this.schemaField;
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public String toString() {
        return "StatsField<" + this.originalParam + ">";
    }

    private void populateStatsSets() {
        boolean statSpecifiedByLocalParam = false;
        Iterator itParams = this.localParams.getParameterNamesIterator();
        while (itParams.hasNext()) {
            String paramKey = (String)itParams.next();
            Stat stat = Stat.forName(paramKey);
            if (stat == null) continue;
            statSpecifiedByLocalParam = true;
            if (!stat.parseParams(this)) continue;
            this.statsInResponse.add(stat);
        }
        if (!statSpecifiedByLocalParam && !this.localParams.getBool("calcdistinct", false)) {
            this.statsInResponse.addAll(DEFAULT_STATS);
        }
        if (this.localParams.getBool("calcdistinct", this.topLevelCalcDistinct)) {
            for (Stat stat : CALCDISTINCT_PSUEDO_STAT) {
                if (!this.localParams.getBool(stat.name(), true)) continue;
                this.statsInResponse.add(stat);
            }
        }
        for (Stat stat : this.statsInResponse) {
            this.statsToCalculate.addAll(stat.getDistribDeps());
        }
    }

    public boolean calculateStats(Stat stat) {
        return this.statsToCalculate.contains((Object)stat);
    }

    public boolean includeInResponse(Stat stat) {
        if (this.isShard) {
            return this.statsToCalculate.contains((Object)stat);
        }
        return this.statsInResponse.contains((Object)stat);
    }

    public List<Double> getPercentilesList() {
        return this.percentilesList;
    }

    public boolean getIsShard() {
        return this.isShard;
    }

    public double getTdigestCompression() {
        return this.tdigestCompression;
    }

    public HllOptions getHllOptions() {
        return this.hllOpts;
    }

    private static FieldType.NumericType getHashableNumericType(SchemaField field) {
        if (null == field) {
            return FieldType.NumericType.FLOAT;
        }
        FieldType.NumericType result = field.getType().getNumericType();
        return null == result ? FieldType.NumericType.LONG : result;
    }

    public static final class HllOptions {
        final HashFunction hasher;
        final int log2m;
        final int regwidth;
        static final String ERR = "cardinality must be specified as 'true' (for default tunning) or decimal number between 0 and 1 to adjust accuracy vs memory usage (large number is more memory and more accuracy)";

        private HllOptions(int log2m, int regwidth, HashFunction hasher) {
            this.log2m = log2m;
            this.regwidth = regwidth;
            this.hasher = hasher;
        }

        public static HllOptions parseHllOptions(SolrParams localParams, SchemaField field) throws SolrException {
            HashFunction hasher;
            int regwidth;
            int log2m;
            block8: {
                String cardinalityOpt = localParams.get(Stat.cardinality.name());
                if (StringUtils.isBlank((String)cardinalityOpt)) {
                    return null;
                }
                FieldType.NumericType hashableNumType = StatsField.getHashableNumericType(field);
                log2m = 13;
                regwidth = 6;
                if (FieldType.NumericType.FLOAT.equals((Object)hashableNumType) || FieldType.NumericType.INT.equals((Object)hashableNumType)) {
                    --regwidth;
                }
                try {
                    double accuracyOpt = Double.parseDouble(cardinalityOpt);
                    if (accuracyOpt < 0.0 || 1.0 < accuracyOpt) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ERR);
                    }
                    log2m = 4 + (int)Math.round(accuracyOpt * 26.0);
                    int MIN_HUERISTIC_REGWIDTH = regwidth - 1;
                    regwidth = MIN_HUERISTIC_REGWIDTH + (int)Math.round(accuracyOpt * (double)(8 - MIN_HUERISTIC_REGWIDTH));
                }
                catch (NumberFormatException nfe) {
                    if (localParams.getBool(Stat.cardinality.name(), false)) break block8;
                    return null;
                }
            }
            log2m = localParams.getInt("hllLog2m", log2m);
            regwidth = localParams.getInt("hllRegwidth", regwidth);
            if (log2m < 4 || 30 < log2m) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hllLog2m must be at least 4 and at most 30 (" + log2m + ")");
            }
            if (regwidth < 1 || 8 < regwidth) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hllRegwidth must be at least 1 and at most 8");
            }
            HashFunction hashFunction = hasher = localParams.getBool("hllPreHashed", false) ? null : Hashing.murmur3_128();
            if (!(null != hasher || null != field && FieldType.NumericType.LONG.equals((Object)field.getType().getNumericType()))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hllPreHashed is only supported with Long based fields");
            }
            return new HllOptions(log2m, regwidth, hasher);
        }

        public int getLog2m() {
            return this.log2m;
        }

        public int getRegwidth() {
            return this.regwidth;
        }

        public HashFunction getHasher() {
            return this.hasher;
        }

        public HLL newHLL() {
            return new HLL(this.getLog2m(), this.getRegwidth(), -1, false, HLLType.EMPTY);
        }
    }

    public static enum Stat {
        min(true, new Stat[0]),
        max(true, new Stat[0]),
        missing(true, new Stat[0]),
        sum(true, new Stat[0]),
        count(true, new Stat[0]),
        mean(false, sum, count),
        sumOfSquares(true, new Stat[0]),
        stddev(false, sum, count, sumOfSquares),
        distinctValues(true, new Stat[0]),
        countDistinct(false, distinctValues),
        percentiles(true, new Stat[0]){

            @Override
            boolean parseParams(StatsField sf) {
                String percentileParas = sf.localParams.get(this.name());
                if (percentileParas != null) {
                    ArrayList<Double> percentiles = new ArrayList<Double>();
                    try {
                        for (String percentile : StrUtils.splitSmart((String)percentileParas, (char)',')) {
                            percentiles.add(Double.parseDouble(percentile));
                        }
                        if (!percentiles.isEmpty()) {
                            sf.percentilesList.addAll(percentiles);
                            sf.tdigestCompression = sf.localParams.getDouble("tdigestCompression", sf.tdigestCompression);
                            return true;
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to parse stats.field local params: " + sf.localParams + " due to: " + e.getMessage(), (Throwable)e);
                    }
                }
                return false;
            }
        }
        ,
        cardinality(true, new Stat[0]){

            @Override
            boolean parseParams(StatsField sf) {
                try {
                    sf.hllOpts = HllOptions.parseHllOptions(sf.localParams, sf.schemaField);
                    return null != sf.hllOpts;
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to parse stats.field local params: " + sf.localParams + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        };

        private final List<Stat> distribDeps;

        private Stat(boolean selfDep, Stat ... deps) {
            this.distribDeps = new ArrayList<Stat>(deps.length + 1);
            this.distribDeps.addAll(Arrays.asList(deps));
            if (selfDep) {
                this.distribDeps.add(this);
            }
        }

        public static Stat forName(String paramKey) {
            try {
                return Stat.valueOf(paramKey);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public EnumSet<Stat> getDistribDeps() {
            return EnumSet.copyOf(this.distribDeps);
        }

        boolean parseParams(StatsField sf) {
            return sf.localParams.getBool(this.name(), false);
        }
    }
}

