/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.EnumSet;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.DateFormatUtil;
import org.apache.solr.util.DateMathParser;

@Deprecated
public class DateFacetProcessor
extends SimpleFacets {
    public DateFacetProcessor(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        super(req, docs, params, rb);
    }

    @Deprecated
    public void getFacetDateCounts(String dateFacet, NamedList<Object> resOuter) throws IOException {
        Date end;
        Date start;
        IndexSchema schema = this.searcher.getSchema();
        SimpleFacets.ParsedParams parsed = null;
        try {
            parsed = this.parseParams("facet.date", dateFacet);
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
        }
        SolrParams params = parsed.params;
        SolrParams required = parsed.required;
        String key = parsed.key;
        String f = parsed.facetValue;
        SimpleOrderedMap resInner = new SimpleOrderedMap();
        resOuter.add(key, (Object)resInner);
        SchemaField sf = schema.getField(f);
        if (!(sf.getType() instanceof TrieDateField)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not date facet on a field which is not a TrieDateField: " + f);
        }
        String startS = required.getFieldParam(f, "facet.date.start");
        try {
            start = DateFormatUtil.parseMath(null, startS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'start' is not a valid Date string: " + startS, (Throwable)e);
        }
        String endS = required.getFieldParam(f, "facet.date.end");
        try {
            end = DateFormatUtil.parseMath(null, endS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' is not a valid Date string: " + endS, (Throwable)e);
        }
        if (end.before(start)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' comes before 'start': " + endS + " < " + startS);
        }
        String gap = required.getFieldParam(f, "facet.date.gap");
        DateMathParser dmp = new DateMathParser();
        int minCount = params.getFieldInt(f, "facet.mincount", 0);
        String[] iStrs = params.getFieldParams(f, "facet.date.include");
        EnumSet include = null == iStrs || 0 == iStrs.length ? EnumSet.of(FacetParams.FacetRangeInclude.LOWER, FacetParams.FacetRangeInclude.UPPER, FacetParams.FacetRangeInclude.EDGE) : FacetParams.FacetRangeInclude.parseParam((String[])iStrs);
        try {
            Date low = start;
            while (low.before(end)) {
                boolean includeUpper;
                dmp.setNow(low);
                String label = DateFormatUtil.formatExternal(low);
                Date high = dmp.parseMath(gap);
                if (end.before(high)) {
                    if (params.getFieldBool(f, "facet.date.hardend", false)) {
                        high = end;
                    } else {
                        end = high;
                    }
                }
                if (high.before(low)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet infinite loop (is gap negative?)");
                }
                if (high.equals(low)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet infinite loop: gap is effectively zero");
                }
                boolean includeLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && low.equals(start);
                int count = this.rangeCount(parsed, sf, low, high, includeLower, includeUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && high.equals(end));
                if (count >= minCount) {
                    resInner.add(label, (Object)count);
                }
                low = high;
            }
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'gap' is not a valid Date Math string: " + gap, (Throwable)e);
        }
        resInner.add("gap", (Object)gap);
        resInner.add("start", (Object)start);
        resInner.add("end", (Object)end);
        String[] othersP = params.getFieldParams(f, "facet.date.other");
        if (null != othersP && 0 < othersP.length) {
            EnumSet<FacetParams.FacetRangeOther> others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetRangeOther.get((String)o));
            }
            if (!others.contains(FacetParams.FacetRangeOther.NONE)) {
                boolean all = others.contains(FacetParams.FacetRangeOther.ALL);
                if (all || others.contains(FacetParams.FacetRangeOther.BEFORE)) {
                    resInner.add(FacetParams.FacetRangeOther.BEFORE.toString(), (Object)this.rangeCount(parsed, sf, null, start, false, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.AFTER)) {
                    resInner.add(FacetParams.FacetRangeOther.AFTER.toString(), (Object)this.rangeCount(parsed, sf, end, null, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.BETWEEN)) {
                    resInner.add(FacetParams.FacetRangeOther.BETWEEN.toString(), (Object)this.rangeCount(parsed, sf, start, end, include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
            }
        }
    }

    @Deprecated
    public NamedList<Object> getFacetDateCounts() throws IOException {
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] fields = this.global.getParams("facet.date");
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        for (String f : fields) {
            this.getFacetDateCounts(f, (NamedList<Object>)resOuter);
        }
        return resOuter;
    }

    @Deprecated
    protected int rangeCount(SimpleFacets.ParsedParams parsed, SchemaField sf, Date low, Date high, boolean iLow, boolean iHigh) throws IOException {
        String lowStr = low == null ? null : DateFormatUtil.formatExternal(low);
        String highStr = high == null ? null : DateFormatUtil.formatExternal(high);
        Query rangeQ = sf.getType().getRangeQuery(null, sf, lowStr, highStr, iLow, iHigh);
        return this.searcher.numDocs(rangeQ, parsed.docs);
    }
}

