/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.NumberUtils;
import org.apache.solr.util.PropertiesUtil;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.TestInjection;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum CoreAdminOperation {
    CREATE_OP(CoreAdminParams.CoreAdminAction.CREATE){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            SolrParams params = callInfo.req.getParams();
            log.info("core create command {}", (Object)params);
            String coreName = params.required().get("name");
            Map<String, String> coreParams = CoreAdminHandler.buildCoreParams(params);
            CoreContainer coreContainer = callInfo.handler.coreContainer;
            Path instancePath = coreContainer.getCoreRootDirectory().resolve(coreName);
            String instanceDir = callInfo.req.getParams().get("instanceDir");
            if (instanceDir == null) {
                instanceDir = callInfo.req.getParams().get("property.instanceDir");
            }
            if (instanceDir != null) {
                instanceDir = PropertiesUtil.substituteProperty(instanceDir, coreContainer.getContainerProperties());
                instancePath = coreContainer.getCoreRootDirectory().resolve(instanceDir).normalize();
            }
            coreContainer.create(coreName, instancePath, coreParams);
            callInfo.rsp.add("core", coreName);
        }
    }
    ,
    UNLOAD_OP(CoreAdminParams.CoreAdminAction.UNLOAD){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) throws IOException {
            SolrParams params = callInfo.req.getParams();
            String cname = params.get("core");
            boolean deleteIndexDir = params.getBool("deleteIndex", false);
            boolean deleteDataDir = params.getBool("deleteDataDir", false);
            boolean deleteInstanceDir = params.getBool("deleteInstanceDir", false);
            callInfo.handler.coreContainer.unload(cname, deleteIndexDir, deleteDataDir, deleteInstanceDir);
            assert (TestInjection.injectNonExistentCoreExceptionAfterUnload(cname));
        }
    }
    ,
    RELOAD_OP(CoreAdminParams.CoreAdminAction.RELOAD){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            SolrParams params = callInfo.req.getParams();
            String cname = params.get("core");
            if (cname == null || !callInfo.handler.coreContainer.getCoreNames().contains(cname)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core with core name [" + cname + "] does not exist.");
            }
            try {
                callInfo.handler.coreContainer.reload(cname);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'reload' action", (Throwable)ex);
            }
        }
    }
    ,
    STATUS_OP(CoreAdminParams.CoreAdminAction.STATUS){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            SolrParams params = callInfo.req.getParams();
            String cname = params.get("core");
            String indexInfo = params.get("indexInfo");
            boolean isIndexInfoNeeded = Boolean.parseBoolean(null == indexInfo ? "true" : indexInfo);
            SimpleOrderedMap status = new SimpleOrderedMap();
            Map<String, Exception> failures = new HashMap<String, Exception>();
            for (Map.Entry<String, CoreContainer.CoreLoadFailure> failure : callInfo.handler.coreContainer.getCoreInitFailures().entrySet()) {
                failures.put(failure.getKey(), failure.getValue().exception);
            }
            try {
                if (cname == null) {
                    for (String name : callInfo.handler.coreContainer.getAllCoreNames()) {
                        status.add(name, this.getCoreStatus(callInfo.handler.coreContainer, name, isIndexInfoNeeded));
                    }
                    callInfo.rsp.add("initFailures", failures);
                } else {
                    failures = failures.containsKey(cname) ? Collections.singletonMap(cname, failures.get(cname)) : Collections.emptyMap();
                    callInfo.rsp.add("initFailures", failures);
                    status.add(cname, this.getCoreStatus(callInfo.handler.coreContainer, cname, isIndexInfoNeeded));
                }
                callInfo.rsp.add("status", status);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'status' action ", (Throwable)ex);
            }
        }
    }
    ,
    SWAP_OP(CoreAdminParams.CoreAdminAction.SWAP){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            SolrParams params = callInfo.req.getParams();
            RequiredSolrParams required = params.required();
            String cname = params.get("core");
            String other = required.get("other");
            callInfo.handler.coreContainer.swap(cname, other);
        }
    }
    ,
    RENAME_OP(CoreAdminParams.CoreAdminAction.RENAME){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            SolrParams params = callInfo.req.getParams();
            String name = params.get("other");
            String cname = params.get("core");
            if (cname.equals(name)) {
                return;
            }
            callInfo.handler.coreContainer.rename(cname, name);
        }
    }
    ,
    MERGEINDEXES_OP(CoreAdminParams.CoreAdminAction.MERGEINDEXES){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) throws Exception {
            SolrParams params = callInfo.req.getParams();
            String cname = params.required().get("core");
            SolrCore core = callInfo.handler.coreContainer.getCore(cname);
            SolrQueryRequest wrappedReq = null;
            ArrayList sourceCores = Lists.newArrayList();
            ArrayList searchers = Lists.newArrayList();
            ArrayList readersToBeClosed = Lists.newArrayList();
            ArrayList dirsToBeReleased = Lists.newArrayList();
            if (core != null) {
                try {
                    int i;
                    String[] dirNames = params.getParams("indexDir");
                    if (dirNames == null || dirNames.length == 0) {
                        String[] sources = params.getParams("srcCore");
                        if (sources == null || sources.length == 0) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one indexDir or srcCore must be specified");
                        }
                        for (i = 0; i < sources.length; ++i) {
                            String source = sources[i];
                            SolrCore srcCore = callInfo.handler.coreContainer.getCore(source);
                            if (srcCore == null) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core: " + source + " does not exist");
                            }
                            sourceCores.add(srcCore);
                        }
                    } else {
                        DirectoryFactory dirFactory = core.getDirectoryFactory();
                        for (i = 0; i < dirNames.length; ++i) {
                            Directory dir = dirFactory.get(dirNames[i], DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
                            dirsToBeReleased.add(dir);
                            readersToBeClosed.add(DirectoryReader.open((Directory)dir));
                        }
                    }
                    ArrayList readers = null;
                    if (readersToBeClosed.size() > 0) {
                        readers = readersToBeClosed;
                    } else {
                        readers = Lists.newArrayList();
                        for (SolrCore solrCore : sourceCores) {
                            RefCounted<SolrIndexSearcher> searcher = solrCore.getSearcher();
                            searchers.add(searcher);
                            readers.add(searcher.get().getIndexReader());
                        }
                    }
                    UpdateRequestProcessorChain processorChain = core.getUpdateProcessingChain(params.get("update.chain"));
                    wrappedReq = new LocalSolrQueryRequest(core, callInfo.req.getParams());
                    UpdateRequestProcessor processor = processorChain.createProcessor(wrappedReq, callInfo.rsp);
                    processor.processMergeIndexes(new MergeIndexesCommand(readers, callInfo.req));
                }
                catch (Exception e) {
                    log.error("ERROR executing merge:", (Throwable)e);
                    throw e;
                }
                finally {
                    for (RefCounted searcher : searchers) {
                        if (searcher == null) continue;
                        searcher.decref();
                    }
                    for (SolrCore solrCore : sourceCores) {
                        if (solrCore == null) continue;
                        solrCore.close();
                    }
                    IOUtils.closeWhileHandlingException((Iterable)readersToBeClosed);
                    for (Directory dir : dirsToBeReleased) {
                        DirectoryFactory dirFactory = core.getDirectoryFactory();
                        dirFactory.release(dir);
                    }
                    if (wrappedReq != null) {
                        wrappedReq.close();
                    }
                    core.close();
                }
            }
        }
    }
    ,
    SPLIT_OP(CoreAdminParams.CoreAdminAction.SPLIT){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) throws IOException {
            SolrParams params = callInfo.req.getParams();
            ArrayList<DocRouter.Range> ranges = null;
            String[] pathsArr = params.getParams("path");
            String rangesStr = params.get("ranges");
            if (rangesStr != null) {
                String[] rangesArr = rangesStr.split(",");
                if (rangesArr.length == 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least one range specified to split an index");
                }
                ranges = new ArrayList<DocRouter.Range>(rangesArr.length);
                for (String r : rangesArr) {
                    try {
                        ranges.add(DocRouter.DEFAULT.fromString(r));
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception parsing hexadecimal hash range: " + r, (Throwable)e);
                    }
                }
            }
            String splitKey = params.get("split.key");
            String[] newCoreNames = params.getParams("targetCore");
            String cname = params.get("core", "");
            if (!(pathsArr != null && pathsArr.length != 0 || newCoreNames != null && newCoreNames.length != 0)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either path or targetCore param must be specified");
            }
            log.info("Invoked split action for core: " + cname);
            SolrCore core = callInfo.handler.coreContainer.getCore(cname);
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, params);
            ArrayList<SolrCore> newCores = null;
            try {
                List<String> paths = null;
                int partitions = pathsArr != null ? pathsArr.length : newCoreNames.length;
                DocRouter router = null;
                String routeFieldName = null;
                if (callInfo.handler.coreContainer.isZooKeeperAware()) {
                    Object routerObj;
                    ClusterState clusterState = callInfo.handler.coreContainer.getZkController().getClusterState();
                    String collectionName = req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName();
                    DocCollection collection = clusterState.getCollection(collectionName);
                    String sliceName = req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                    Slice slice = clusterState.getSlice(collectionName, sliceName);
                    DocRouter docRouter = router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
                    if (ranges == null) {
                        DocRouter.Range currentRange = slice.getRange();
                        ArrayList<DocRouter.Range> arrayList = ranges = currentRange != null ? router.partitionRange(partitions, currentRange) : null;
                    }
                    if ((routerObj = collection.get("router")) != null && routerObj instanceof Map) {
                        Map routerProps = (Map)routerObj;
                        routeFieldName = (String)routerProps.get("field");
                    }
                }
                if (pathsArr == null) {
                    newCores = new ArrayList<SolrCore>(partitions);
                    for (String newCoreName : newCoreNames) {
                        SolrCore newcore = callInfo.handler.coreContainer.getCore(newCoreName);
                        if (newcore == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core with core name " + newCoreName + " expected but doesn't exist.");
                        }
                        newCores.add(newcore);
                    }
                } else {
                    paths = Arrays.asList(pathsArr);
                }
                SplitIndexCommand cmd = new SplitIndexCommand(req, paths, newCores, ranges, router, routeFieldName, splitKey);
                core.getUpdateHandler().split(cmd);
            }
            catch (Exception e) {
                log.error("ERROR executing split:", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                if (req != null) {
                    req.close();
                }
                if (core != null) {
                    core.close();
                }
                if (newCores != null) {
                    for (SolrCore newCore : newCores) {
                        newCore.close();
                    }
                }
            }
        }
    }
    ,
    PREPRECOVERY_OP(CoreAdminParams.CoreAdminAction.PREPRECOVERY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) throws InterruptedException, IOException, KeeperException {
            SolrParams params = callInfo.req.getParams();
            String cname = params.get("core");
            if (cname == null) {
                cname = "";
            }
            String nodeName = params.get("nodeName");
            String coreNodeName = params.get("coreNodeName");
            Replica.State waitForState = Replica.State.getState((String)params.get("state"));
            Boolean checkLive = params.getBool("checkLive");
            Boolean onlyIfLeader = params.getBool("onlyIfLeader");
            Boolean onlyIfLeaderActive = params.getBool("onlyIfLeaderActive");
            log.info("Going to wait for coreNodeName: " + coreNodeName + ", state: " + waitForState + ", checkLive: " + checkLive + ", onlyIfLeader: " + onlyIfLeader + ", onlyIfLeaderActive: " + onlyIfLeaderActive);
            int maxTries = 0;
            Replica.State state = null;
            boolean live = false;
            int retry = 0;
            while (true) {
                block40: {
                    CoreContainer coreContainer = callInfo.handler.coreContainer;
                    try (SolrCore core = coreContainer.getCore(cname);){
                        if (core == null && retry == 30) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "core not found:" + cname);
                        }
                        if (core != null) {
                            Replica replica;
                            String collection;
                            ClusterState clusterState;
                            Slice slice;
                            if (onlyIfLeader != null && onlyIfLeader.booleanValue() && !core.getCoreDescriptor().getCloudDescriptor().isLeader()) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We are not the leader");
                            }
                            CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
                            if (retry % 15 == 0) {
                                if (retry > 0 && log.isInfoEnabled()) {
                                    log.info("After " + retry + " seconds, core " + cname + " (" + cloudDescriptor.getShardId() + " of " + cloudDescriptor.getCollectionName() + ") still does not have state: " + waitForState + "; forcing ClusterState update from ZooKeeper");
                                }
                                coreContainer.getZkController().getZkStateReader().updateClusterState();
                            }
                            if (maxTries == 0) {
                                int conflictWaitMs = coreContainer.getZkController().getLeaderConflictResolveWait();
                                maxTries = Math.round(conflictWaitMs / 1000) + 3;
                                log.info("Will wait a max of " + maxTries + " seconds to see " + cname + " (" + cloudDescriptor.getShardId() + " of " + cloudDescriptor.getCollectionName() + ") have state: " + waitForState);
                            }
                            if ((slice = (clusterState = coreContainer.getZkController().getClusterState()).getSlice(collection = cloudDescriptor.getCollectionName(), cloudDescriptor.getShardId())) != null && (replica = (Replica)slice.getReplicasMap().get(coreNodeName)) != null) {
                                boolean leaderDoesNotNeedRecovery;
                                state = replica.getState();
                                live = clusterState.liveNodesContain(nodeName);
                                Replica.State localState = cloudDescriptor.getLastPublished();
                                boolean bl = leaderDoesNotNeedRecovery = onlyIfLeader != null && onlyIfLeader != false && core.getName().equals(replica.getStr("core")) && waitForState == Replica.State.RECOVERING && localState == Replica.State.ACTIVE && state == Replica.State.ACTIVE;
                                if (leaderDoesNotNeedRecovery) {
                                    log.warn("Leader " + core.getName() + " ignoring request to be in the recovering state because it is live and active.");
                                }
                                boolean onlyIfActiveCheckResult = onlyIfLeaderActive != null && onlyIfLeaderActive != false && localState != Replica.State.ACTIVE;
                                log.info("In WaitForState(" + waitForState + "): collection=" + collection + ", shard=" + slice.getName() + ", thisCore=" + core.getName() + ", leaderDoesNotNeedRecovery=" + leaderDoesNotNeedRecovery + ", isLeader? " + core.getCoreDescriptor().getCloudDescriptor().isLeader() + ", live=" + live + ", checkLive=" + checkLive + ", currentState=" + state.toString() + ", localState=" + localState + ", nodeName=" + nodeName + ", coreNodeName=" + coreNodeName + ", onlyIfActiveCheckResult=" + onlyIfActiveCheckResult + ", nodeProps: " + replica);
                                if (!onlyIfActiveCheckResult && replica != null && (state == waitForState || leaderDoesNotNeedRecovery) && (checkLive == null || checkLive.booleanValue() && live || !checkLive.booleanValue() && !live)) break;
                            }
                        }
                        if (retry++ == maxTries) {
                            String collection = null;
                            String leaderInfo = null;
                            String shardId = null;
                            try {
                                CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
                                collection = cloudDescriptor.getCollectionName();
                                shardId = cloudDescriptor.getShardId();
                                leaderInfo = coreContainer.getZkController().getZkStateReader().getLeaderUrl(collection, shardId, 5000);
                            }
                            catch (Exception exc) {
                                leaderInfo = "Not available due to: " + exc;
                            }
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "I was asked to wait on state " + waitForState + " for " + shardId + " in " + collection + " on " + nodeName + " but I still do not see the requested state. I see state: " + state.toString() + " live:" + live + " leader from ZK: " + leaderInfo);
                        }
                        if (coreContainer.isShutDown()) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr is shutting down");
                        }
                        if (!log.isDebugEnabled()) break block40;
                        try {
                            LocalSolrQueryRequest r = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
                            CommitUpdateCommand commitCmd = new CommitUpdateCommand(r, false);
                            commitCmd.softCommit = true;
                            core.getUpdateHandler().commit(commitCmd);
                            RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                            SolrIndexSearcher searcher = searchHolder.get();
                            try {
                                log.debug(core.getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " to replicate " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits + " gen:" + core.getDeletionPolicy().getLatestCommit().getGeneration() + " data:" + core.getDataDir());
                            }
                            finally {
                                searchHolder.decref();
                            }
                        }
                        catch (Exception e) {
                            log.debug("Error in solrcloud_debug block", (Throwable)e);
                        }
                    }
                }
                Thread.sleep(1000L);
            }
            log.info("Waited coreNodeName: " + coreNodeName + ", state: " + waitForState + ", checkLive: " + checkLive + ", onlyIfLeader: " + onlyIfLeader + " for: " + retry + " seconds.");
        }
    }
    ,
    REQUESTRECOVERY_OP(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) throws IOException {
            SolrParams params = callInfo.req.getParams();
            log.info("It has been requested that we recover: core=" + params.get("core"));
            String cname = params.get("core");
            if (cname == null) {
                cname = "";
            }
            try (SolrCore core = callInfo.handler.coreContainer.getCore(cname);){
                if (core != null) {
                    core.getUpdateHandler().getSolrCoreState().doRecovery(callInfo.handler.coreContainer, core.getCoreDescriptor());
                } else {
                    SolrException.log((Logger)log, (String)("Could not find core to call recovery:" + cname));
                }
            }
        }
    }
    ,
    REQUESTSYNCSHARD_OP(CoreAdminParams.CoreAdminAction.REQUESTSYNCSHARD){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) throws IOException {
            block27: {
                SolrParams params = callInfo.req.getParams();
                log.info("I have been requested to sync up my shard");
                ZkController zkController = callInfo.handler.coreContainer.getZkController();
                if (zkController == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only valid for SolrCloud");
                }
                String cname = params.get("core");
                if (cname == null) {
                    throw new IllegalArgumentException("core is required");
                }
                try (SyncStrategy syncStrategy = null;
                     SolrCore core = callInfo.handler.coreContainer.getCore(cname);){
                    if (core != null) {
                        syncStrategy = new SyncStrategy(core.getCoreDescriptor().getCoreContainer());
                        HashMap<String, String> props = new HashMap<String, String>();
                        props.put("base_url", zkController.getBaseUrl());
                        props.put("core", cname);
                        props.put("node_name", zkController.getNodeName());
                        boolean success = syncStrategy.sync(zkController, core, new ZkNodeProps(props), true);
                        if (log.isDebugEnabled()) {
                            try {
                                RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                                SolrIndexSearcher searcher = searchHolder.get();
                                try {
                                    log.debug(core.getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " synched " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits);
                                }
                                finally {
                                    searchHolder.decref();
                                }
                            }
                            catch (Exception e) {
                                log.debug("Error in solrcloud_debug block", (Throwable)e);
                            }
                        }
                        if (!success) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Sync Failed");
                        }
                        break block27;
                    }
                    SolrException.log((Logger)log, (String)("Could not find core to call sync:" + cname));
                }
            }
        }
    }
    ,
    REQUESTBUFFERUPDATES_OP(CoreAdminParams.CoreAdminAction.REQUESTBUFFERUPDATES){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            SolrParams params = callInfo.req.getParams();
            String cname = params.get("name", "");
            log.info("Starting to buffer updates on core:" + cname);
            try (SolrCore core = callInfo.handler.coreContainer.getCore(cname);){
                if (core == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core [" + cname + "] does not exist");
                }
                UpdateLog updateLog = core.getUpdateHandler().getUpdateLog();
                if (updateLog.getState() != UpdateLog.State.ACTIVE) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core " + cname + " not in active state");
                }
                updateLog.bufferUpdates();
                callInfo.rsp.add("core", cname);
                callInfo.rsp.add("status", "BUFFERING");
            }
            catch (Throwable e) {
                if (e instanceof SolrException) {
                    throw (SolrException)e;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not start buffering updates", e);
            }
            finally {
                if (callInfo.req != null) {
                    callInfo.req.close();
                }
            }
        }
    }
    ,
    REQUESTAPPLYUPDATES_OP(CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            SolrParams params = callInfo.req.getParams();
            String cname = params.get("name", "");
            log.info("Applying buffered updates on core: " + cname);
            CoreContainer coreContainer = callInfo.handler.coreContainer;
            try (SolrCore core = coreContainer.getCore(cname);){
                if (core == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core [" + cname + "] not found");
                }
                UpdateLog updateLog = core.getUpdateHandler().getUpdateLog();
                if (updateLog.getState() != UpdateLog.State.BUFFERING) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core " + cname + " not in buffering state");
                }
                Future<UpdateLog.RecoveryInfo> future = updateLog.applyBufferedUpdates();
                if (future == null) {
                    log.info("No buffered updates available. core=" + cname);
                    callInfo.rsp.add("core", cname);
                    callInfo.rsp.add("status", "EMPTY_BUFFER");
                    return;
                }
                UpdateLog.RecoveryInfo report = future.get();
                if (report.failed) {
                    SolrException.log((Logger)log, (String)"Replay failed");
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
                }
                coreContainer.getZkController().publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                callInfo.rsp.add("core", cname);
                callInfo.rsp.add("status", "BUFFER_APPLIED");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Recovery was interrupted", (Throwable)e);
            }
            catch (Exception e) {
                if (e instanceof SolrException) {
                    throw (SolrException)((Object)e);
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not apply buffered updates", (Throwable)e);
            }
            finally {
                if (callInfo.req != null) {
                    callInfo.req.close();
                }
            }
        }
    }
    ,
    REQUESTSTATUS_OP(CoreAdminParams.CoreAdminAction.REQUESTSTATUS){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            SolrParams params = callInfo.req.getParams();
            String requestId = params.get("requestid");
            log.info("Checking request status for : " + requestId);
            if (callInfo.handler.getRequestStatusMap(CoreAdminHandler.RUNNING).containsKey(requestId)) {
                callInfo.rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.RUNNING);
            } else if (callInfo.handler.getRequestStatusMap(CoreAdminHandler.COMPLETED).containsKey(requestId)) {
                callInfo.rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.COMPLETED);
                callInfo.rsp.add(CoreAdminHandler.RESPONSE, callInfo.handler.getRequestStatusMap(CoreAdminHandler.COMPLETED).get(requestId).getRspObject());
            } else if (callInfo.handler.getRequestStatusMap(CoreAdminHandler.FAILED).containsKey(requestId)) {
                callInfo.rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.FAILED);
                callInfo.rsp.add(CoreAdminHandler.RESPONSE, callInfo.handler.getRequestStatusMap(CoreAdminHandler.FAILED).get(requestId).getRspObject());
            } else {
                callInfo.rsp.add(CoreAdminHandler.RESPONSE_STATUS, "notfound");
                callInfo.rsp.add(CoreAdminHandler.RESPONSE_MESSAGE, "No task found in running, completed or failed tasks");
            }
        }
    }
    ,
    OVERSEEROP_OP(CoreAdminParams.CoreAdminAction.OVERSEEROP){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            ZkController zkController = callInfo.handler.coreContainer.getZkController();
            if (zkController != null) {
                String op = callInfo.req.getParams().get("op");
                String electionNode = callInfo.req.getParams().get("electionNode");
                if (electionNode != null) {
                    zkController.rejoinOverseerElection(electionNode, "rejoinAtHead".equals(op));
                } else {
                    log.info("electionNode is required param");
                }
            }
        }
    }
    ,
    REJOINLEADERELECTION_OP(CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) {
            ZkController zkController = callInfo.handler.coreContainer.getZkController();
            if (zkController != null) {
                zkController.rejoinShardLeaderElection(callInfo.req.getParams());
            } else {
                log.warn("zkController is null in CoreAdminHandler.handleRequestInternal:REJOINLEADERELECTION. No action taken.");
            }
        }
    }
    ,
    INVOKE_OP(CoreAdminParams.CoreAdminAction.INVOKE){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) throws Exception {
            String[] klas = callInfo.req.getParams().getParams("class");
            if (klas == null || klas.length == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "class is a required param");
            }
            for (String c : klas) {
                Map<String, Object> result = this.invokeAClass(callInfo.req, c);
                callInfo.rsp.add(c, result);
            }
        }

        Map<String, Object> invokeAClass(SolrQueryRequest req, String c) {
            SolrResourceLoader loader = null;
            if (req.getCore() != null) {
                loader = req.getCore().getResourceLoader();
            } else if (req.getContext().get(CoreContainer.class.getName()) != null) {
                CoreContainer cc = (CoreContainer)req.getContext().get(CoreContainer.class.getName());
                loader = cc.getResourceLoader();
            }
            CoreAdminHandler.Invocable invokable = loader.newInstance(c, CoreAdminHandler.Invocable.class);
            Map<String, Object> result = invokable.invoke(req);
            log.info("Invocable_invoked {}", result);
            return result;
        }
    }
    ,
    FORCEPREPAREFORLEADERSHIP_OP(CoreAdminParams.CoreAdminAction.FORCEPREPAREFORLEADERSHIP){

        @Override
        public void call(CoreAdminHandler.CallInfo callInfo) throws IOException {
            SolrParams params = callInfo.req.getParams();
            log.info("I have been forcefully prepare myself for leadership.");
            ZkController zkController = callInfo.handler.coreContainer.getZkController();
            if (zkController == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only valid for SolrCloud");
            }
            String cname = params.get("core");
            if (cname == null) {
                throw new IllegalArgumentException("core is required");
            }
            try (SolrCore core = callInfo.handler.coreContainer.getCore(cname);){
                if (core != null) {
                    core.getCoreDescriptor().getCloudDescriptor().setLastPublished(Replica.State.ACTIVE);
                    log.info("Setting the last published state for this core, {}, to {}", (Object)core.getName(), (Object)Replica.State.ACTIVE);
                } else {
                    SolrException.log((Logger)log, (String)("Could not find core: " + cname));
                }
            }
        }
    };

    private static final Logger log;
    final CoreAdminParams.CoreAdminAction action;

    public abstract void call(CoreAdminHandler.CallInfo var1) throws Exception;

    private CoreAdminOperation(CoreAdminParams.CoreAdminAction action) {
        this.action = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamedList<Object> getCoreStatus(CoreContainer cores, String cname, boolean isIndexInfoNeeded) throws IOException {
        SimpleOrderedMap info;
        block22: {
            info = new SimpleOrderedMap();
            if (!cores.isLoaded(cname)) {
                CoreDescriptor desc = cores.getUnloadedCoreDescriptor(cname);
                if (desc != null) {
                    info.add("name", (Object)desc.getName());
                    info.add("instanceDir", (Object)desc.getInstanceDir());
                    String tmp = desc.getDataDir();
                    if (StringUtils.isNotBlank((String)tmp)) {
                        info.add("dataDir", (Object)tmp);
                    }
                    if (StringUtils.isNotBlank((String)(tmp = desc.getConfigName()))) {
                        info.add("config", (Object)tmp);
                    }
                    if (StringUtils.isNotBlank((String)(tmp = desc.getSchemaName()))) {
                        info.add("schema", (Object)tmp);
                    }
                    info.add("isLoaded", (Object)"false");
                }
            } else {
                try (SolrCore core = cores.getCore(cname);){
                    if (core == null) break block22;
                    info.add("name", (Object)core.getName());
                    info.add("instanceDir", (Object)core.getResourceLoader().getInstancePath().toString());
                    info.add("dataDir", (Object)CoreAdminHandler.normalizePath(core.getDataDir()));
                    info.add("config", (Object)core.getConfigResource());
                    info.add("schema", (Object)core.getSchemaResource());
                    info.add("startTime", (Object)core.getStartTimeStamp());
                    info.add("uptime", (Object)core.getUptimeMs());
                    if (cores.isZooKeeperAware()) {
                        info.add("lastPublished", (Object)core.getCoreDescriptor().getCloudDescriptor().getLastPublished().toString().toLowerCase(Locale.ROOT));
                    }
                    if (!isIndexInfoNeeded) break block22;
                    RefCounted<SolrIndexSearcher> searcher = core.getSearcher();
                    try {
                        SimpleOrderedMap<Object> indexInfo = LukeRequestHandler.getIndexInfo(searcher.get().getIndexReader());
                        long size = this.getIndexSize(core);
                        indexInfo.add("sizeInBytes", (Object)size);
                        indexInfo.add("size", (Object)NumberUtils.readableSize(size));
                        info.add("index", indexInfo);
                    }
                    finally {
                        searcher.decref();
                    }
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getIndexSize(SolrCore core) {
        long size = 0L;
        try {
            Directory dir = core.getDirectoryFactory().get(core.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
            try {
                size = DirectoryFactory.sizeOfDirectory(dir);
            }
            finally {
                core.getDirectoryFactory().release(dir);
            }
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (String)"IO error while trying to get the size of the Directory", (Throwable)e);
        }
        return size;
    }

    static {
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

