/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.ClusterStatus;
import org.apache.solr.handler.admin.RebalanceLeaders;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.SolrIdentifierValidator;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    static final Set<String> KNOWN_ROLES = ImmutableSet.of((Object)"overseer");
    public static long DEFAULT_ZK_TIMEOUT = 180000L;
    public static final String SYSTEM_COLL = ".system";
    public static final List<String> MODIFIABLE_COLL_PROPS = ImmutableList.of((Object)"rule", (Object)"snitch", (Object)"replicationFactor", (Object)"maxShardsPerNode", (Object)"autoAddReplicas");

    public CollectionsHandler() {
        this.coreContainer = null;
    }

    public CollectionsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!cores.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a != null) {
            CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)a);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
            }
            CollectionOperation operation = CollectionOperation.get(action);
            log.info("Invoked Collection Action :{} with params {} ", (Object)action.toLower(), (Object)req.getParamString());
            Map<String, Object> props = operation.call(req, rsp, this);
            String asyncId = req.getParams().get("async");
            if (props != null) {
                if (asyncId != null) {
                    props.put("async", asyncId);
                }
                props.put("operation", operation.action.toLower());
                ZkNodeProps zkProps = new ZkNodeProps(props);
                if (operation.sendToOCPQueue) {
                    this.handleResponse(operation.action.toLower(), zkProps, rsp, operation.timeOut);
                } else {
                    Overseer.getInQueue(this.coreContainer.getZkController().getZkClient()).offer(Utils.toJSON(props));
                }
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        rsp.setHttpCaching(false);
    }

    void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        this.handleResponse(operation, m, rsp, DEFAULT_ZK_TIMEOUT);
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        if (m.containsKey("async") && m.get("async") != null) {
            String asyncId = m.getStr("async");
            if (asyncId.equals("-1")) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "requestid can not be -1. It is reserved for cleanup purposes.");
            }
            NamedList r = new NamedList();
            if (this.coreContainer.getZkController().getOverseerCompletedMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerFailureMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerRunningMap().contains(asyncId) || this.overseerCollectionQueueContains(asyncId)) {
                r.add("error", (Object)"Task with the same requestid already exists.");
            } else {
                this.coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m));
            }
            r.add("requestid", (Object)((String)m.get("async")));
            OverseerSolrResponse response = new OverseerSolrResponse(r);
            rsp.getValues().addAll(response.getResponse());
            return;
        }
        OverseerTaskQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            SolrResponse response = SolrResponse.deserialize((byte[])event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
        } else {
            if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection time out:" + timeout / 1000L + "s");
            }
            if (event.getWatchedEvent() != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection unknown case");
        }
    }

    private boolean overseerCollectionQueueContains(String asyncId) throws KeeperException, InterruptedException {
        OverseerTaskQueue collectionQueue = this.coreContainer.getZkController().getOverseerCollectionQueue();
        return collectionQueue.containsTaskWithRequestId("async", asyncId);
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            props.put(param, params.get(param));
        }
        return props;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud Collections";
    }

    private static void forceLeaderElection(SolrQueryRequest req, CollectionsHandler handler) {
        ClusterState clusterState = handler.coreContainer.getZkController().getClusterState();
        String collection = req.getParams().required().get("collection");
        String sliceId = req.getParams().required().get("shard");
        log.info("Force leader invoked, state: {}", (Object)clusterState);
        Slice slice = clusterState.getSlice(collection, sliceId);
        if (slice == null) {
            if (clusterState.hasCollection(collection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with name " + sliceId + " exists for collection " + collection);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collection);
        }
        try {
            Replica leader = slice.getLeader();
            if (leader != null && leader.getState() == Replica.State.ACTIVE) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard already has an active leader. Force leader is not applicable. State: " + slice);
            }
            String lirPath = handler.coreContainer.getZkController().getLeaderInitiatedRecoveryZnodePath(collection, sliceId);
            if (handler.coreContainer.getZkController().getZkClient().exists(lirPath, true).booleanValue()) {
                StringBuilder sb = new StringBuilder();
                handler.coreContainer.getZkController().getZkClient().printLayout(lirPath, 4, sb);
                log.info("Cleaning out LIR data, which was: {}", (Object)sb);
                handler.coreContainer.getZkController().getZkClient().clean(lirPath);
            }
            for (Replica rep : slice.getReplicas()) {
                if (!clusterState.getLiveNodes().contains(rep.getNodeName())) continue;
                ShardHandler shardHandler = handler.coreContainer.getShardHandlerFactory().getShardHandler();
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.FORCEPREPAREFORLEADERSHIP.toString()});
                params.set("core", new String[]{rep.getStr("core")});
                String nodeName = rep.getNodeName();
                OverseerCollectionMessageHandler.sendShardRequest(nodeName, params, shardHandler, null, null, "/admin/cores", handler.coreContainer.getZkController().getZkStateReader());
            }
            boolean success = false;
            for (int i = 0; i < 9; ++i) {
                Thread.sleep(5000L);
                clusterState = handler.coreContainer.getZkController().getClusterState();
                slice = clusterState.getSlice(collection, sliceId);
                if (slice.getLeader() != null && slice.getLeader().getState() == Replica.State.ACTIVE) {
                    success = true;
                    break;
                }
                log.warn("Force leader attempt {}. Waiting 5 secs for an active leader. State of the slice: {}", (Object)(i + 1), (Object)slice);
            }
            if (success) {
                log.info("Successfully issued FORCELEADER command for collection: {}, shard: {}", (Object)collection, (Object)sliceId);
            } else {
                log.info("Couldn't successfully force leader, collection: {}, shard: {}. Cluster state: {}", new Object[]{collection, sliceId, clusterState});
            }
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing FORCELEADER operation for collection: " + collection + " shard: " + sliceId, (Throwable)e);
        }
    }

    public static void verifyRuleParams(CoreContainer cc, Map<String, Object> m) {
        List l = (List)m.get("rule");
        if (l != null) {
            for (Object o : l) {
                Map map = (Map)o;
                try {
                    new Rule(map);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error in rule " + m, (Throwable)e);
                }
            }
        }
        ReplicaAssigner.verifySnitchConf(cc, (List)m.get("snitch"));
    }

    private static Map<String, Object> addMapObject(Map<String, Object> props, String key) {
        Object v = props.get(key);
        if (v == null) {
            return props;
        }
        ArrayList<String> val = new ArrayList<String>();
        if (v instanceof String[]) {
            val.addAll(Arrays.asList((String[])v));
        } else {
            val.add(v.toString());
        }
        if (val.size() > 0) {
            ArrayList<Map> l = new ArrayList<Map>();
            for (String rule : val) {
                l.add(Rule.parseRule(rule));
            }
            props.put(key, l);
        }
        return props;
    }

    static enum CollectionOperation {
        CREATE_OP(CollectionParams.CollectionAction.CREATE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws KeeperException, InterruptedException {
                Map props = req.getParams().required().getAll(null, new String[]{"name"});
                props.put("fromApi", "true");
                req.getParams().getAll(props, new String[]{"replicationFactor", "collection.configName", "numShards", "maxShardsPerNode", "createNodeSet", "createNodeSet.shuffle", "shards", "stateFormat", "autoAddReplicas", "rule", "snitch"});
                if (props.get("stateFormat") == null) {
                    props.put("stateFormat", "2");
                }
                CollectionsHandler.addMapObject(props, "rule");
                CollectionsHandler.addMapObject(props, "snitch");
                CollectionsHandler.verifyRuleParams(h.coreContainer, props);
                String collectionName = (String)props.get("name");
                SolrIdentifierValidator.validateCollectionName(collectionName);
                if (CollectionsHandler.SYSTEM_COLL.equals(collectionName)) {
                    props.put("numShards", 1);
                    props.remove("shards");
                    this.createSysConfigSet(h.coreContainer);
                }
                CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "router.");
            }

            private void createSysConfigSet(CoreContainer coreContainer) throws KeeperException, InterruptedException {
                SolrZkClient zk = coreContainer.getZkController().getZkStateReader().getZkClient();
                ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zk.getZkClientTimeout());
                cmdExecutor.ensureExists("/configs", zk);
                cmdExecutor.ensureExists("/configs/.system", zk);
                String path = "/configs/.system/schema.xml";
                byte[] data = "<?xml version='1.0' ?>\n<schema name='_system collection or core' version='1.1'>\n  <fieldtype name='string'  class='solr.StrField' sortMissingLast='true' omitNorms='true'/>\n  <fieldType name='long' class='solr.TrieLongField' precisionStep='0' positionIncrementGap='0'/>\n  <fieldType name='bytes' class='solr.BinaryField'/>\n  <fieldType name='date' class='solr.TrieDateField'/>\n  <field name='id'   type='string'   indexed='true'  stored='true'  multiValued='false' required='true'/>\n  <field name='md5'   type='string'   indexed='true'  stored='true'  multiValued='false' required='true'/>\n  <field name='blob'      type='bytes'   indexed='false' stored='true'  multiValued='false' />\n  <field name='size'      type='long'   indexed='true' stored='true'  multiValued='false' />\n  <field name='version'   type='long'     indexed='true'  stored='true'  multiValued='false' />\n  <field name='timestamp'   type='date'   indexed='true'  stored='true'  multiValued='false' />\n  <field name='blobName'      type='string'   indexed='true'  stored='true'  multiValued='false' />\n  <field name='_version_' type='long'     indexed='true'  stored='true'/>\n  <uniqueKey>id</uniqueKey>\n</schema>".replaceAll("'", "\"").getBytes(StandardCharsets.UTF_8);
                cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
                path = "/configs/.system/solrconfig.xml";
                data = "<?xml version='1.0' ?>\n<config>\n<luceneMatchVersion>LATEST</luceneMatchVersion>\n<directoryFactory name='DirectoryFactory' class='${solr.directoryFactory:solr.StandardDirectoryFactory}'/>\n<updateHandler class='solr.DirectUpdateHandler2'>\n  <updateLog>\n    <str name='dir'>${solr.ulog.dir:}</str>\n  </updateLog>\n       <autoCommit> \n       <maxDocs>1</maxDocs> \n       <openSearcher>true</openSearcher> \n  </autoCommit></updateHandler>\n<requestHandler name='standard' class='solr.StandardRequestHandler' default='true' />\n<requestHandler name='/analysis/field' startup='lazy' class='solr.FieldAnalysisRequestHandler' />\n<requestHandler name='/blob' class='solr.BlobHandler'>\n  <lst name='invariants'>\n<str name='maxSize'>${blob.max.size.mb:5}</str>\n</lst>\n</requestHandler>\n</config>".replaceAll("'", "\"").getBytes(StandardCharsets.UTF_8);
                cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
            }
        }
        ,
        DELETE_OP(CollectionParams.CollectionAction.DELETE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        RELOAD_OP(CollectionParams.CollectionAction.RELOAD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        SYNCSHARD_OP(CollectionParams.CollectionAction.SYNCSHARD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                String collection = req.getParams().required().get("collection");
                String shard = req.getParams().required().get("shard");
                ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
                Replica leaderProps = clusterState.getLeader(collection, shard);
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
                try (HttpSolrClient client = new HttpSolrClient(nodeProps.getBaseUrl());){
                    client.setConnectionTimeout(15000);
                    client.setSoTimeout(60000);
                    CoreAdminRequest.RequestSyncShard reqSyncShard = new CoreAdminRequest.RequestSyncShard();
                    reqSyncShard.setCollection(collection);
                    reqSyncShard.setShard(shard);
                    reqSyncShard.setCoreName(nodeProps.getCoreName());
                    client.request((SolrRequest)reqSyncShard);
                }
                return null;
            }
        }
        ,
        CREATEALIAS_OP(CollectionParams.CollectionAction.CREATEALIAS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                String aliasName = req.getParams().get("name");
                SolrIdentifierValidator.validateCollectionName(aliasName);
                return req.getParams().required().getAll(null, new String[]{"name", "collections"});
            }
        }
        ,
        DELETEALIAS_OP(CollectionParams.CollectionAction.DELETEALIAS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        SPLITSHARD_OP(CollectionParams.CollectionAction.SPLITSHARD, DEFAULT_ZK_TIMEOUT * 5L, true){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                String name = req.getParams().required().get("collection");
                String shard = req.getParams().get("shard");
                String rangesStr = req.getParams().get("ranges");
                String splitKey = req.getParams().get("split.key");
                if (splitKey == null && shard == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: shard");
                }
                if (splitKey != null && shard != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'shard' or 'split.key' should be specified");
                }
                if (splitKey != null && rangesStr != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'ranges' or 'split.key' should be specified");
                }
                Map map = req.getParams().getAll(null, new String[]{"collection", "shard", "split.key", "ranges"});
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
            }
        }
        ,
        DELETESHARD_OP(CollectionParams.CollectionAction.DELETESHARD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"collection", "shard"});
            }
        }
        ,
        FORCELEADER_OP(CollectionParams.CollectionAction.FORCELEADER){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                CollectionsHandler.forceLeaderElection(req, handler);
                return null;
            }
        }
        ,
        CREATESHARD_OP(CollectionParams.CollectionAction.CREATESHARD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "shard"});
                ClusterState clusterState = handler.coreContainer.getZkController().getClusterState();
                if (!"implicit".equals(((Map)clusterState.getCollection(req.getParams().get("collection")).get("router")).get("name"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards can be added only to 'implicit' collections");
                }
                req.getParams().getAll(map, new String[]{"replicationFactor", "createNodeSet"});
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
            }
        }
        ,
        DELETEREPLICA_OP(CollectionParams.CollectionAction.DELETEREPLICA){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "shard", "replica"});
                return req.getParams().getAll(map, new String[]{"onlyIfDown"});
            }
        }
        ,
        MIGRATE_OP(CollectionParams.CollectionAction.MIGRATE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "split.key", "target.collection"});
                return req.getParams().getAll(map, new String[]{"forward.timeout"});
            }
        }
        ,
        ADDROLE_OP(CollectionParams.CollectionAction.ADDROLE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"role", "node"});
                if (!KNOWN_ROLES.contains(map.get("role"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
                }
                return map;
            }
        }
        ,
        REMOVEROLE_OP(CollectionParams.CollectionAction.REMOVEROLE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"role", "node"});
                if (!KNOWN_ROLES.contains(map.get("role"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
                }
                return map;
            }
        }
        ,
        CLUSTERPROP_OP(CollectionParams.CollectionAction.CLUSTERPROP){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                String name = req.getParams().required().get("name");
                String val = req.getParams().get("val");
                h.coreContainer.getZkController().getZkStateReader().setClusterProperty(name, val);
                return null;
            }
        }
        ,
        REQUESTSTATUS_OP(CollectionParams.CollectionAction.REQUESTSTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                DistributedMap.MapEvent mapEvent;
                req.getParams().required().check(new String[]{"requestid"});
                CoreContainer coreContainer = h.coreContainer;
                String requestId = req.getParams().get("requestid");
                ZkController zkController = coreContainer.getZkController();
                if (requestId.equals("-1")) {
                    zkController.getOverseerCompletedMap().clear();
                    zkController.getOverseerFailureMap().clear();
                    rsp.getValues().add("status", (Object)"successfully cleared stored collection api responses");
                    rsp.getValues().add("warning", (Object)"Use of REQUESTSTATUS for clearing stored responses has been deprecated. Kindly use DELETESTATUS API for the same.");
                    return null;
                }
                NamedList results = new NamedList();
                if (zkController.getOverseerCompletedMap().contains(requestId)) {
                    mapEvent = zkController.getOverseerCompletedMap().get(requestId);
                    rsp.getValues().addAll(SolrResponse.deserialize((byte[])mapEvent.getBytes()).getResponse());
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.COMPLETED, "found [" + requestId + "] in completed tasks");
                } else if (zkController.getOverseerFailureMap().contains(requestId)) {
                    mapEvent = zkController.getOverseerFailureMap().get(requestId);
                    rsp.getValues().addAll(SolrResponse.deserialize((byte[])mapEvent.getBytes()).getResponse());
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.FAILED, "found [" + requestId + "] in failed tasks");
                } else if (zkController.getOverseerRunningMap().contains(requestId)) {
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.RUNNING, "found [" + requestId + "] in running tasks");
                } else if (h.overseerCollectionQueueContains(requestId)) {
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.SUBMITTED, "found [" + requestId + "] in submitted tasks");
                } else {
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.NOT_FOUND, "Did not find [" + requestId + "] in any tasks queue");
                }
                OverseerSolrResponse response = new OverseerSolrResponse(results);
                rsp.getValues().addAll(response.getResponse());
                return null;
            }

            private void addStatusToResponse(NamedList<Object> results, RequestStatusState state, String msg) {
                SimpleOrderedMap status = new SimpleOrderedMap();
                status.add("state", (Object)state.getKey());
                status.add("msg", (Object)msg);
                results.add("status", (Object)status);
            }
        }
        ,
        DELETESTATUS_OP(CollectionParams.CollectionAction.DELETESTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                CoreContainer coreContainer = h.coreContainer;
                String requestId = req.getParams().get("requestid");
                ZkController zkController = coreContainer.getZkController();
                Boolean flush = req.getParams().getBool("flush", false);
                if (requestId == null && !flush.booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either requestid or flush parameter must be specified.");
                }
                if (requestId != null && flush.booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both requestid and flush parameters can not be specified together.");
                }
                if (flush.booleanValue()) {
                    zkController.getOverseerCompletedMap().clear();
                    zkController.getOverseerFailureMap().clear();
                    rsp.getValues().add("status", (Object)"successfully cleared stored collection api responses");
                    return null;
                }
                if (zkController.getOverseerCompletedMap().remove(requestId)) {
                    rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                } else if (zkController.getOverseerFailureMap().remove(requestId)) {
                    rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                } else {
                    rsp.getValues().add("status", (Object)("[" + requestId + "] not found in stored responses"));
                }
                return null;
            }
        }
        ,
        ADDREPLICA_OP(CollectionParams.CollectionAction.ADDREPLICA){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map props = req.getParams().getAll(null, new String[]{"collection", "node", "shard", "_route_", "name", "instanceDir", "dataDir"});
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
            }
        }
        ,
        OVERSEERSTATUS_OP(CollectionParams.CollectionAction.OVERSEERSTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                return new LinkedHashMap<String, Object>();
            }
        }
        ,
        LIST_OP(CollectionParams.CollectionAction.LIST){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                NamedList results = new NamedList();
                Set collections = handler.coreContainer.getZkController().getZkStateReader().getClusterState().getCollections();
                ArrayList<String> collectionList = new ArrayList<String>();
                for (String collection : collections) {
                    collectionList.add(collection);
                }
                results.add("collections", collectionList);
                OverseerSolrResponse response = new OverseerSolrResponse(results);
                rsp.getValues().addAll(response.getResponse());
                return null;
            }
        }
        ,
        CLUSTERSTATUS_OP(CollectionParams.CollectionAction.CLUSTERSTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws KeeperException, InterruptedException {
                Map all = req.getParams().getAll(null, new String[]{"collection", "shard", "_route_"});
                new ClusterStatus(handler.coreContainer.getZkController().getZkStateReader(), new ZkNodeProps(all)).getClusterStatus(rsp.getValues());
                return null;
            }
        }
        ,
        ADDREPLICAPROP_OP(CollectionParams.CollectionAction.ADDREPLICAPROP){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "property", "shard", "replica", "property.value"});
                req.getParams().getAll(map, new String[]{"shardUnique"});
                String property = (String)map.get("property");
                if (!property.startsWith("property.")) {
                    property = "property." + property;
                }
                boolean uniquePerSlice = Boolean.parseBoolean((String)map.get("shardUnique"));
                if (StringUtils.isNotBlank((String)((String)map.get("shardUnique"))) && SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(property.toLowerCase(Locale.ROOT)) && !uniquePerSlice) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer replica property command received for property " + property + " with the " + "shardUnique" + " parameter set to something other than 'true'. No action taken.");
                }
                return map;
            }
        }
        ,
        DELETEREPLICAPROP_OP(CollectionParams.CollectionAction.DELETEREPLICAPROP){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "property", "shard", "replica"});
                return req.getParams().getAll(map, new String[]{"property"});
            }
        }
        ,
        BALANCESHARDUNIQUE_OP(CollectionParams.CollectionAction.BALANCESHARDUNIQUE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "property"});
                Boolean shardUnique = Boolean.parseBoolean(req.getParams().get("shardUnique"));
                String prop = req.getParams().get("property").toLowerCase(Locale.ROOT);
                if (!StringUtils.startsWith((String)prop, (String)"property.")) {
                    prop = "property." + prop;
                }
                if (!shardUnique.booleanValue() && !SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(prop)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Balancing properties amongst replicas in a slice requires that the property be pre-defined as a unique property (e.g. 'preferredLeader') or that 'shardUnique' be set to 'true'.  Property: " + prop + " shardUnique: " + Boolean.toString(shardUnique));
                }
                return req.getParams().getAll(map, new String[]{"onlyactivenodes", "shardUnique"});
            }
        }
        ,
        REBALANCELEADERS_OP(CollectionParams.CollectionAction.REBALANCELEADERS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                new RebalanceLeaders(req, rsp, h).execute();
                return null;
            }
        }
        ,
        MODIFYCOLLECTION_OP(CollectionParams.CollectionAction.MODIFYCOLLECTION, DEFAULT_ZK_TIMEOUT, false){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map m = req.getParams().getAll(null, MODIFIABLE_COLL_PROPS.toArray(new String[0]));
                if (m.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.formatString((String)"no supported values provided rule, snitch, masShardsPerNode, replicationFactor", (Object[])new Object[0]));
                }
                req.getParams().required().getAll(m, new String[]{"collection"});
                CollectionsHandler.addMapObject(m, "rule");
                CollectionsHandler.addMapObject(m, "snitch");
                for (String prop : MODIFIABLE_COLL_PROPS) {
                    DocCollection.verifyProp((Map)m, (String)prop);
                }
                CollectionsHandler.verifyRuleParams(h.coreContainer, m);
                return m;
            }
        }
        ,
        MIGRATESTATEFORMAT_OP(CollectionParams.CollectionAction.MIGRATESTATEFORMAT){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"collection"});
            }
        };

        CollectionParams.CollectionAction action;
        long timeOut;
        boolean sendToOCPQueue;

        private CollectionOperation(CollectionParams.CollectionAction action) {
            this(action, DEFAULT_ZK_TIMEOUT, true);
        }

        private CollectionOperation(CollectionParams.CollectionAction action, long timeOut, boolean sendToOCPQueue) {
            this.action = action;
            this.timeOut = timeOut;
            this.sendToOCPQueue = sendToOCPQueue;
        }

        abstract Map<String, Object> call(SolrQueryRequest var1, SolrQueryResponse var2, CollectionsHandler var3) throws Exception;

        public static CollectionOperation get(CollectionParams.CollectionAction action) {
            for (CollectionOperation op : CollectionOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action" + action);
        }
    }
}

