/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.core.DirectoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardDirectoryFactory
extends CachingDirectoryFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected Directory create(String path, LockFactory lockFactory, DirectoryFactory.DirContext dirContext) throws IOException {
        return FSDirectory.open((Path)new File(path).toPath(), (LockFactory)lockFactory);
    }

    @Override
    protected LockFactory createLockFactory(String rawLockType) throws IOException {
        String lockType;
        if (null == rawLockType) {
            rawLockType = "native";
            log.warn("No lockType configured, assuming '" + rawLockType + "'.");
        }
        switch (lockType = rawLockType.toLowerCase(Locale.ROOT).trim()) {
            case "simple": {
                return SimpleFSLockFactory.INSTANCE;
            }
            case "native": {
                return NativeFSLockFactory.INSTANCE;
            }
            case "single": {
                return new SingleInstanceLockFactory();
            }
            case "none": {
                return NoLockFactory.INSTANCE;
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized lockType: " + rawLockType);
    }

    @Override
    public String normalize(String path) throws IOException {
        String cpath = new File(path).getCanonicalPath();
        return super.normalize(cpath);
    }

    @Override
    public boolean exists(String path) throws IOException {
        File dirFile = new File(path);
        return dirFile.canRead() && dirFile.list().length > 0;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    @Override
    protected void removeDirectory(CachingDirectoryFactory.CacheValue cacheValue) throws IOException {
        File dirFile = new File(cacheValue.path);
        FileUtils.deleteDirectory((File)dirFile);
    }

    @Override
    public void move(Directory fromDir, Directory toDir, String fileName, IOContext ioContext) throws IOException {
        File dir2;
        File indexFileInIndex;
        File dir1;
        File indexFileInTmpDir;
        boolean success;
        Directory baseFromDir = this.getBaseDir(fromDir);
        Directory baseToDir = this.getBaseDir(toDir);
        if (baseFromDir instanceof FSDirectory && baseToDir instanceof FSDirectory && (success = (indexFileInTmpDir = new File(dir1 = ((FSDirectory)baseFromDir).getDirectory().toFile(), fileName)).renameTo(indexFileInIndex = new File(dir2 = ((FSDirectory)baseToDir).getDirectory().toFile(), fileName)))) {
            return;
        }
        super.move(fromDir, toDir, fileName, ioContext);
    }

    private Directory getBaseDir(Directory dir) {
        Directory baseDir = dir instanceof NRTCachingDirectory ? ((NRTCachingDirectory)dir).getDelegate() : dir;
        return baseDir;
    }
}

