/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.IndexReaderFactory;
import org.apache.solr.core.JmxMonitoredMap;
import org.apache.solr.core.MemClassLoader;
import org.apache.solr.core.NRTCachingDirectoryFactory;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrDeletionPolicy;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.StandardIndexReaderFactory;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.ShowFileRequestHandler;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.CSVResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.PHPResponseWriter;
import org.apache.solr.response.PHPSerializedResponseWriter;
import org.apache.solr.response.PythonResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.RawResponseWriter;
import org.apache.solr.response.RubyResponseWriter;
import org.apache.solr.response.SchemaXmlResponseWriter;
import org.apache.solr.response.SmileResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.SortingResponseWriter;
import org.apache.solr.response.XMLResponseWriter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.rest.ManagedResourceStorage;
import org.apache.solr.rest.RestManager;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrFieldCacheMBean;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.stats.LocalStatsCache;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.update.DefaultSolrCoreState;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.RunUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.PropertiesInputStream;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SolrCore
implements SolrInfoMBean,
Closeable {
    public static final String version = "1.0";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Logger requestLog = LoggerFactory.getLogger((String)(MethodHandles.lookup().lookupClass().getName() + ".Request"));
    private String name;
    private String logid;
    private CoreDescriptor coreDescriptor;
    private boolean isReloaded = false;
    private StatsCache statsCache;
    private final SolrConfig solrConfig;
    private final SolrResourceLoader resourceLoader;
    private volatile IndexSchema schema;
    private final NamedList configSetProperties;
    private final String dataDir;
    private final String ulogDir;
    private final UpdateHandler updateHandler;
    private final SolrCoreState solrCoreState;
    private final Date startTime = new Date();
    private final long startNanoTime = System.nanoTime();
    private final RequestHandlers reqHandlers;
    private final PluginBag<SearchComponent> searchComponents = new PluginBag<SearchComponent>(SearchComponent.class, this);
    private final PluginBag<UpdateRequestProcessorFactory> updateProcessors = new PluginBag<UpdateRequestProcessorFactory>(UpdateRequestProcessorFactory.class, this);
    private final Map<String, UpdateRequestProcessorChain> updateProcessorChains;
    private final Map<String, SolrInfoMBean> infoRegistry;
    private final IndexDeletionPolicyWrapper solrDelPolicy;
    private final DirectoryFactory directoryFactory;
    private IndexReaderFactory indexReaderFactory;
    private final Codec codec;
    private final MemClassLoader memClassLoader;
    private final List<Runnable> confListeners = new CopyOnWriteArrayList<Runnable>();
    private final ReentrantLock ruleExpiryLock;
    private final RestManager restManager;
    static int boolean_query_max_clause_count = Integer.MIN_VALUE;
    private String lastNewIndexDir;
    final List<SolrEventListener> firstSearcherListeners = new ArrayList<SolrEventListener>();
    final List<SolrEventListener> newSearcherListeners = new ArrayList<SolrEventListener>();
    private static Set<String> dirs = new HashSet<String>();
    private final AtomicInteger refCount = new AtomicInteger(1);
    private Collection<CloseHook> closeHooks = null;
    public static boolean VERBOSE = Boolean.parseBoolean(System.getProperty("tests.verbose", "false"));
    private RefCounted<SolrIndexSearcher> _searcher;
    private final LinkedList<RefCounted<SolrIndexSearcher>> _searchers = new LinkedList();
    private final LinkedList<RefCounted<SolrIndexSearcher>> _realtimeSearchers = new LinkedList();
    final ExecutorService searcherExecutor = ExecutorUtil.newMDCAwareSingleThreadExecutor((ThreadFactory)new DefaultSolrThreadFactory("searcherExecutor"));
    private int onDeckSearchers;
    private Object searcherLock = new Object();
    private ReentrantLock openSearcherLock = new ReentrantLock(true);
    private final int maxWarmingSearchers;
    private final int slowQueryThresholdMillis;
    private RefCounted<SolrIndexSearcher> realtimeSearcher;
    private Callable<DirectoryReader> newReaderCreator;
    private final PluginBag<QueryResponseWriter> responseWriters = new PluginBag<QueryResponseWriter>(QueryResponseWriter.class, this);
    public static final Map<String, QueryResponseWriter> DEFAULT_RESPONSE_WRITERS;
    private final PluginBag<QParserPlugin> qParserPlugins = new PluginBag<QParserPlugin>(QParserPlugin.class, this);
    private final PluginBag<ValueSourceParser> valueSourceParsers = new PluginBag<ValueSourceParser>(ValueSourceParser.class, this);
    private final PluginBag<TransformerFactory> transformerFactories = new PluginBag<TransformerFactory>(TransformerFactory.class, this);

    public Date getStartTimeStamp() {
        return this.startTime;
    }

    @Deprecated
    public long getStartTime() {
        return this.startTime.getTime();
    }

    public long getStartNanoTime() {
        return this.startNanoTime;
    }

    public long getUptimeMs() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.startNanoTime, TimeUnit.NANOSECONDS);
    }

    public RestManager getRestManager() {
        return this.restManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void booleanQueryMaxClauseCount() {
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            if (boolean_query_max_clause_count == Integer.MIN_VALUE) {
                boolean_query_max_clause_count = this.solrConfig.booleanQueryMaxClauseCount;
                BooleanQuery.setMaxClauseCount((int)boolean_query_max_clause_count);
            } else if (boolean_query_max_clause_count != this.solrConfig.booleanQueryMaxClauseCount) {
                log.debug("BooleanQuery.maxClauseCount={}, ignoring {}", (Object)boolean_query_max_clause_count, (Object)this.solrConfig.booleanQueryMaxClauseCount);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public SolrResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getConfigResource() {
        return this.solrConfig.getResourceName();
    }

    public SolrConfig getSolrConfig() {
        return this.solrConfig;
    }

    public String getSchemaResource() {
        return this.getLatestSchema().getResourceName();
    }

    public IndexSchema getLatestSchema() {
        return this.schema;
    }

    public void setLatestSchema(IndexSchema replacementSchema) {
        SimilarityFactory similarityFactory = replacementSchema.getSimilarityFactory();
        if (similarityFactory instanceof SolrCoreAware) {
            ((SolrCoreAware)((Object)similarityFactory)).inform(this);
        }
        this.schema = replacementSchema;
    }

    public NamedList getConfigSetProperties() {
        return this.configSetProperties;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getUlogDir() {
        return this.ulogDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIndexDir() {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher == null) {
                return this.getNewIndexDir();
            }
            SolrIndexSearcher searcher = this._searcher.get();
            String string = searcher.getPath() == null ? this.dataDir + "index/" : searcher.getPath();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getNewIndexDir() {
        result = this.dataDir + "index/";
        p = new Properties();
        dir = null;
        try {
            dir = this.getDirectoryFactory().get(this.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.getSolrConfig().indexConfig.lockType);
            try {
                input = dir.openInput("index.properties", IOContext.DEFAULT);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                input = null;
            }
            if (input != null) {
                is = new PropertiesInputStream(input);
                try {
                    p.load(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
                    s = p.getProperty("index");
                    if (s != null && s.trim().length() > 0) {
                        result = this.dataDir + s;
                    }
                }
                catch (Exception e) {
                    SolrCore.log.error("Unable to load index.properties", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)is);
                }
            }
            ** if (dir == null) goto lbl-1000
        }
        catch (IOException e) {
            try {
                SolrException.log((Logger)SolrCore.log, (String)"", (Throwable)e);
                ** if (dir == null) goto lbl-1000
            }
            catch (Throwable var8_13) {
                if (dir != null) {
                    try {
                        this.getDirectoryFactory().release(dir);
                    }
                    catch (IOException e) {
                        SolrException.log((Logger)SolrCore.log, (String)"", (Throwable)e);
                    }
                }
                throw var8_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.getDirectoryFactory().release(dir);
                }
                catch (IOException e) {
                    SolrException.log((Logger)SolrCore.log, (String)"", (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.getDirectoryFactory().release(dir);
            }
            catch (IOException e) {
                SolrException.log((Logger)SolrCore.log, (String)"", (Throwable)e);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (!result.equals(this.lastNewIndexDir)) {
            SolrCore.log.info("New index directory detected: old=" + this.lastNewIndexDir + " new=" + result);
        }
        this.lastNewIndexDir = result;
        return result;
    }

    public DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    public IndexReaderFactory getIndexReaderFactory() {
        return this.indexReaderFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
        this.logid = v == null ? "" : "[" + v + "] ";
        this.coreDescriptor = new CoreDescriptor(v, this.coreDescriptor);
    }

    public String getLogId() {
        return this.logid;
    }

    public Map<String, SolrInfoMBean> getInfoRegistry() {
        return this.infoRegistry;
    }

    private IndexDeletionPolicyWrapper initDeletionPolicy(IndexDeletionPolicyWrapper delPolicyWrapper) {
        SolrDeletionPolicy delPolicy;
        if (delPolicyWrapper != null) {
            return delPolicyWrapper;
        }
        PluginInfo info = this.solrConfig.getPluginInfo(IndexDeletionPolicy.class.getName());
        if (info != null) {
            delPolicy = SolrCore.createInstance(info.className, IndexDeletionPolicy.class, "Deletion Policy for SOLR", this, this.getResourceLoader());
            if (delPolicy instanceof NamedListInitializedPlugin) {
                ((NamedListInitializedPlugin)delPolicy).init(info.initArgs);
            }
        } else {
            delPolicy = new SolrDeletionPolicy();
        }
        return new IndexDeletionPolicyWrapper(delPolicy);
    }

    private void initListeners() {
        Class<SolrEventListener> clazz = SolrEventListener.class;
        String label = "Event Listener";
        for (PluginInfo info : this.solrConfig.getPluginInfos(SolrEventListener.class.getName())) {
            SolrEventListener obj;
            String event = info.attributes.get("event");
            if ("firstSearcher".equals(event)) {
                obj = this.createInitInstance(info, clazz, "Event Listener", null);
                this.firstSearcherListeners.add(obj);
                log.info("[{}] Added SolrEventListener for firstSearcher: [{}]", (Object)this.logid, (Object)obj);
                continue;
            }
            if (!"newSearcher".equals(event)) continue;
            obj = this.createInitInstance(info, clazz, "Event Listener", null);
            this.newSearcherListeners.add(obj);
            log.info("[{}] Added SolrEventListener for newSearcher: [{}]", (Object)this.logid, (Object)obj);
        }
    }

    public void registerFirstSearcherListener(SolrEventListener listener) {
        this.firstSearcherListeners.add(listener);
    }

    public void registerNewSearcherListener(SolrEventListener listener) {
        this.newSearcherListeners.add(listener);
    }

    public QueryResponseWriter registerResponseWriter(String name, QueryResponseWriter responseWriter) {
        return this.responseWriters.put(name, responseWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore reload(ConfigSet coreConfig) throws IOException {
        SolrCore solrCore;
        block3: {
            this.solrCoreState.increfSolrCoreState();
            SolrCore currentCore = !this.getNewIndexDir().equals(this.getIndexDir()) ? null : this;
            boolean success = false;
            SolrCore core = null;
            try {
                core = new SolrCore(this.getName(), this.getDataDir(), coreConfig.getSolrConfig(), coreConfig.getIndexSchema(), coreConfig.getProperties(), this.coreDescriptor, this.updateHandler, this.solrDelPolicy, currentCore);
                core.getUpdateHandler().getSolrCoreState().newIndexWriter(core, false);
                core.getSearcher(true, false, null, true);
                success = true;
                solrCore = core;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeQuietly(core);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)core);
        }
        return solrCore;
    }

    private DirectoryFactory initDirectoryFactory() {
        DirectoryFactory dirFactory;
        PluginInfo info = this.solrConfig.getPluginInfo(DirectoryFactory.class.getName());
        if (info != null) {
            log.info(info.className);
            dirFactory = this.getResourceLoader().newInstance(info.className, DirectoryFactory.class);
            dirFactory.init(info.initArgs);
        } else {
            log.info("solr.NRTCachingDirectoryFactory");
            dirFactory = new NRTCachingDirectoryFactory();
        }
        return dirFactory;
    }

    private void initIndexReaderFactory() {
        IndexReaderFactory indexReaderFactory;
        PluginInfo info = this.solrConfig.getPluginInfo(IndexReaderFactory.class.getName());
        if (info != null) {
            indexReaderFactory = this.resourceLoader.newInstance(info.className, IndexReaderFactory.class);
            indexReaderFactory.init(info.initArgs);
        } else {
            indexReaderFactory = new StandardIndexReaderFactory();
        }
        this.indexReaderFactory = indexReaderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initIndex(boolean reload) throws IOException {
        String indexDir = this.getNewIndexDir();
        boolean indexExists = this.getDirectoryFactory().exists(indexDir);
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            boolean firstTime = dirs.add(this.getDirectoryFactory().normalize(indexDir));
            // ** MonitorExit[var5_4] (shouldn't be in output)
            this.initIndexReaderFactory();
            if (indexExists && firstTime && !reload) {
                String lockType = this.getSolrConfig().indexConfig.lockType;
                Directory dir = this.directoryFactory.get(indexDir, DirectoryFactory.DirContext.DEFAULT, lockType);
                try {
                    if (IndexWriter.isLocked((Directory)dir)) {
                        log.error(this.logid + "Solr index directory '{}' is locked (lockType={}).  Throwing exception.", (Object)indexDir, (Object)lockType);
                        throw new LockObtainFailedException("Index dir '" + indexDir + "' of core '" + this.name + "' is already locked. " + "The most likely cause is another Solr server (or another solr core in this server) " + "also configured to use this directory; other possible causes may be specific to lockType: " + lockType);
                    }
                }
                finally {
                    this.directoryFactory.release(dir);
                }
            }
            if (!indexExists) {
                log.warn(this.logid + "Solr index directory '" + new File(indexDir) + "' doesn't exist." + " Creating new index...");
                SolrIndexWriter writer = SolrIndexWriter.create(this, "SolrCore.initIndex", indexDir, this.getDirectoryFactory(), true, this.getLatestSchema(), this.solrConfig.indexConfig, this.solrDelPolicy, this.codec);
                writer.close();
            }
            this.cleanupOldIndexDirectories();
            return;
        }
    }

    public static <T> T createInstance(String className, Class<T> cast, String msg, SolrCore core, ResourceLoader resourceLoader) {
        Class clazz = null;
        if (msg == null) {
            msg = "SolrCore Object";
        }
        try {
            Constructor<?>[] cons;
            clazz = resourceLoader.findClass(className, cast);
            for (Constructor<?> con : cons = clazz.getConstructors()) {
                Class<?>[] types = con.getParameterTypes();
                if (types.length != 1 || types[0] != SolrCore.class) continue;
                return cast.cast(con.newInstance(core));
            }
            return (T)resourceLoader.newInstance(className, cast);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            if (null != e.getCause() && e.getCause() instanceof SolrException) {
                SolrException inner = (SolrException)e.getCause();
                throw inner;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " failed to instantiate " + cast.getName(), (Throwable)e);
        }
    }

    private UpdateHandler createReloadedUpdateHandler(String className, String msg, UpdateHandler updateHandler) {
        Class<UpdateHandler> clazz = null;
        if (msg == null) {
            msg = "SolrCore Object";
        }
        try {
            Constructor<?>[] cons;
            clazz = this.getResourceLoader().findClass(className, UpdateHandler.class);
            for (Constructor<?> con : cons = clazz.getConstructors()) {
                Class<?>[] types = con.getParameterTypes();
                if (types.length != 2 || types[0] != SolrCore.class || types[1] != UpdateHandler.class) continue;
                return (UpdateHandler)UpdateHandler.class.cast(con.newInstance(this, updateHandler));
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " could not find proper constructor for " + UpdateHandler.class.getName());
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            if (null != e.getCause() && e.getCause() instanceof SolrException) {
                SolrException inner = (SolrException)e.getCause();
                throw inner;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " failed to instantiate " + UpdateHandler.class.getName(), (Throwable)e);
        }
    }

    public <T> T createInitInstance(PluginInfo info, Class<T> cast, String msg, String defClassName) {
        if (info == null) {
            return null;
        }
        T o = SolrCore.createInstance(info.className == null ? defClassName : info.className, cast, msg, this, this.getResourceLoader());
        if (o instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)o).init(info);
        } else if (o instanceof NamedListInitializedPlugin) {
            ((NamedListInitializedPlugin)o).init(info.initArgs);
        }
        if (o instanceof SearchComponent) {
            ((SearchComponent)o).setName(info.name);
        }
        return o;
    }

    private UpdateHandler createUpdateHandler(String className) {
        return SolrCore.createInstance(className, UpdateHandler.class, "Update Handler", this, this.getResourceLoader());
    }

    private UpdateHandler createUpdateHandler(String className, UpdateHandler updateHandler) {
        return this.createReloadedUpdateHandler(className, "Update Handler", updateHandler);
    }

    public SolrCore(String name, String dataDir, SolrConfig config, IndexSchema schema, CoreDescriptor cd) {
        this(name, dataDir, config, schema, null, cd, null, null, null);
    }

    public SolrCore(CoreDescriptor cd, ConfigSet coreConfig) {
        this(cd.getName(), null, coreConfig.getSolrConfig(), coreConfig.getIndexSchema(), coreConfig.getProperties(), cd, null, null, null);
    }

    public SolrCore(String name, CoreDescriptor coreDescriptor) {
        this.coreDescriptor = coreDescriptor;
        this.setName(name);
        this.schema = null;
        this.dataDir = null;
        this.ulogDir = null;
        this.solrConfig = null;
        this.configSetProperties = null;
        this.maxWarmingSearchers = 2;
        this.slowQueryThresholdMillis = -1;
        this.resourceLoader = null;
        this.updateHandler = null;
        this.isReloaded = true;
        this.reqHandlers = null;
        this.updateProcessorChains = null;
        this.infoRegistry = null;
        this.codec = null;
        this.ruleExpiryLock = null;
        this.memClassLoader = null;
        this.directoryFactory = null;
        this.solrCoreState = null;
        this.restManager = null;
        this.solrDelPolicy = null;
    }

    public SolrCore(String name, String dataDir, SolrConfig config, IndexSchema schema, NamedList configSetProperties, CoreDescriptor coreDescriptor, UpdateHandler updateHandler, IndexDeletionPolicyWrapper delPolicy, SolrCore prev) {
        assert (ObjectReleaseTracker.track((Object)this.searcherExecutor));
        Preconditions.checkNotNull((Object)coreDescriptor, (Object)"coreDescriptor cannot be null");
        this.coreDescriptor = coreDescriptor;
        this.setName(name);
        MDCLoggingContext.setCore(this);
        this.resourceLoader = config.getResourceLoader();
        this.solrConfig = config;
        this.configSetProperties = configSetProperties;
        if (updateHandler == null) {
            this.directoryFactory = this.initDirectoryFactory();
            this.solrCoreState = new DefaultSolrCoreState(this.directoryFactory);
        } else {
            this.solrCoreState = updateHandler.getSolrCoreState();
            this.directoryFactory = this.solrCoreState.getDirectoryFactory();
            this.isReloaded = true;
        }
        this.dataDir = this.initDataDir(dataDir, config, coreDescriptor);
        this.ulogDir = this.initUpdateLogDir(coreDescriptor);
        log.info("[{}] Opening new SolrCore at [{}], dataDir=[{}]", new Object[]{this.logid, this.resourceLoader.getInstancePath(), this.dataDir});
        this.checkVersionFieldExistsInSchema(schema, coreDescriptor);
        this.infoRegistry = this.initInfoRegistry(name, config);
        this.infoRegistry.put("fieldCache", new SolrFieldCacheMBean());
        this.initSchema(config, schema);
        this.maxWarmingSearchers = config.maxWarmingSearchers;
        this.slowQueryThresholdMillis = config.slowQueryThresholdMillis;
        this.booleanQueryMaxClauseCount();
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            this.initListeners();
            this.solrDelPolicy = this.initDeletionPolicy(delPolicy);
            this.codec = this.initCodec(this.solrConfig, this.schema);
            this.memClassLoader = new MemClassLoader(PluginBag.RuntimeLib.getLibObjects(this, this.solrConfig.getPluginInfos(PluginBag.RuntimeLib.class.getName())), this.getResourceLoader());
            this.initIndex(prev != null);
            this.initWriters();
            this.qParserPlugins.init(this.createInstances(QParserPlugin.standardPlugins), this);
            this.valueSourceParsers.init(ValueSourceParser.standardValueSourceParsers, this);
            this.transformerFactories.init(TransformerFactory.defaultFactories, this);
            this.loadSearchComponents();
            this.updateProcessors.init(Collections.emptyMap(), this);
            this.updateProcessorChains = this.loadUpdateProcessorChains();
            this.reqHandlers = new RequestHandlers(this);
            this.reqHandlers.initHandlersFromConfig(this.solrConfig);
            this.initDeprecatedSupport();
            this.statsCache = this.initStatsCache();
            this.searcherExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    latch.await();
                    return null;
                }
            });
            this.updateHandler = this.initUpdateHandler(updateHandler);
            this.initSearcher(prev);
            this.restManager = this.initRestManager();
            this.resourceLoader.inform(this.resourceLoader);
            this.resourceLoader.inform(this);
        }
        catch (Throwable e) {
            latch.countDown();
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            try {
                this.close();
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)t;
                }
                log.error("Error while closing", t);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage(), e);
        }
        finally {
            latch.countDown();
        }
        this.infoRegistry.put("core", this);
        this.resourceLoader.inform(this.infoRegistry);
        for (SolrInfoMBean bean : this.directoryFactory.offerMBeans()) {
            log.debug("Registering JMX bean [{}] from directory factory.", (Object)bean.getName());
            if (this.infoRegistry.containsKey(bean.getName())) {
                log.info("Ignoring JMX bean [{}] due to name conflict.", (Object)bean.getName());
                continue;
            }
            this.infoRegistry.put(bean.getName(), bean);
        }
        this.seedVersionBuckets();
        this.bufferUpdatesIfConstructing(coreDescriptor);
        this.ruleExpiryLock = new ReentrantLock();
        this.registerConfListener();
        assert (ObjectReleaseTracker.track((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedVersionBuckets() {
        UpdateHandler uh = this.getUpdateHandler();
        if (uh != null && uh.getUpdateLog() != null) {
            RefCounted<SolrIndexSearcher> newestSearcher = this.getRealtimeSearcher();
            if (newestSearcher != null) {
                try {
                    uh.getUpdateLog().seedBucketsWithHighestVersion(newestSearcher.get());
                }
                finally {
                    newestSearcher.decref();
                }
            } else {
                log.warn("No searcher available! Cannot seed version buckets with max from index.");
            }
        }
    }

    private void bufferUpdatesIfConstructing(CoreDescriptor coreDescriptor) {
        CoreContainer cc = coreDescriptor.getCoreContainer();
        if (cc != null && cc.isZooKeeperAware()) {
            ClusterState clusterState;
            Slice slice;
            if (this.reqHandlers.get("/get") == null) {
                log.warn("WARNING: RealTimeGetHandler is not registered at /get. SolrCloud will always use full index replication instead of the more efficient PeerSync method.");
            }
            if ((slice = (clusterState = cc.getZkController().getClusterState()).getSlice(coreDescriptor.getCloudDescriptor().getCollectionName(), coreDescriptor.getCloudDescriptor().getShardId())).getState() == Slice.State.CONSTRUCTION) {
                this.getUpdateHandler().getUpdateLog().bufferUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSearcher(SolrCore prev) throws IOException {
        RefCounted<IndexWriter> iwRef = null;
        if (prev != null && (iwRef = prev.getUpdateHandler().getSolrCoreState().getIndexWriter(null)) != null) {
            final IndexWriter iw = iwRef.get();
            final SolrCore core = this;
            this.newReaderCreator = new Callable<DirectoryReader>(){

                @Override
                public DirectoryReader call() throws Exception {
                    return SolrCore.this.indexReaderFactory.newReader(iw, core);
                }
            };
        }
        try {
            this.getSearcher(false, false, null, true);
        }
        finally {
            this.newReaderCreator = null;
            if (iwRef != null) {
                iwRef.decref();
            }
        }
    }

    private UpdateHandler initUpdateHandler(UpdateHandler updateHandler) {
        String updateHandlerClass = this.solrConfig.getUpdateHandlerInfo().className;
        if (updateHandlerClass == null) {
            updateHandlerClass = DirectUpdateHandler2.class.getName();
        }
        UpdateHandler newUpdateHandler = updateHandler == null ? this.createUpdateHandler(updateHandlerClass) : this.createUpdateHandler(updateHandlerClass, updateHandler);
        this.infoRegistry.put("updateHandler", newUpdateHandler);
        return newUpdateHandler;
    }

    private void initSchema(SolrConfig config, IndexSchema schema) {
        if (schema == null) {
            schema = IndexSchemaFactory.buildIndexSchema("schema.xml", config);
        }
        this.setLatestSchema(schema);
    }

    private Map<String, SolrInfoMBean> initInfoRegistry(String name, SolrConfig config) {
        if (config.jmxConfig.enabled) {
            return new JmxMonitoredMap(name, String.valueOf(this.hashCode()), config.jmxConfig);
        }
        log.info("JMX monitoring not detected for core: " + name);
        return new ConcurrentHashMap<String, SolrInfoMBean>();
    }

    private void checkVersionFieldExistsInSchema(IndexSchema schema, CoreDescriptor coreDescriptor) {
        if (null != coreDescriptor.getCloudDescriptor()) {
            try {
                VersionInfo.getAndCheckVersionField(schema);
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Schema will not work with SolrCloud mode: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private String initDataDir(String dataDir, SolrConfig config, CoreDescriptor coreDescriptor) {
        if (dataDir == null) {
            if (coreDescriptor.usingDefaultDataDir()) {
                dataDir = config.getDataDir();
            }
            if (dataDir == null) {
                try {
                    dataDir = coreDescriptor.getDataDir();
                    if (!this.directoryFactory.isAbsolute(dataDir)) {
                        dataDir = this.directoryFactory.getDataHome(coreDescriptor);
                    }
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
        }
        return SolrResourceLoader.normalizeDir(dataDir);
    }

    private String initUpdateLogDir(CoreDescriptor coreDescriptor) {
        String updateLogDir = coreDescriptor.getUlogDir();
        if (updateLogDir == null) {
            updateLogDir = coreDescriptor.getInstanceDir().resolve(this.dataDir).normalize().toAbsolutePath().toString();
        }
        return updateLogDir;
    }

    public void closeAndWait() {
        this.close();
        while (!this.isClosed()) {
            long milliSleep = 100L;
            log.info("Core {} is not yet closed, waiting {} ms before checking again.", (Object)this.getName(), (Object)100L);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Caught InterruptedException whilst waiting for core " + this.getName() + " to close: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private Codec initCodec(SolrConfig solrConfig, IndexSchema schema) {
        CodecFactory factory;
        PluginInfo info = solrConfig.getPluginInfo(CodecFactory.class.getName());
        if (info != null) {
            factory = schema.getResourceLoader().newInstance(info.className, CodecFactory.class);
            factory.init(info.initArgs);
        } else {
            factory = new CodecFactory(){

                @Override
                public Codec getCodec() {
                    return Codec.getDefault();
                }
            };
        }
        if (factory instanceof SolrCoreAware) {
            ((SolrCoreAware)((Object)factory)).inform(this);
        } else {
            for (FieldType ft : schema.getFieldTypes().values()) {
                if (null != ft.getPostingsFormat()) {
                    String msg = "FieldType '" + ft.getTypeName() + "' is configured with a postings format, but the codec does not support it: " + factory.getClass();
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                if (null == ft.getDocValuesFormat()) continue;
                String msg = "FieldType '" + ft.getTypeName() + "' is configured with a docValues format, but the codec does not support it: " + factory.getClass();
                log.error(msg);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
        }
        return factory.getCodec();
    }

    private StatsCache initStatsCache() {
        StatsCache cache;
        PluginInfo pluginInfo = this.solrConfig.getPluginInfo(StatsCache.class.getName());
        if (pluginInfo != null && pluginInfo.className != null && pluginInfo.className.length() > 0) {
            cache = this.createInitInstance(pluginInfo, StatsCache.class, null, LocalStatsCache.class.getName());
            log.info("Using statsCache impl: " + cache.getClass().getName());
        } else {
            log.info("Using default statsCache cache: " + LocalStatsCache.class.getName());
            cache = new LocalStatsCache();
        }
        return cache;
    }

    public StatsCache getStatsCache() {
        return this.statsCache;
    }

    private Map<String, UpdateRequestProcessorChain> loadUpdateProcessorChains() {
        HashMap<String, UpdateRequestProcessorChain> map = new HashMap<String, UpdateRequestProcessorChain>();
        UpdateRequestProcessorChain def = this.initPlugins(map, UpdateRequestProcessorChain.class, UpdateRequestProcessorChain.class.getName());
        if (def == null) {
            def = (UpdateRequestProcessorChain)map.get(null);
        }
        if (def == null) {
            log.info("no updateRequestProcessorChain defined as default, creating implicit default");
            UpdateRequestProcessorFactory[] factories = new UpdateRequestProcessorFactory[]{new LogUpdateProcessorFactory(), new DistributedUpdateProcessorFactory(), new RunUpdateProcessorFactory()};
            def = new UpdateRequestProcessorChain(Arrays.asList(factories), this);
        }
        map.put(null, def);
        map.put("", def);
        return map;
    }

    public SolrCoreState getSolrCoreState() {
        return this.solrCoreState;
    }

    public UpdateRequestProcessorChain getUpdateProcessingChain(String name) {
        UpdateRequestProcessorChain chain = this.updateProcessorChains.get(name);
        if (chain == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown UpdateRequestProcessorChain: " + name);
        }
        return chain;
    }

    public UpdateRequestProcessorChain getUpdateProcessorChain(SolrParams params) {
        String chainName = params.get("update.chain");
        UpdateRequestProcessorChain defaultUrp = this.getUpdateProcessingChain(chainName);
        UpdateRequestProcessorChain.ProcessorInfo processorInfo = new UpdateRequestProcessorChain.ProcessorInfo(params);
        if (processorInfo.isEmpty()) {
            return defaultUrp;
        }
        return UpdateRequestProcessorChain.constructChain(defaultUrp, processorInfo, this);
    }

    public PluginBag<UpdateRequestProcessorFactory> getUpdateProcessors() {
        return this.updateProcessors;
    }

    public void open() {
        this.refCount.incrementAndGet();
    }

    @Override
    public void close() {
        block37: {
            boolean coreStateClosed;
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                int count = this.refCount.decrementAndGet();
                                if (count > 0) {
                                    return;
                                }
                                if (count < 0) {
                                    log.error("Too many close [count:{}] on {}. Please report this exception to solr-user@lucene.apache.org", (Object)count, (Object)this);
                                    assert (false) : "Too many closes on SolrCore";
                                    return;
                                }
                                log.info(this.logid + " CLOSING SolrCore " + this);
                                if (this.closeHooks != null) {
                                    for (CloseHook hook : this.closeHooks) {
                                        try {
                                            hook.preClose(this);
                                        }
                                        catch (Throwable e) {
                                            SolrException.log((Logger)log, (Throwable)e);
                                            if (!(e instanceof Error)) continue;
                                            throw (Error)e;
                                        }
                                    }
                                }
                                if (this.reqHandlers != null) {
                                    this.reqHandlers.close();
                                }
                                this.responseWriters.close();
                                this.searchComponents.close();
                                this.qParserPlugins.close();
                                this.valueSourceParsers.close();
                                this.transformerFactories.close();
                                if (this.memClassLoader != null) {
                                    try {
                                        this.memClassLoader.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    if (null != this.updateHandler) {
                                        this.updateHandler.close();
                                    }
                                }
                                catch (Throwable e) {
                                    SolrException.log((Logger)log, (Throwable)e);
                                    if (!(e instanceof Error)) break block32;
                                    throw (Error)e;
                                }
                            }
                            coreStateClosed = false;
                            try {
                                if (this.solrCoreState != null) {
                                    coreStateClosed = this.updateHandler instanceof SolrCoreState.IndexWriterCloser ? this.solrCoreState.decrefSolrCoreState((SolrCoreState.IndexWriterCloser)((Object)this.updateHandler)) : this.solrCoreState.decrefSolrCoreState(null);
                                }
                            }
                            catch (Throwable e) {
                                SolrException.log((Logger)log, (Throwable)e);
                                if (!(e instanceof Error)) break block33;
                                throw (Error)e;
                            }
                        }
                        try {
                            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.searcherExecutor);
                        }
                        catch (Throwable e) {
                            SolrException.log((Logger)log, (Throwable)e);
                            if (!(e instanceof Error)) break block34;
                            throw (Error)e;
                        }
                    }
                    assert (ObjectReleaseTracker.release((Object)this.searcherExecutor));
                    try {
                        this.closeSearcher();
                    }
                    catch (Throwable e) {
                        SolrException.log((Logger)log, (Throwable)e);
                        if (!(e instanceof Error)) break block35;
                        throw (Error)e;
                    }
                }
                try {
                    this.infoRegistry.clear();
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (Throwable)e);
                    if (!(e instanceof Error)) break block36;
                    throw (Error)e;
                }
            }
            if (coreStateClosed) {
                try {
                    this.directoryFactory.close();
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (Throwable)e);
                    if (!(e instanceof Error)) break block37;
                    throw (Error)e;
                }
            }
        }
        if (this.closeHooks != null) {
            for (CloseHook hook : this.closeHooks) {
                try {
                    hook.postClose(this);
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (Throwable)e);
                    if (!(e instanceof Error)) continue;
                    throw (Error)e;
                }
            }
        }
        assert (ObjectReleaseTracker.release((Object)this));
    }

    public int getOpenCount() {
        return this.refCount.get();
    }

    public boolean isClosed() {
        return this.refCount.get() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.getOpenCount() != 0) {
                log.error("REFCOUNT ERROR: unreferenced " + this + " (" + this.getName() + ") has a reference count of " + this.getOpenCount());
            }
        }
        finally {
            super.finalize();
        }
    }

    public void addCloseHook(CloseHook hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new ArrayList<CloseHook>();
        }
        this.closeHooks.add(hook);
    }

    public static void verbose(Object ... args) {
        if (!VERBOSE) {
            return;
        }
        StringBuilder sb = new StringBuilder("VERBOSE:");
        for (Object o : args) {
            sb.append(' ');
            sb.append(o == null ? "(null)" : o.toString());
        }
        log.info(sb.toString());
    }

    public SolrRequestHandler getRequestHandler(String handlerName) {
        return RequestHandlerBase.getRequestHandler(RequestHandlers.normalize(handlerName), this.reqHandlers.handlers);
    }

    public PluginBag<SolrRequestHandler> getRequestHandlers() {
        return this.reqHandlers.handlers;
    }

    public SolrRequestHandler registerRequestHandler(String handlerName, SolrRequestHandler handler) {
        return this.reqHandlers.register(handlerName, handler);
    }

    private void loadSearchComponents() {
        Map instances = this.createInstances(SearchComponent.standard_components);
        for (Map.Entry e : instances.entrySet()) {
            ((SearchComponent)e.getValue()).setName(e.getKey());
        }
        this.searchComponents.init(instances, this);
        for (String name : this.searchComponents.keySet()) {
            if (!this.searchComponents.isLoaded(name) || !(this.searchComponents.get(name) instanceof HighlightComponent)) continue;
            if ("highlight".equals(name)) break;
            this.searchComponents.put("highlight", this.searchComponents.getRegistry().get(name));
            break;
        }
    }

    public SearchComponent getSearchComponent(String name) {
        return this.searchComponents.get(name);
    }

    public PluginBag<SearchComponent> getSearchComponents() {
        return this.searchComponents;
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public RefCounted<SolrIndexSearcher> getSearcher() {
        return this.getSearcher(false, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getRegisteredSearcher() {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null) {
                this._searcher.incref();
            }
            return this._searcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getNewestSearcher(boolean openNew) {
        Object object = this.searcherLock;
        synchronized (object) {
            if (!this._searchers.isEmpty()) {
                RefCounted<SolrIndexSearcher> newest = this._searchers.getLast();
                newest.incref();
                return newest;
            }
        }
        return openNew ? this.getRealtimeSearcher() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefCounted<SolrIndexSearcher> getRealtimeSearcher() {
        RefCounted<SolrIndexSearcher> refCounted = this.searcherLock;
        synchronized (refCounted) {
            if (this.realtimeSearcher != null) {
                this.realtimeSearcher.incref();
                return this.realtimeSearcher;
            }
        }
        this.openSearcherLock.lock();
        try {
            refCounted = this.searcherLock;
            synchronized (refCounted) {
                if (this.realtimeSearcher != null) {
                    this.realtimeSearcher.incref();
                    RefCounted<SolrIndexSearcher> refCounted2 = this.realtimeSearcher;
                    return refCounted2;
                }
            }
            refCounted = this.openNewSearcher(true, true);
            return refCounted;
        }
        finally {
            this.openSearcherLock.unlock();
        }
    }

    public RefCounted<SolrIndexSearcher> getSearcher(boolean forceNew, boolean returnSearcher, Future[] waitSearcher) {
        return this.getSearcher(forceNew, returnSearcher, waitSearcher, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> openNewSearcher(boolean updateHandlerReopens, boolean realtime) {
        if (this.isClosed()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "openNewSearcher called on closed core");
        }
        RefCounted<SolrIndexSearcher> newestSearcher = null;
        this.openSearcherLock.lock();
        try {
            SolrIndexSearcher tmp;
            DirectoryReader newReader;
            String newIndexDir = this.getNewIndexDir();
            String indexDirFile = null;
            String newIndexDirFile = null;
            if (!updateHandlerReopens) {
                indexDirFile = this.getDirectoryFactory().normalize(this.getIndexDir());
                newIndexDirFile = this.getDirectoryFactory().normalize(newIndexDir);
            }
            Object object = this.searcherLock;
            synchronized (object) {
                newestSearcher = this.realtimeSearcher;
                if (newestSearcher != null) {
                    newestSearcher.incref();
                }
            }
            if (newestSearcher != null && (updateHandlerReopens || indexDirFile.equals(newIndexDirFile))) {
                DirectoryReader currentReader = newestSearcher.get().getRawReader();
                RefCounted<IndexWriter> writer = this.getSolrCoreState().getIndexWriter(null);
                try {
                    newReader = writer != null ? DirectoryReader.openIfChanged((DirectoryReader)currentReader, (IndexWriter)writer.get(), (boolean)true) : DirectoryReader.openIfChanged((DirectoryReader)currentReader);
                }
                finally {
                    if (writer != null) {
                        writer.decref();
                    }
                }
                if (newReader == null) {
                    if (realtime) {
                        newestSearcher.incref();
                        RefCounted<SolrIndexSearcher> refCounted = newestSearcher;
                        return refCounted;
                    }
                    if (newestSearcher.get().isCachingEnabled() && newestSearcher.get().getSchema() == this.getLatestSchema()) {
                        newestSearcher.incref();
                        log.info("SolrIndexSearcher has not changed - not re-opening: " + newestSearcher.get().getName());
                        RefCounted<SolrIndexSearcher> refCounted = newestSearcher;
                        return refCounted;
                    }
                    currentReader.incRef();
                    newReader = currentReader;
                }
                boolean useCaches = !realtime;
                String newName = realtime ? "realtime" : "main";
                tmp = new SolrIndexSearcher(this, newIndexDir, this.getLatestSchema(), newName, newReader, true, useCaches, true, this.directoryFactory);
            } else if (this.newReaderCreator != null) {
                newReader = this.newReaderCreator.call();
                tmp = new SolrIndexSearcher(this, newIndexDir, this.getLatestSchema(), realtime ? "realtime" : "main", newReader, true, !realtime, true, this.directoryFactory);
            } else {
                RefCounted<IndexWriter> writer = this.getSolrCoreState().getIndexWriter(this);
                DirectoryReader newReader2 = null;
                try {
                    newReader2 = this.indexReaderFactory.newReader(writer.get(), this);
                }
                finally {
                    writer.decref();
                }
                tmp = new SolrIndexSearcher(this, newIndexDir, this.getLatestSchema(), realtime ? "realtime" : "main", newReader2, true, !realtime, true, this.directoryFactory);
            }
            LinkedList<RefCounted<SolrIndexSearcher>> searcherList = realtime ? this._realtimeSearchers : this._searchers;
            RefCounted<SolrIndexSearcher> newSearcher = this.newHolder(tmp, searcherList);
            newSearcher.incref();
            RefCounted<SolrIndexSearcher> refCounted = this.searcherLock;
            synchronized (refCounted) {
                if (this.realtimeSearcher != null) {
                    this.realtimeSearcher.decref();
                }
                this.realtimeSearcher = newSearcher;
                searcherList.add(this.realtimeSearcher);
            }
            refCounted = newSearcher;
            return refCounted;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error opening new searcher", (Throwable)e);
        }
        finally {
            this.openSearcherLock.unlock();
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getSearcher(boolean forceNew, boolean returnSearcher, Future[] waitSearcher, boolean updateHandlerReopens) {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            if (this.onDeckSearchers > 0 && !forceNew && this._searcher == null) {
                try {
                    this.searcherLock.wait();
                }
                catch (InterruptedException e) {
                    log.info(SolrException.toStr((Throwable)e));
                }
            }
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            ++this.onDeckSearchers;
            if (this.onDeckSearchers < 1) {
                log.error(this.logid + "ERROR!!! onDeckSearchers is " + this.onDeckSearchers);
                this.onDeckSearchers = 1;
            } else {
                if (this.onDeckSearchers > this.maxWarmingSearchers) {
                    --this.onDeckSearchers;
                    String msg = "Error opening new searcher. exceeded limit of maxWarmingSearchers=" + this.maxWarmingSearchers + ", try again later.";
                    log.warn(this.logid + "" + msg);
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, msg);
                }
                if (this.onDeckSearchers > 1) {
                    log.warn(this.logid + "PERFORMANCE WARNING: Overlapping onDeckSearchers=" + this.onDeckSearchers);
                }
            }
        }
        boolean[] decrementOnDeckCount = new boolean[]{true};
        RefCounted<SolrIndexSearcher> currSearcherHolder = null;
        RefCounted<SolrIndexSearcher> searchHolder = null;
        boolean success = false;
        this.openSearcherLock.lock();
        try {
            searchHolder = this.openNewSearcher(updateHandlerReopens, false);
            if (returnSearcher) {
                searchHolder.incref();
            }
            final RefCounted<SolrIndexSearcher> newSearchHolder = searchHolder;
            final SolrIndexSearcher newSearcher = newSearchHolder.get();
            boolean alreadyRegistered = false;
            Object object2 = this.searcherLock;
            synchronized (object2) {
                if (this._searcher == null) {
                    if (this.solrConfig.useColdSearcher) {
                        this.registerSearcher(newSearchHolder);
                        decrementOnDeckCount[0] = false;
                        alreadyRegistered = true;
                    }
                } else {
                    currSearcherHolder = this._searcher;
                    currSearcherHolder.incref();
                }
            }
            final SolrIndexSearcher currSearcher = currSearcherHolder == null ? null : currSearcherHolder.get();
            Future future = null;
            if (newSearcher != currSearcher) {
                if (currSearcher != null) {
                    future = this.searcherExecutor.submit(new Callable(){

                        public Object call() throws Exception {
                            block2: {
                                try {
                                    newSearcher.warm(currSearcher);
                                }
                                catch (Throwable e) {
                                    SolrException.log((Logger)log, (Throwable)e);
                                    if (!(e instanceof Error)) break block2;
                                    throw (Error)e;
                                }
                            }
                            return null;
                        }
                    });
                }
                if (currSearcher == null) {
                    future = this.searcherExecutor.submit(new Callable(){

                        public Object call() throws Exception {
                            block3: {
                                try {
                                    for (SolrEventListener listener : SolrCore.this.firstSearcherListeners) {
                                        listener.newSearcher(newSearcher, null);
                                    }
                                }
                                catch (Throwable e) {
                                    SolrException.log((Logger)log, null, (Throwable)e);
                                    if (!(e instanceof Error)) break block3;
                                    throw (Error)e;
                                }
                            }
                            return null;
                        }
                    });
                }
                if (currSearcher != null) {
                    future = this.searcherExecutor.submit(new Callable(){

                        public Object call() throws Exception {
                            block3: {
                                try {
                                    for (SolrEventListener listener : SolrCore.this.newSearcherListeners) {
                                        listener.newSearcher(newSearcher, currSearcher);
                                    }
                                }
                                catch (Throwable e) {
                                    SolrException.log((Logger)log, null, (Throwable)e);
                                    if (!(e instanceof Error)) break block3;
                                    throw (Error)e;
                                }
                            }
                            return null;
                        }
                    });
                }
            }
            final RefCounted<SolrIndexSearcher> currSearcherHolderF = currSearcherHolder;
            if (!alreadyRegistered) {
                future = this.searcherExecutor.submit(new Callable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call() throws Exception {
                        try {
                            SolrCore.this.registerSearcher(newSearchHolder);
                        }
                        catch (Throwable e) {
                            SolrException.log((Logger)log, (Throwable)e);
                            if (e instanceof Error) {
                                throw (Error)e;
                            }
                        }
                        finally {
                            if (currSearcherHolderF != null) {
                                currSearcherHolderF.decref();
                            }
                        }
                        return null;
                    }
                });
            }
            if (waitSearcher != null) {
                waitSearcher[0] = future;
            }
            success = true;
            RefCounted<SolrIndexSearcher> refCounted = returnSearcher ? newSearchHolder : null;
            return refCounted;
        }
        catch (Exception e) {
            if (e instanceof SolrException) {
                throw (SolrException)((Object)e);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            if (!success) {
                Object object3 = this.searcherLock;
                synchronized (object3) {
                    --this.onDeckSearchers;
                    if (this.onDeckSearchers < 0) {
                        log.error(this.logid + "ERROR!!! onDeckSearchers after decrement=" + this.onDeckSearchers);
                        this.onDeckSearchers = 0;
                    }
                    this.searcherLock.notify();
                }
                if (currSearcherHolder != null) {
                    currSearcherHolder.decref();
                }
                if (searchHolder != null) {
                    searchHolder.decref();
                    if (returnSearcher) {
                        searchHolder.decref();
                    }
                }
            }
            this.openSearcherLock.unlock();
        }
    }

    private RefCounted<SolrIndexSearcher> newHolder(SolrIndexSearcher newSearcher, final List<RefCounted<SolrIndexSearcher>> searcherList) {
        RefCounted<SolrIndexSearcher> holder = new RefCounted<SolrIndexSearcher>(newSearcher){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    Object object = SolrCore.this.searcherLock;
                    synchronized (object) {
                        if (this.refcount.get() > 0) {
                            return;
                        }
                        searcherList.remove(this);
                    }
                    ((SolrIndexSearcher)this.resource).close();
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error closing searcher:" + this), (Throwable)e);
                }
            }
        };
        holder.incref();
        return holder;
    }

    public boolean isReloaded() {
        return this.isReloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSearcher(RefCounted<SolrIndexSearcher> newSearcherHolder) {
        Object object = this.searcherLock;
        synchronized (object) {
            try {
                if (this._searcher == newSearcherHolder) {
                    newSearcherHolder.decref();
                    return;
                }
                if (this._searcher != null) {
                    this._searcher.decref();
                    this._searcher = null;
                }
                this._searcher = newSearcherHolder;
                SolrIndexSearcher newSearcher = newSearcherHolder.get();
                newSearcher.register();
                log.info(this.logid + "Registered new searcher " + newSearcher);
            }
            catch (Exception e) {
                SolrCore.log(e);
            }
            finally {
                --this.onDeckSearchers;
                this.searcherLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSearcher() {
        log.info(this.logid + "Closing main searcher on request.");
        Object object = this.searcherLock;
        synchronized (object) {
            if (this.realtimeSearcher != null) {
                this.realtimeSearcher.decref();
                this.realtimeSearcher = null;
            }
            if (this._searcher != null) {
                this._searcher.decref();
                this._searcher = null;
                this.infoRegistry.remove("currentSearcher");
            }
        }
    }

    public void execute(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        if (handler == null) {
            String msg = "Null Request Handler '" + req.getParams().get("qt") + "'";
            if (log.isWarnEnabled()) {
                log.warn(this.logid + msg + ":" + req);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        SolrCore.preDecorateResponse(req, rsp);
        if (requestLog.isDebugEnabled() && rsp.getToLog().size() > 0) {
            requestLog.debug(rsp.getToLogAsString(this.logid));
        }
        handler.handleRequest(req, rsp);
        SolrCore.postDecorateResponse(handler, req, rsp);
        if (rsp.getToLog().size() > 0) {
            long qtime;
            if (requestLog.isInfoEnabled()) {
                requestLog.info(rsp.getToLogAsString(this.logid));
            }
            if (log.isWarnEnabled() && this.slowQueryThresholdMillis >= 0 && (qtime = (long)req.getRequestTimer().getTime()) >= (long)this.slowQueryThresholdMillis) {
                log.warn("slow: " + rsp.getToLogAsString(this.logid));
            }
        }
    }

    public static void preDecorateResponse(SolrQueryRequest req, SolrQueryResponse rsp) {
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        rsp.addResponseHeader((NamedList<Object>)responseHeader);
        NamedList<Object> toLog = rsp.getToLog();
        toLog.add("webapp", req.getContext().get("webapp"));
        toLog.add("path", req.getContext().get("path"));
        SolrParams params = req.getParams();
        String lpList = params.get("logParamsList");
        if (lpList == null) {
            toLog.add("params", (Object)("{" + req.getParamString() + "}"));
        } else if (lpList.length() > 0) {
            toLog.add("params", (Object)("{" + params.toFilteredSolrParams(Arrays.asList(lpList.split(","))).toString() + "}"));
        }
    }

    public static void postDecorateResponse(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        String ep;
        NamedList<Object> responseHeader = rsp.getResponseHeader();
        int qtime = (int)req.getRequestTimer().getTime();
        int status = 0;
        Exception exception = rsp.getException();
        if (exception != null) {
            status = exception instanceof SolrException ? ((SolrException)((Object)exception)).code() : 500;
        }
        responseHeader.add("status", (Object)status);
        responseHeader.add("QTime", (Object)qtime);
        if (rsp.getToLog().size() > 0) {
            rsp.getToLog().add("status", (Object)status);
            rsp.getToLog().add("QTime", (Object)qtime);
        }
        SolrParams params = req.getParams();
        if (null != handler && params.getBool("echoHandler", false)) {
            responseHeader.add("handler", (Object)handler.getName());
        }
        if ((ep = params.get("echoParams", null)) != null) {
            CommonParams.EchoParamStyle echoParams = CommonParams.EchoParamStyle.get((String)ep);
            if (echoParams == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid value '" + ep + "' for " + "echoParams" + " parameter, use '" + CommonParams.EchoParamStyle.EXPLICIT + "' or '" + CommonParams.EchoParamStyle.ALL + "'");
            }
            if (echoParams == CommonParams.EchoParamStyle.EXPLICIT) {
                responseHeader.add("params", (Object)req.getOriginalParams().toNamedList());
            } else if (echoParams == CommonParams.EchoParamStyle.ALL) {
                responseHeader.add("params", (Object)req.getParams().toNamedList());
            }
        }
    }

    public static final void log(Throwable e) {
        SolrException.log((Logger)log, null, (Throwable)e);
    }

    public PluginBag<QueryResponseWriter> getResponseWriters() {
        return this.responseWriters;
    }

    private static BinaryResponseWriter getFileStreamWriter() {
        return new BinaryResponseWriter(){

            @Override
            public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse response) throws IOException {
                RawWriter rawWriter = (RawWriter)response.getValues().get("filestream");
                if (rawWriter != null) {
                    rawWriter.write(out);
                }
            }

            @Override
            public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
                return "application/octet-stream";
            }
        };
    }

    public MemClassLoader getMemClassLoader() {
        return this.memClassLoader;
    }

    private void initWriters() {
        this.responseWriters.init(DEFAULT_RESPONSE_WRITERS, this);
        if (this.responseWriters.getDefault() == null) {
            this.responseWriters.setDefault("standard");
        }
    }

    public final QueryResponseWriter getQueryResponseWriter(String writerName) {
        return this.responseWriters.get(writerName, true);
    }

    public final QueryResponseWriter getQueryResponseWriter(SolrQueryRequest request) {
        return this.getQueryResponseWriter(request.getParams().get("wt"));
    }

    public QParserPlugin getQueryPlugin(String parserName) {
        return this.qParserPlugins.get(parserName);
    }

    <T> Map<String, T> createInstances(Map<String, Class<? extends T>> map) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(map.size(), 1.0f);
        for (Map.Entry<String, Class<T>> e : map.entrySet()) {
            try {
                T o = this.getResourceLoader().newInstance(e.getValue().getName(), e.getValue());
                result.put(e.getKey(), o);
            }
            catch (Exception exp) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to instantiate class", (Throwable)exp);
            }
        }
        return result;
    }

    public TransformerFactory getTransformerFactory(String name) {
        return this.transformerFactories.get(name);
    }

    public void addTransformerFactory(String name, TransformerFactory factory) {
        this.transformerFactories.put(name, factory);
    }

    private <T> T initPlugins(Map<String, T> registry, Class<T> type, String defClassName) {
        return this.initPlugins(this.solrConfig.getPluginInfos(type.getName()), registry, type, defClassName);
    }

    public <T> T initPlugins(List<PluginInfo> pluginInfos, Map<String, T> registry, Class<T> type, String defClassName) {
        T def = null;
        for (PluginInfo info : pluginInfos) {
            T o = this.createInitInstance(info, type, type.getSimpleName(), defClassName);
            registry.put(info.name, o);
            if (!info.isDefault()) continue;
            def = o;
        }
        return def;
    }

    public <T> List<T> initPlugins(List<PluginInfo> pluginInfos, Class<T> type, String defClassName) {
        if (pluginInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(pluginInfos.size());
        for (PluginInfo info : pluginInfos) {
            result.add(this.createInitInstance(info, type, type.getSimpleName(), defClassName));
        }
        return result;
    }

    public <T> T initPlugins(Map<String, T> registry, Class<T> type) {
        return this.initPlugins(registry, type, null);
    }

    public ValueSourceParser getValueSourceParser(String parserName) {
        return this.valueSourceParsers.get(parserName);
    }

    private void initDeprecatedSupport() {
        String facetSort;
        String gettable = this.solrConfig.get("admin/gettableFiles", null);
        if (gettable != null) {
            log.warn("solrconfig.xml uses deprecated <admin/gettableFiles>, Please update your config to use the ShowFileRequestHandler.");
            if (this.getRequestHandler("/admin/file") == null) {
                NamedList invariants = new NamedList();
                HashSet<String> hide = new HashSet<String>();
                for (String file : this.solrConfig.getResourceLoader().listConfigDir()) {
                    hide.add(file.toUpperCase(Locale.ROOT));
                }
                StringTokenizer st = new StringTokenizer(gettable);
                while (st.hasMoreTokens()) {
                    hide.remove(st.nextToken().toUpperCase(Locale.ROOT));
                }
                for (String s : hide) {
                    invariants.add("hidden", (Object)s);
                }
                NamedList args = new NamedList();
                args.add("invariants", (Object)invariants);
                ShowFileRequestHandler handler = new ShowFileRequestHandler();
                handler.init(args);
                this.reqHandlers.register("/admin/file", handler);
                log.warn("adding ShowFileRequestHandler with hidden files: " + hide);
            }
        }
        if ((facetSort = this.solrConfig.get("//bool[@name='facet.sort']", null)) != null) {
            log.warn("solrconfig.xml uses deprecated <bool name='facet.sort'>. Please update your config to use <string name='facet.sort'>.");
        }
    }

    protected RestManager initRestManager() throws SolrException {
        PluginInfo restManagerPluginInfo = this.getSolrConfig().getPluginInfo(RestManager.class.getName());
        NamedList initArgs = null;
        RestManager mgr = null;
        if (restManagerPluginInfo != null) {
            if (restManagerPluginInfo.className != null) {
                mgr = this.resourceLoader.newInstance(restManagerPluginInfo.className, RestManager.class);
            }
            if (restManagerPluginInfo.initArgs != null) {
                initArgs = restManagerPluginInfo.initArgs;
            }
        }
        if (mgr == null) {
            mgr = new RestManager();
        }
        if (initArgs == null) {
            initArgs = new NamedList();
        }
        String collection = this.coreDescriptor.getCollectionName();
        ManagedResourceStorage.StorageIO storageIO = ManagedResourceStorage.newStorageIO(collection, this.resourceLoader, (NamedList<String>)initArgs);
        mgr.init(this.resourceLoader, (NamedList<String>)initArgs, storageIO);
        return mgr;
    }

    public CoreDescriptor getCoreDescriptor() {
        return this.coreDescriptor;
    }

    public IndexDeletionPolicyWrapper getDeletionPolicy() {
        return this.solrDelPolicy;
    }

    public ReentrantLock getRuleExpiryLock() {
        return this.ruleExpiryLock;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public String getDescription() {
        return "SolrCore";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CORE;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap(8);
        lst.add("coreName", (Object)(this.name == null ? "(null)" : this.name));
        lst.add("startTime", (Object)this.startTime);
        lst.add("refCount", (Object)this.getOpenCount());
        lst.add("instanceDir", (Object)this.resourceLoader.getInstancePath());
        lst.add("indexDir", (Object)this.getIndexDir());
        CoreDescriptor cd = this.getCoreDescriptor();
        if (cd != null) {
            CloudDescriptor cloudDesc;
            if (null != cd && cd.getCoreContainer() != null) {
                lst.add("aliases", this.getCoreDescriptor().getCoreContainer().getCoreNames(this));
            }
            if ((cloudDesc = cd.getCloudDescriptor()) != null) {
                String collection = cloudDesc.getCollectionName();
                if (collection == null) {
                    collection = "_notset_";
                }
                lst.add("collection", (Object)collection);
                String shard = cloudDesc.getShardId();
                if (shard == null) {
                    shard = "_auto_";
                }
                lst.add("shard", (Object)shard);
            }
        }
        return lst;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void unloadOnClose(boolean deleteIndexDir, boolean deleteDataDir, boolean deleteInstanceDir) {
        if (deleteIndexDir) {
            try {
                this.directoryFactory.remove(this.getIndexDir());
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Failed to flag index dir for removal for core:" + this.name + " dir:" + this.getIndexDir()));
            }
        }
        if (deleteDataDir) {
            try {
                this.directoryFactory.remove(this.getDataDir(), true);
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Failed to flag data dir for removal for core:" + this.name + " dir:" + this.getDataDir()));
            }
        }
        if (deleteInstanceDir) {
            this.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                }

                @Override
                public void postClose(SolrCore core) {
                    CoreDescriptor cd = core.getCoreDescriptor();
                    if (cd != null) {
                        try {
                            FileUtils.deleteDirectory((File)cd.getInstanceDir().toFile());
                        }
                        catch (IOException e) {
                            SolrException.log((Logger)log, (String)("Failed to delete instance dir for core:" + core.getName() + " dir:" + cd.getInstanceDir()));
                        }
                    }
                }
            });
        }
    }

    public static void deleteUnloadedCore(CoreDescriptor cd, boolean deleteDataDir, boolean deleteInstanceDir) {
        if (deleteDataDir) {
            File dataDir = new File(cd.getDataDir());
            try {
                FileUtils.deleteDirectory((File)dataDir);
            }
            catch (IOException e) {
                SolrException.log((Logger)log, (String)("Failed to delete data dir for unloaded core:" + cd.getName() + " dir:" + dataDir.getAbsolutePath()));
            }
        }
        if (deleteInstanceDir) {
            try {
                FileUtils.deleteDirectory((File)cd.getInstanceDir().toFile());
            }
            catch (IOException e) {
                SolrException.log((Logger)log, (String)("Failed to delete instance dir for unloaded core:" + cd.getName() + " dir:" + cd.getInstanceDir()));
            }
        }
    }

    public void addConfListener(Runnable runnable) {
        this.confListeners.add(runnable);
    }

    public boolean removeConfListener(Runnable runnable) {
        return this.confListeners.remove(runnable);
    }

    private void registerConfListener() {
        if (!(this.resourceLoader instanceof ZkSolrResourceLoader)) {
            return;
        }
        ZkSolrResourceLoader zkSolrResourceLoader = (ZkSolrResourceLoader)this.resourceLoader;
        if (zkSolrResourceLoader != null) {
            zkSolrResourceLoader.getZkController().registerConfListenerForCore(zkSolrResourceLoader.getConfigSetZkPath(), this, SolrCore.getConfListener(this, zkSolrResourceLoader));
        }
    }

    public static Runnable getConfListener(SolrCore core, ZkSolrResourceLoader zkSolrResourceLoader) {
        final String coreName = core.getName();
        final CoreContainer cc = core.getCoreDescriptor().getCoreContainer();
        final String overlayPath = zkSolrResourceLoader.getConfigSetZkPath() + "/" + "configoverlay.json";
        final String solrConfigPath = zkSolrResourceLoader.getConfigSetZkPath() + "/" + core.getSolrConfig().getName();
        String schemaRes = null;
        if (core.getLatestSchema().isMutable() && core.getLatestSchema() instanceof ManagedIndexSchema) {
            ManagedIndexSchema mis = (ManagedIndexSchema)core.getLatestSchema();
            schemaRes = mis.getResourceName();
        }
        final String managedSchmaResourcePath = schemaRes == null ? null : zkSolrResourceLoader.getConfigSetZkPath() + "/" + schemaRes;
        return new Runnable(){

            @Override
            public void run() {
                int overlayVersion;
                int solrConfigversion;
                log.info("config update listener called for core {}", (Object)coreName);
                SolrZkClient zkClient = cc.getZkController().getZkClient();
                int managedSchemaVersion = 0;
                SolrConfig cfg = null;
                try (SolrCore core = cc.solrCores.getCoreFromAnyList(coreName, true);){
                    if (core == null || core.isClosed()) {
                        return;
                    }
                    cfg = core.getSolrConfig();
                    solrConfigversion = core.getSolrConfig().getOverlay().getZnodeVersion();
                    overlayVersion = core.getSolrConfig().getZnodeVersion();
                    if (managedSchmaResourcePath != null) {
                        managedSchemaVersion = ((ManagedIndexSchema)core.getLatestSchema()).getSchemaZkVersion();
                    }
                }
                if (cfg != null) {
                    cfg.refreshRequestParams();
                }
                if (SolrCore.checkStale(zkClient, overlayPath, solrConfigversion) || SolrCore.checkStale(zkClient, solrConfigPath, overlayVersion) || SolrCore.checkStale(zkClient, managedSchmaResourcePath, managedSchemaVersion)) {
                    log.info("core reload {}", (Object)coreName);
                    cc.reload(coreName);
                    return;
                }
                core = cc.solrCores.getCoreFromAnyList(coreName, true);
                var7_5 = null;
                try {
                    if (core == null || core.isClosed()) {
                        return;
                    }
                    for (Runnable listener : core.confListeners) {
                        try {
                            listener.run();
                        }
                        catch (Exception e) {
                            log.error("Error in listener ", (Throwable)e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    var7_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (core != null) {
                        if (var7_5 != null) {
                            try {
                                core.close();
                            }
                            catch (Throwable x2) {
                                var7_5.addSuppressed(x2);
                            }
                        } else {
                            core.close();
                        }
                    }
                }
            }
        };
    }

    public void registerInfoBean(String name, SolrInfoMBean solrInfoMBean) {
        this.infoRegistry.put(name, solrInfoMBean);
    }

    private static boolean checkStale(SolrZkClient zkClient, String zkPath, int currentVersion) {
        if (zkPath == null) {
            return false;
        }
        try {
            Stat stat = zkClient.exists(zkPath, null, true);
            if (stat == null) {
                return currentVersion > -1;
            }
            if (stat.getVersion() > currentVersion) {
                log.info(zkPath + " is stale will need an update from {} to {}", (Object)currentVersion, (Object)stat.getVersion());
                return true;
            }
            return false;
        }
        catch (KeeperException.NoNodeException nne) {
        }
        catch (KeeperException e) {
            log.error("error refreshing solrconfig ", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public void cleanupOldIndexDirectories() {
        final DirectoryFactory myDirFactory = this.getDirectoryFactory();
        final String myDataDir = this.getDataDir();
        final String myIndexDir = this.getIndexDir();
        final String coreName = this.getName();
        if (myDirFactory != null && myDataDir != null && myIndexDir != null) {
            Thread cleanupThread = new Thread(){

                @Override
                public void run() {
                    log.info("Looking for old index directories to cleanup for core {} in {}", (Object)coreName, (Object)myDataDir);
                    try {
                        myDirFactory.cleanupOldIndexDirectories(myDataDir, myIndexDir);
                    }
                    catch (Exception exc) {
                        log.error("Failed to cleanup old index directories for core " + coreName, (Throwable)exc);
                    }
                }
            };
            cleanupThread.setName("OldIndexDirectoryCleanupThreadForCore-" + coreName);
            cleanupThread.setDaemon(true);
            cleanupThread.start();
        }
    }

    static {
        HashMap<String, QueryResponseWriter> m = new HashMap<String, QueryResponseWriter>(14, 1.0f);
        m.put("xml", new XMLResponseWriter());
        m.put("standard", (QueryResponseWriter)m.get("xml"));
        m.put("json", new JSONResponseWriter());
        m.put("python", new PythonResponseWriter());
        m.put("php", new PHPResponseWriter());
        m.put("phps", new PHPSerializedResponseWriter());
        m.put("ruby", new RubyResponseWriter());
        m.put("raw", new RawResponseWriter());
        m.put("javabin", new BinaryResponseWriter());
        m.put("csv", new CSVResponseWriter());
        m.put("xsort", new SortingResponseWriter());
        m.put("schema.xml", new SchemaXmlResponseWriter());
        m.put("smile", new SmileResponseWriter());
        m.put("filestream", SolrCore.getFileStreamWriter());
        DEFAULT_RESPONSE_WRITERS = Collections.unmodifiableMap(m);
    }

    public static interface RawWriter {
        public void write(OutputStream var1) throws IOException;
    }
}

