/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySenderListener
extends AbstractSolrEventListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public QuerySenderListener(SolrCore core) {
        super(core);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        final SolrIndexSearcher searcher = newSearcher;
        log.info("QuerySenderListener sending requests to " + newSearcher);
        List allLists = (List)this.getArgs().get("queries");
        if (allLists == null) {
            return;
        }
        for (NamedList nlst : allLists) {
            SolrQueryRequest req = null;
            try {
                NamedList params = this.addEventParms(currentSearcher, nlst);
                if (params.get("distrib") == null) {
                    params.add("distrib", (Object)false);
                }
                req = new LocalSolrQueryRequest(this.getCore(), params){

                    @Override
                    public SolrIndexSearcher getSearcher() {
                        return searcher;
                    }

                    @Override
                    public void close() {
                    }
                };
                SolrQueryResponse rsp = new SolrQueryResponse();
                SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
                this.getCore().execute(this.getCore().getRequestHandler(req.getParams().get("qt")), req, rsp);
                NamedList values = rsp.getValues();
                for (int i = 0; i < values.size(); ++i) {
                    Object o = values.getVal(i);
                    if (o instanceof ResultContext) {
                        o = ((ResultContext)o).docs;
                    }
                    if (!(o instanceof DocList)) continue;
                    DocList docs = (DocList)o;
                    DocIterator iter = docs.iterator();
                    while (iter.hasNext()) {
                        newSearcher.doc(iter.nextDoc());
                    }
                }
            }
            catch (Exception e) {}
            continue;
            finally {
                if (req != null) {
                    req.close();
                }
                SolrRequestInfo.clearRequestInfo();
            }
        }
        log.info("QuerySenderListener done.");
    }
}

