/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreDescriptor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String CORE_NAME = "name";
    public static final String CORE_CONFIG = "config";
    public static final String CORE_DATADIR = "dataDir";
    public static final String CORE_ULOGDIR = "ulogDir";
    public static final String CORE_SCHEMA = "schema";
    public static final String CORE_SHARD = "shard";
    public static final String CORE_COLLECTION = "collection";
    public static final String CORE_ROLES = "roles";
    public static final String CORE_PROPERTIES = "properties";
    public static final String CORE_LOADONSTARTUP = "loadOnStartup";
    public static final String CORE_TRANSIENT = "transient";
    public static final String CORE_NODE_NAME = "coreNodeName";
    public static final String CORE_CONFIGSET = "configSet";
    public static final String CORE_CONFIGSET_PROPERTIES = "configSetProperties";
    public static final String SOLR_CORE_PROP_PREFIX = "solr.core.";
    public static final String DEFAULT_EXTERNAL_PROPERTIES_FILE = "conf" + File.separator + "solrcore.properties";
    private static ImmutableMap<String, String> defaultProperties = new ImmutableMap.Builder().put((Object)"config", (Object)"solrconfig.xml").put((Object)"schema", (Object)"schema.xml").put((Object)"configSetProperties", (Object)"configsetprops.json").put((Object)"dataDir", (Object)("data" + File.separator)).put((Object)"transient", (Object)"false").put((Object)"loadOnStartup", (Object)"true").build();
    private static ImmutableList<String> requiredProperties = ImmutableList.of((Object)"name");
    public static ImmutableList<String> standardPropNames = ImmutableList.of((Object)"name", (Object)"config", (Object)"dataDir", (Object)"ulogDir", (Object)"schema", (Object)"properties", (Object)"configSetProperties", (Object)"loadOnStartup", (Object)"transient", (Object)"configSet", (Object)"shard", (Object)"collection", (Object[])new String[]{"roles", "coreNodeName", "numShards"});
    private final CoreContainer coreContainer;
    private final CloudDescriptor cloudDesc;
    private final Path instanceDir;
    protected final Properties originalCoreProperties = new Properties();
    protected final Properties originalExtraProperties = new Properties();
    protected final Properties coreProperties = new Properties();
    protected final Properties substitutableProperties = new Properties();

    public Properties getPersistableStandardProperties() {
        return this.originalCoreProperties;
    }

    public Properties getPersistableUserProperties() {
        return this.originalExtraProperties;
    }

    public CoreDescriptor(CoreContainer container, String name, Path instanceDir, String ... properties) {
        this(container, name, instanceDir, CoreDescriptor.toMap(properties));
    }

    private static Map<String, String> toMap(String ... properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        assert (properties.length % 2 == 0);
        for (int i = 0; i < properties.length; i += 2) {
            props.put(properties[i], properties[i + 1]);
        }
        return props;
    }

    public CoreDescriptor(CoreContainer container, String name, Path instanceDir) {
        this(container, name, instanceDir, Collections.emptyMap());
    }

    public CoreDescriptor(String coreName, CoreDescriptor other) {
        this.coreContainer = other.coreContainer;
        this.cloudDesc = other.cloudDesc;
        this.instanceDir = other.instanceDir;
        this.originalExtraProperties.putAll((Map<?, ?>)other.originalExtraProperties);
        this.originalCoreProperties.putAll((Map<?, ?>)other.originalCoreProperties);
        this.coreProperties.putAll((Map<?, ?>)other.coreProperties);
        this.substitutableProperties.putAll((Map<?, ?>)other.substitutableProperties);
        this.coreProperties.setProperty(CORE_NAME, coreName);
        this.originalCoreProperties.setProperty(CORE_NAME, coreName);
        this.substitutableProperties.setProperty("solr.core.name", coreName);
    }

    public CoreDescriptor(CoreContainer container, String name, Path instanceDir, Map<String, String> coreProps) {
        this.coreContainer = container;
        this.instanceDir = instanceDir;
        this.originalCoreProperties.setProperty(CORE_NAME, name);
        Properties containerProperties = container.getContainerProperties();
        name = PropertiesUtil.substituteProperty(CoreDescriptor.checkPropertyIsNotEmpty(name, CORE_NAME), containerProperties);
        this.coreProperties.putAll((Map<?, ?>)defaultProperties);
        this.coreProperties.put(CORE_NAME, name);
        for (String propname : coreProps.keySet()) {
            String propvalue = coreProps.get(propname);
            if (CoreDescriptor.isUserDefinedProperty(propname)) {
                this.originalExtraProperties.put(propname, propvalue);
            } else {
                this.originalCoreProperties.put(propname, propvalue);
            }
            if (requiredProperties.contains((Object)propname)) continue;
            this.coreProperties.setProperty(propname, PropertiesUtil.substituteProperty(propvalue, containerProperties));
        }
        this.loadExtraProperties();
        this.buildSubstitutableProperties();
        this.cloudDesc = container.isZooKeeperAware() ? new CloudDescriptor(name, this.coreProperties, this) : null;
        log.info("Created CoreDescriptor: " + this.coreProperties);
    }

    protected void loadExtraProperties() {
        String filename = this.coreProperties.getProperty(CORE_PROPERTIES, DEFAULT_EXTERNAL_PROPERTIES_FILE);
        Path propertiesFile = this.instanceDir.resolve(filename);
        if (Files.exists(propertiesFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(propertiesFile, new OpenOption[0]);){
                Properties externalProps = new Properties();
                externalProps.load(new InputStreamReader(is, StandardCharsets.UTF_8));
                this.coreProperties.putAll((Map<?, ?>)externalProps);
            }
            catch (IOException e) {
                String message = String.format(Locale.ROOT, "Could not load properties from %s: %s:", propertiesFile.toString(), e.toString());
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message);
            }
        }
    }

    protected void buildSubstitutableProperties() {
        for (String propName : this.coreProperties.stringPropertyNames()) {
            String propValue = this.coreProperties.getProperty(propName);
            if (!CoreDescriptor.isUserDefinedProperty(propName)) {
                propName = SOLR_CORE_PROP_PREFIX + propName;
            }
            this.substitutableProperties.setProperty(propName, propValue);
        }
    }

    protected static boolean isUserDefinedProperty(String propName) {
        return !standardPropNames.contains((Object)propName);
    }

    public static String checkPropertyIsNotEmpty(String value, String propName) {
        if (StringUtils.isEmpty((String)value)) {
            String message = String.format(Locale.ROOT, "Cannot create core with empty %s value", propName);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message);
        }
        return value;
    }

    public String getPropertiesName() {
        return this.coreProperties.getProperty(CORE_PROPERTIES);
    }

    public String getDataDir() {
        return this.coreProperties.getProperty(CORE_DATADIR);
    }

    public boolean usingDefaultDataDir() {
        return ((String)defaultProperties.get((Object)CORE_DATADIR)).equals(this.coreProperties.getProperty(CORE_DATADIR));
    }

    public Path getInstanceDir() {
        return this.instanceDir;
    }

    public String getConfigName() {
        return this.coreProperties.getProperty(CORE_CONFIG);
    }

    public String getSchemaName() {
        return this.coreProperties.getProperty(CORE_SCHEMA);
    }

    public String getName() {
        return this.coreProperties.getProperty(CORE_NAME);
    }

    public String getCollectionName() {
        return this.cloudDesc == null ? null : this.cloudDesc.getCollectionName();
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    public CloudDescriptor getCloudDescriptor() {
        return this.cloudDesc;
    }

    public boolean isLoadOnStartup() {
        String tmp = this.coreProperties.getProperty(CORE_LOADONSTARTUP, "false");
        return Boolean.parseBoolean(tmp);
    }

    public boolean isTransient() {
        String tmp = this.coreProperties.getProperty(CORE_TRANSIENT, "false");
        return PropertiesUtil.toBoolean(tmp);
    }

    public String getUlogDir() {
        return this.coreProperties.getProperty(CORE_ULOGDIR);
    }

    public String getCoreProperty(String prop, String defVal) {
        return this.coreProperties.getProperty(prop, defVal);
    }

    public Properties getSubstitutableProperties() {
        return this.substitutableProperties;
    }

    public String toString() {
        return "CoreDescriptor[name=" + this.getName() + ";instanceDir=" + this.getInstanceDir() + "]";
    }

    public String getConfigSet() {
        return this.coreProperties.getProperty(CORE_CONFIGSET);
    }

    public String getConfigSetPropertiesName() {
        return this.coreProperties.getProperty(CORE_CONFIGSET_PROPERTIES);
    }
}

