/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.util.Version;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.SystemIdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    static final XPathFactory xpathFactory = XPathFactory.newInstance();
    private final Document doc;
    private final Document origDoc;
    private final String prefix;
    private final String name;
    private final SolrResourceLoader loader;
    private int zkVersion = -1;
    private static final AtomicBoolean versionWarningAlreadyLogged = new AtomicBoolean(false);

    public Config(SolrResourceLoader loader, String name) throws ParserConfigurationException, IOException, SAXException {
        this(loader, name, null, null);
    }

    public Config(SolrResourceLoader loader, String name, InputSource is, String prefix) throws ParserConfigurationException, IOException, SAXException {
        this(loader, name, is, prefix, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config(SolrResourceLoader loader, String name, InputSource is, String prefix, boolean substituteProps) throws ParserConfigurationException, IOException, SAXException {
        if (loader == null) {
            loader = new SolrResourceLoader(SolrResourceLoader.locateSolrHome());
        }
        this.loader = loader;
        this.name = name;
        this.prefix = prefix != null && !prefix.endsWith("/") ? prefix + '/' : prefix;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            if (is == null) {
                InputStream in = loader.openConfig(name);
                if (in instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
                    this.zkVersion = ((ZkSolrResourceLoader.ZkByteArrayInputStream)in).getStat().getVersion();
                    log.info("loaded config {} with version {} ", (Object)name, (Object)this.zkVersion);
                }
                is = new InputSource(in);
                is.setSystemId(SystemIdResolver.createSystemIdFromResourceName(name));
            }
            if (is.getSystemId() != null) {
                try {
                    dbf.setXIncludeAware(true);
                    dbf.setNamespaceAware(true);
                }
                catch (UnsupportedOperationException e) {
                    log.warn(name + " XML parser doesn't support XInclude option");
                }
            }
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new SystemIdResolver(loader));
            db.setErrorHandler((ErrorHandler)xmllog);
            try {
                this.doc = db.parse(is);
                this.origDoc = Config.copyDoc(this.doc);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is.getByteStream());
            }
            if (substituteProps) {
                DOMUtil.substituteProperties(this.doc, this.getSubstituteProperties());
            }
        }
        catch (ParserConfigurationException | TransformerException | SAXException e) {
            SolrException.log((Logger)log, (String)("Exception during parsing file: " + name), (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public static void assertWarnOrFail(String reason, boolean assertCondition, boolean failCondition) {
        if (assertCondition) {
            return;
        }
        if (failCondition) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, reason);
        }
        log.warn(reason);
    }

    protected Properties getSubstituteProperties() {
        return this.loader.getCoreProperties();
    }

    public Config(SolrResourceLoader loader, String name, Document doc) {
        this.prefix = null;
        this.doc = doc;
        try {
            this.origDoc = Config.copyDoc(doc);
        }
        catch (TransformerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        this.name = name;
        this.loader = loader;
    }

    private static Document copyDoc(Document doc) throws TransformerException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer tx = tfactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        DOMResult result = new DOMResult();
        tx.transform(source, result);
        return (Document)result.getNode();
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public String getResourceName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Document getDocument() {
        return this.doc;
    }

    public XPath getXPath() {
        return xpathFactory.newXPath();
    }

    private String normalize(String path) {
        return this.prefix == null || path.startsWith("/") ? path : this.prefix + path;
    }

    public void substituteProperties() {
        DOMUtil.substituteProperties(this.doc, this.getSubstituteProperties());
    }

    public Object evaluate(String path, QName type) {
        XPath xpath = xpathFactory.newXPath();
        try {
            String xstr = this.normalize(path);
            Object o = xpath.evaluate(xstr, this.doc, type);
            return o;
        }
        catch (XPathExpressionException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + path + " for " + this.name, (Throwable)e);
        }
    }

    public Node getNode(String path, boolean errifMissing) {
        return this.getNode(path, this.doc, errifMissing);
    }

    public Node getUnsubstitutedNode(String path, boolean errIfMissing) {
        return this.getNode(path, this.origDoc, errIfMissing);
    }

    public Node getNode(String path, Document doc, boolean errIfMissing) {
        XPath xpath = xpathFactory.newXPath();
        String xstr = this.normalize(path);
        try {
            NodeList nodes = (NodeList)xpath.evaluate(xstr, doc, XPathConstants.NODESET);
            if (nodes == null || 0 == nodes.getLength()) {
                if (errIfMissing) {
                    throw new RuntimeException(this.name + " missing " + path);
                }
                log.debug(this.name + " missing optional " + path);
                return null;
            }
            if (1 < nodes.getLength()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.name + " contains more than one value for config path: " + path);
            }
            Node nd = nodes.item(0);
            log.trace(this.name + ":" + path + "=" + nd);
            return nd;
        }
        catch (XPathExpressionException e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e);
        }
    }

    public NodeList getNodeList(String path, boolean errIfMissing) {
        XPath xpath = xpathFactory.newXPath();
        String xstr = this.normalize(path);
        try {
            NodeList nodeList = (NodeList)xpath.evaluate(xstr, this.doc, XPathConstants.NODESET);
            if (null == nodeList) {
                if (errIfMissing) {
                    throw new RuntimeException(this.name + " missing " + path);
                }
                log.debug(this.name + " missing optional " + path);
                return null;
            }
            log.trace(this.name + ":" + path + "=" + nodeList);
            return nodeList;
        }
        catch (XPathExpressionException e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e);
        }
    }

    public Set<String> getUnknownAttributes(Element element, String ... knownAttributes) {
        HashSet<String> knownAttributeSet = new HashSet<String>(Arrays.asList(knownAttributes));
        HashSet<String> unknownAttributeSet = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.item(i).getNodeName();
            if (knownAttributeSet.contains(attributeName)) continue;
            if (null == unknownAttributeSet) {
                unknownAttributeSet = new HashSet<String>();
            }
            unknownAttributeSet.add(attributeName);
        }
        return unknownAttributeSet;
    }

    public void complainAboutUnknownAttributes(String elementXpath, String ... knownAttributes) {
        TreeMap<String, TreeSet<String>> problems = new TreeMap<String, TreeSet<String>>();
        NodeList nodeList = this.getNodeList(elementXpath, false);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Set<String> unknownAttributes = this.getUnknownAttributes(element, knownAttributes);
            if (null == unknownAttributes) continue;
            String elementName = element.getNodeName();
            TreeSet<String> allUnknownAttributes = (TreeSet<String>)problems.get(elementName);
            if (null == allUnknownAttributes) {
                allUnknownAttributes = new TreeSet<String>();
                problems.put(elementName, allUnknownAttributes);
            }
            allUnknownAttributes.addAll(unknownAttributes);
        }
        if (problems.size() > 0) {
            StringBuilder message = new StringBuilder();
            for (Map.Entry entry : problems.entrySet()) {
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append('<');
                message.append((String)entry.getKey());
                for (String attributeName : (SortedSet)entry.getValue()) {
                    message.append(' ');
                    message.append(attributeName);
                    message.append("=\"...\"");
                }
                message.append('>');
            }
            message.insert(0, "Unknown attribute(s) on element(s): ");
            String msg = message.toString();
            SolrException.log((Logger)log, (String)msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
    }

    public String getVal(String path, boolean errIfMissing) {
        Node nd = this.getNode(path, errIfMissing);
        if (nd == null) {
            return null;
        }
        String txt = DOMUtil.getText(nd);
        log.debug(this.name + ' ' + path + '=' + txt);
        return txt;
    }

    public String get(String path) {
        return this.getVal(path, true);
    }

    public String get(String path, String def) {
        String val = this.getVal(path, false);
        if (val == null || val.length() == 0) {
            return def;
        }
        return val;
    }

    public int getInt(String path) {
        return Integer.parseInt(this.getVal(path, true));
    }

    public int getInt(String path, int def) {
        String val = this.getVal(path, false);
        return val != null ? Integer.parseInt(val) : def;
    }

    public boolean getBool(String path) {
        return Boolean.parseBoolean(this.getVal(path, true));
    }

    public boolean getBool(String path, boolean def) {
        String val = this.getVal(path, false);
        return val != null ? Boolean.parseBoolean(val) : def;
    }

    public float getFloat(String path) {
        return Float.parseFloat(this.getVal(path, true));
    }

    public float getFloat(String path, float def) {
        String val = this.getVal(path, false);
        return val != null ? Float.parseFloat(val) : def;
    }

    public double getDouble(String path) {
        return Double.parseDouble(this.getVal(path, true));
    }

    public double getDouble(String path, double def) {
        String val = this.getVal(path, false);
        return val != null ? Double.parseDouble(val) : def;
    }

    public Version getLuceneVersion(String path) {
        return Config.parseLuceneVersionString(this.getVal(path, true));
    }

    public Version getLuceneVersion(String path, Version def) {
        String val = this.getVal(path, false);
        return val != null ? Config.parseLuceneVersionString(val) : def;
    }

    public static final Version parseLuceneVersionString(String matchVersion) {
        Version version;
        try {
            version = Version.parseLeniently((String)matchVersion);
        }
        catch (ParseException pe) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid luceneMatchVersion.  Should be of the form 'V.V.V' (e.g. 4.8.0)", (Throwable)pe);
        }
        if (version == Version.LATEST && !versionWarningAlreadyLogged.getAndSet(true)) {
            log.warn("You should not use LATEST as luceneMatchVersion property: if you use this setting, and then Solr upgrades to a newer release of Lucene, sizable changes may happen. If precise back compatibility is important then you should instead explicitly specify an actual Lucene version.");
        }
        return version;
    }

    public int getZnodeVersion() {
        return this.zkVersion;
    }

    public Config getOriginalConfig() {
        return new Config(this.loader, null, this.origDoc);
    }
}

