/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.rule;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.cloud.rule.Snitch;
import org.apache.solr.cloud.rule.SnitchContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaAssigner {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    List<Rule> rules;
    Map<String, Integer> shardVsReplicaCount;
    Map<String, Map<String, Object>> nodeVsTags;
    Map<String, HashMap<String, Integer>> shardVsNodes;
    List<String> liveNodes;
    Set<String> tagNames = new HashSet<String>();
    private Map<String, AtomicInteger> nodeVsCores = new HashMap<String, AtomicInteger>();
    public Map<String, SnitchContext> failedNodes = new HashMap<String, SnitchContext>();

    public ReplicaAssigner(List<Rule> rules, Map<String, Integer> shardVsReplicaCount, List snitches, Map<String, Map<String, Integer>> shardVsNodes, List<String> liveNodes, CoreContainer cc, ClusterState clusterState) {
        this.rules = rules;
        for (Rule rule : rules) {
            this.tagNames.add(rule.tag.name);
        }
        this.shardVsReplicaCount = shardVsReplicaCount;
        this.liveNodes = new ArrayList<String>(liveNodes);
        this.nodeVsTags = this.getTagsForNodes(cc, snitches);
        this.shardVsNodes = Utils.getDeepCopy(shardVsNodes, (int)2);
        this.validateTags(this.nodeVsTags);
        if (clusterState != null) {
            for (String s : clusterState.getCollections()) {
                DocCollection coll = clusterState.getCollection(s);
                for (Slice slice : coll.getSlices()) {
                    for (Replica replica : slice.getReplicas()) {
                        AtomicInteger count = this.nodeVsCores.get(replica.getNodeName());
                        if (count == null) {
                            count = new AtomicInteger();
                            this.nodeVsCores.put(replica.getNodeName(), count);
                        }
                        count.incrementAndGet();
                    }
                }
            }
        }
    }

    public Map<String, Map<String, Object>> getNodeVsTags() {
        return this.nodeVsTags;
    }

    public Map<Position, String> getNodeMappings() {
        Map<Position, String> result = this.getNodeMappings0();
        if (result == null) {
            String msg = "Could not identify nodes matching the rules " + this.rules;
            if (!this.failedNodes.isEmpty()) {
                HashMap<String, String> failedNodes = new HashMap<String, String>();
                for (Map.Entry<String, SnitchContext> e : this.failedNodes.entrySet()) {
                    failedNodes.put(e.getKey(), e.getValue().getErrMsg());
                }
                msg = msg + " Some nodes where excluded from assigning replicas because tags could not be obtained from them " + failedNodes;
            }
            msg = msg + "\n tag values" + Utils.toJSONString(this.getNodeVsTags());
            if (!this.shardVsNodes.isEmpty()) {
                msg = msg + "\nInitial state for the coll : " + Utils.toJSONString(this.shardVsNodes);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        return result;
    }

    Map<Position, String> getNodeMappings0() {
        ArrayList<String> shardNames = new ArrayList<String>(this.shardVsReplicaCount.keySet());
        int[] shardOrder = new int[shardNames.size()];
        for (int i = 0; i < shardNames.size(); ++i) {
            shardOrder[i] = i;
        }
        boolean hasFuzzyRules = false;
        int nonWildCardShardRules = 0;
        for (Rule r : this.rules) {
            if (r.isFuzzy()) {
                hasFuzzyRules = true;
            }
            if (r.shard.isWildCard()) continue;
            ++nonWildCardShardRules;
            if (shardNames.size() <= 10) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Max 10 shards allowed if there is a non wild card shard specified in rule");
        }
        Map<Position, String> result = this.tryAllPermutations(shardNames, shardOrder, nonWildCardShardRules, false);
        if (result == null && hasFuzzyRules) {
            result = this.tryAllPermutations(shardNames, shardOrder, nonWildCardShardRules, true);
        }
        return result;
    }

    private Map<Position, String> tryAllPermutations(List<String> shardNames, int[] shardOrder, int nonWildCardShardRules, boolean fuzzyPhase) {
        Iterator<int[]> shardPermutations;
        Iterator<int[]> iterator = shardPermutations = nonWildCardShardRules > 0 ? ReplicaAssigner.permutations(shardNames.size()) : Collections.singletonList(shardOrder).iterator();
        while (shardPermutations.hasNext()) {
            int[] p = shardPermutations.next();
            for (int i = 0; i < p.length; ++i) {
                ArrayList<Position> positions = new ArrayList<Position>();
                for (int pos : p) {
                    for (int j = 0; j < this.shardVsReplicaCount.get(shardNames.get(pos)); ++j) {
                        positions.add(new Position(shardNames.get(pos), j));
                    }
                }
                Collections.sort(positions);
                Iterator<int[]> it = ReplicaAssigner.permutations(this.rules.size());
                while (it.hasNext()) {
                    int[] permutation = it.next();
                    Map<Position, String> result = this.tryAPermutationOfRules(permutation, positions, fuzzyPhase);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    private Map<Position, String> tryAPermutationOfRules(final int[] rulePermutation, List<Position> positions, boolean fuzzyPhase) {
        final Map nodeVsTagsCopy = Utils.getDeepCopy(this.nodeVsTags, (int)2);
        LinkedHashMap<Position, String> result = new LinkedHashMap<Position, String>();
        int startPosition = 0;
        final Map copyOfCurrentState = Utils.getDeepCopy(this.shardVsNodes, (int)2);
        ArrayList<String> sortedLiveNodes = new ArrayList<String>(this.liveNodes);
        Collections.sort(sortedLiveNodes, new Comparator<String>(){

            @Override
            public int compare(String n1, String n2) {
                int result = 0;
                for (int i = 0; i < rulePermutation.length; ++i) {
                    int b;
                    Rule rule = ReplicaAssigner.this.rules.get(rulePermutation[i]);
                    int val = rule.compare(n1, n2, nodeVsTagsCopy, copyOfCurrentState);
                    if (val != 0) {
                        result = val;
                        break;
                    }
                    if (result != 0) continue;
                    AtomicInteger n1Count = (AtomicInteger)ReplicaAssigner.this.nodeVsCores.get(n1);
                    AtomicInteger n2Count = (AtomicInteger)ReplicaAssigner.this.nodeVsCores.get(n2);
                    int a = n1Count == null ? 0 : n1Count.get();
                    int n = b = n2Count == null ? 0 : n2Count.get();
                    result = a > b ? 1 : (a == b ? 0 : -1);
                }
                return result;
            }
        });
        block0: for (Position position : positions) {
            block1: for (int j = 0; j < sortedLiveNodes.size(); ++j) {
                Integer n;
                String liveNode = (String)sortedLiveNodes.get(startPosition % sortedLiveNodes.size());
                ++startPosition;
                for (int i = 0; i < rulePermutation.length; ++i) {
                    Rule rule = this.rules.get(rulePermutation[i]);
                    Rule.MatchStatus status = rule.tryAssignNodeToShard(liveNode, copyOfCurrentState, nodeVsTagsCopy, position.shard, fuzzyPhase ? Rule.Phase.FUZZY_ASSIGN : Rule.Phase.ASSIGN);
                    if (status == Rule.MatchStatus.CANNOT_ASSIGN_FAIL) continue block1;
                }
                result.put(position, liveNode);
                HashMap<String, Integer> nodeNames = (HashMap<String, Integer>)copyOfCurrentState.get(position.shard);
                if (nodeNames == null) {
                    nodeNames = new HashMap<String, Integer>();
                    copyOfCurrentState.put(position.shard, nodeNames);
                }
                n = (n = (Integer)nodeNames.get(liveNode)) == null ? 1 : n + 1;
                nodeNames.put(liveNode, n);
                Number coreCount = (Number)((Map)nodeVsTagsCopy.get(liveNode)).get("cores");
                if (coreCount == null) continue block0;
                ((Map)nodeVsTagsCopy.get(liveNode)).put("cores", coreCount.intValue() + 1);
                continue block0;
            }
            return null;
        }
        if (positions.size() > result.size()) {
            return null;
        }
        for (Map.Entry entry : result.entrySet()) {
            for (int i = 0; i < rulePermutation.length; ++i) {
                Rule rule = this.rules.get(rulePermutation[i]);
                Rule.MatchStatus matchStatus = rule.tryAssignNodeToShard((String)entry.getValue(), copyOfCurrentState, nodeVsTagsCopy, ((Position)entry.getKey()).shard, fuzzyPhase ? Rule.Phase.FUZZY_VERIFY : Rule.Phase.VERIFY);
                if (matchStatus == Rule.MatchStatus.NODE_CAN_BE_ASSIGNED) continue;
                return null;
            }
        }
        return result;
    }

    private void validateTags(Map<String, Map<String, Object>> nodeVsTags) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Rule rule : this.rules) {
            for (Map.Entry<String, Map<String, Object>> e : nodeVsTags.entrySet()) {
                if (e.getValue().get(rule.tag.name) != null) continue;
                errors.add(StrUtils.formatString((String)"The value for tag {0} is not available for node {1}", (Object[])new Object[]{rule.tag.name, e.getKey()}));
            }
        }
        if (!errors.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.join(errors, (char)','));
        }
    }

    public static Iterator<int[]> permutations(final int level) {
        return new Iterator<int[]>(){
            int i = 0;
            int[] next;

            @Override
            public boolean hasNext() {
                AtomicReference nthval = new AtomicReference();
                ReplicaAssigner.permute(0, new int[level], new BitSet(level), nthval, this.i, new AtomicInteger());
                ++this.i;
                this.next = (int[])nthval.get();
                return this.next != null;
            }

            @Override
            public int[] next() {
                return this.next;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static void permute(int level, int[] permuted, BitSet used, AtomicReference<int[]> nthval, int requestedIdx, AtomicInteger seenSoFar) {
        if (level == permuted.length) {
            if (seenSoFar.get() == requestedIdx) {
                nthval.set(permuted);
            } else {
                seenSoFar.incrementAndGet();
            }
        } else {
            for (int i = 0; i < permuted.length; ++i) {
                if (used.get(i)) continue;
                used.set(i);
                permuted[level] = i;
                ReplicaAssigner.permute(level + 1, permuted, used, nthval, requestedIdx, seenSoFar);
                if (nthval.get() != null) break;
                used.set(i, false);
            }
        }
    }

    private Map<String, Map<String, Object>> getTagsForNodes(CoreContainer cc, List snitchConf) {
        Map<Class, SnitchInfoImpl> snitches = ReplicaAssigner.getSnitchInfos(cc, snitchConf);
        for (Class c : Snitch.WELL_KNOWN_SNITCHES) {
            if (snitches.containsKey(c)) continue;
            try {
                snitches.put(c, new SnitchInfoImpl(Collections.EMPTY_MAP, (Snitch)c.newInstance(), cc));
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error instantiating Snitch " + c.getName());
            }
        }
        for (String tagName : this.tagNames) {
            boolean foundProvider = false;
            for (SnitchInfoImpl snitchInfoImpl : snitches.values()) {
                if (!snitchInfoImpl.snitch.isKnownTag(tagName)) continue;
                foundProvider = true;
                snitchInfoImpl.myTags.add(tagName);
                break;
            }
            if (foundProvider) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown tag in rules " + tagName);
        }
        for (String node : this.liveNodes) {
            for (SnitchInfoImpl info : snitches.values()) {
                if (info.myTags.isEmpty()) continue;
                SnitchContext snitchContext = new SnitchContext(info, node);
                info.nodeVsContext.put(node, snitchContext);
                try {
                    info.snitch.getTags(node, info.myTags, snitchContext);
                }
                catch (Exception e) {
                    snitchContext.exception = e;
                }
            }
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (SnitchInfoImpl info : snitches.values()) {
            for (Map.Entry entry : info.nodeVsContext.entrySet()) {
                SnitchContext context = (SnitchContext)entry.getValue();
                String node = (String)entry.getKey();
                if (context.exception != null) {
                    this.failedNodes.put(node, context);
                    this.liveNodes.remove(node);
                    log.warn("Not all tags were obtained from node " + node);
                    context.exception = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Not all tags were obtained from node " + node);
                    continue;
                }
                if (!context.getTags().keySet().containsAll(context.snitchInfo.getTagNames())) continue;
                HashMap<String, Object> tags = (HashMap<String, Object>)result.get(node);
                if (tags == null) {
                    tags = new HashMap<String, Object>();
                    result.put(node, tags);
                }
                tags.putAll(context.getTags());
            }
        }
        if (this.liveNodes.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not get all tags for any nodes");
        }
        return result;
    }

    public static void verifySnitchConf(CoreContainer cc, List snitchConf) {
        ReplicaAssigner.getSnitchInfos(cc, snitchConf);
    }

    static Map<Class, SnitchInfoImpl> getSnitchInfos(CoreContainer cc, List snitchConf) {
        if (snitchConf == null) {
            snitchConf = Collections.emptyList();
        }
        LinkedHashMap<Class, SnitchInfoImpl> snitches = new LinkedHashMap<Class, SnitchInfoImpl>();
        for (Object o : snitchConf) {
            String klas = null;
            Map map = Collections.emptyMap();
            if (o instanceof Map) {
                map = (Map)o;
                klas = (String)map.get("class");
                if (klas == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "snitch must have  a class attribute");
                }
            } else {
                klas = o.toString();
            }
            try {
                if (klas.indexOf(46) == -1) {
                    klas = Snitch.class.getPackage().getName() + "." + klas;
                }
                Snitch inst = cc == null ? (Snitch)Snitch.class.getClassLoader().loadClass(klas).newInstance() : cc.getResourceLoader().newInstance(klas, Snitch.class);
                snitches.put(inst.getClass(), new SnitchInfoImpl(map, inst, cc));
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        return snitches;
    }

    static class SnitchInfoImpl
    extends SnitchContext.SnitchInfo {
        final Snitch snitch;
        final Set<String> myTags = new HashSet<String>();
        final Map<String, SnitchContext> nodeVsContext = new HashMap<String, SnitchContext>();
        private final CoreContainer cc;

        SnitchInfoImpl(Map<String, Object> conf, Snitch snitch, CoreContainer cc) {
            super(conf);
            this.snitch = snitch;
            this.cc = cc;
        }

        @Override
        public Set<String> getTagNames() {
            return this.myTags;
        }

        @Override
        public CoreContainer getCoreContainer() {
            return this.cc;
        }
    }

    public static class Position
    implements Comparable<Position> {
        public final String shard;
        public final int index;

        public Position(String shard, int replicaIdx) {
            this.shard = shard;
            this.index = replicaIdx;
        }

        @Override
        public int compareTo(Position that) {
            return that.index > this.index ? -1 : (that.index == this.index ? 0 : 1);
        }

        public String toString() {
            return this.shard + ":" + this.index;
        }
    }
}

