/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.util.stats.TimerContext;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedQueue {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String PREFIX = "qn-";
    private static final Object _IMPLEMENTATION_NOTES = null;
    final String dir;
    final SolrZkClient zookeeper;
    final Overseer.Stats stats;
    private final ReentrantLock updateLock = new ReentrantLock();
    private TreeSet<String> knownChildren = new TreeSet();
    private final Condition notEmpty = this.updateLock.newCondition();
    private ChildWatcher lastWatcher = null;
    private boolean isDirty = true;

    public DistributedQueue(SolrZkClient zookeeper, String dir) {
        this(zookeeper, dir, new Overseer.Stats());
    }

    public DistributedQueue(SolrZkClient zookeeper, String dir, Overseer.Stats stats) {
        this.dir = dir;
        ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zookeeper.getZkClientTimeout());
        try {
            cmdExecutor.ensureExists(dir, zookeeper);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        this.zookeeper = zookeeper;
        this.stats = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] peek() throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_peek");
        try {
            byte[] byArray = this.firstElement();
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    public byte[] peek(boolean block) throws KeeperException, InterruptedException {
        return block ? this.peek(Long.MAX_VALUE) : this.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] peek(long wait) throws KeeperException, InterruptedException {
        Preconditions.checkArgument((wait > 0L ? 1 : 0) != 0);
        TimerContext time = wait == Long.MAX_VALUE ? this.stats.time(this.dir + "_peek_wait_forever") : this.stats.time(this.dir + "_peek_wait" + wait);
        this.updateLock.lockInterruptibly();
        try {
            long waitNanos = TimeUnit.MILLISECONDS.toNanos(wait);
            while (waitNanos > 0L) {
                byte[] result = this.firstElement();
                if (result != null) {
                    byte[] byArray = result;
                    return byArray;
                }
                waitNanos = this.notEmpty.awaitNanos(waitNanos);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.updateLock.unlock();
            time.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] poll() throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_poll");
        try {
            byte[] byArray = this.removeFirst();
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] remove() throws NoSuchElementException, KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_remove");
        try {
            byte[] result = this.removeFirst();
            if (result == null) {
                throw new NoSuchElementException();
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    public byte[] take() throws KeeperException, InterruptedException {
        TimerContext timer = this.stats.time(this.dir + "_take");
        this.updateLock.lockInterruptibly();
        try {
            while (true) {
                byte[] result;
                if ((result = this.removeFirst()) != null) {
                    byte[] byArray = result;
                    return byArray;
                }
                this.notEmpty.await();
            }
        }
        finally {
            this.updateLock.unlock();
            timer.stop();
        }
    }

    public void offer(byte[] data) throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_offer");
        while (true) {
            try {
                this.zookeeper.create(this.dir + "/" + PREFIX, data, CreateMode.PERSISTENT_SEQUENTIAL, true);
                return;
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    this.zookeeper.create(this.dir, new byte[0], CreateMode.PERSISTENT, true);
                }
                catch (KeeperException.NodeExistsException ne) {}
                continue;
            }
            break;
        }
        finally {
            time.stop();
        }
    }

    public Overseer.Stats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String firstChild(boolean remove) throws KeeperException, InterruptedException {
        this.updateLock.lockInterruptibly();
        try {
            if (!this.knownChildren.isEmpty()) {
                String string = remove ? this.knownChildren.pollFirst() : this.knownChildren.first();
                return string;
            }
            if (this.lastWatcher != null && !this.isDirty) {
                String string = null;
                return string;
            }
            ChildWatcher newWatcher = new ChildWatcher();
            this.knownChildren = this.fetchZkChildren(newWatcher);
            this.lastWatcher = newWatcher;
            this.isDirty = false;
            if (this.knownChildren.isEmpty()) {
                String string = null;
                return string;
            }
            this.notEmpty.signalAll();
            String string = remove ? this.knownChildren.pollFirst() : this.knownChildren.first();
            return string;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    TreeSet<String> fetchZkChildren(Watcher watcher) throws InterruptedException, KeeperException {
        while (true) {
            try {
                TreeSet<String> orderedChildren = new TreeSet<String>();
                List childNames = this.zookeeper.getChildren(this.dir, watcher, true);
                this.stats.setQueueLength(childNames.size());
                for (String childName : childNames) {
                    if (!childName.regionMatches(0, PREFIX, 0, PREFIX.length())) {
                        LOG.debug("Found child node with improper name: " + childName);
                        continue;
                    }
                    orderedChildren.add(childName);
                }
                return orderedChildren;
            }
            catch (KeeperException.NoNodeException e) {
                this.zookeeper.create(this.dir, new byte[0], CreateMode.PERSISTENT, true);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedSet<String> getChildren(long waitMillis) throws KeeperException, InterruptedException {
        long waitNanos = TimeUnit.MILLISECONDS.toNanos(waitMillis);
        while (waitNanos > 0L) {
            this.firstElement();
            this.updateLock.lockInterruptibly();
            try {
                if (!this.knownChildren.isEmpty()) {
                    TreeSet<String> treeSet = new TreeSet<String>((SortedSet<String>)this.knownChildren);
                    return treeSet;
                }
                waitNanos = this.notEmpty.awaitNanos(waitNanos);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        return ImmutableSortedSet.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] firstElement() throws KeeperException, InterruptedException {
        String firstChild;
        while ((firstChild = this.firstChild(false)) != null) {
            try {
                return this.zookeeper.getData(this.dir + "/" + firstChild, null, null, true);
            }
            catch (KeeperException.NoNodeException e) {
                this.updateLock.lockInterruptibly();
                try {
                    this.knownChildren.remove(firstChild);
                    continue;
                }
                finally {
                    this.updateLock.unlock();
                    continue;
                }
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] removeFirst() throws KeeperException, InterruptedException {
        String firstChild;
        while ((firstChild = this.firstChild(true)) != null) {
            try {
                String path = this.dir + "/" + firstChild;
                byte[] result = this.zookeeper.getData(path, null, null, true);
                this.zookeeper.delete(path, -1, true);
                return result;
            }
            catch (KeeperException.NoNodeException e) {
                this.updateLock.lockInterruptibly();
                try {
                    this.knownChildren.remove(firstChild);
                    continue;
                }
                finally {
                    this.updateLock.unlock();
                    continue;
                }
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean hasWatcher() throws InterruptedException {
        this.updateLock.lockInterruptibly();
        try {
            boolean bl = this.lastWatcher != null;
            return bl;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private class ChildWatcher
    implements Watcher {
        private ChildWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            DistributedQueue.this.updateLock.lock();
            try {
                if (DistributedQueue.this.lastWatcher == this) {
                    DistributedQueue.this.lastWatcher = null;
                }
                DistributedQueue.this.isDirty = true;
                DistributedQueue.this.notEmpty.signalAll();
            }
            finally {
                DistributedQueue.this.updateLock.unlock();
            }
        }
    }
}

