/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.StoppedSessionException;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSession
implements ValidatingSession,
Serializable {
    private static final long serialVersionUID = -7125642695178165650L;
    private static final transient Logger log = LoggerFactory.getLogger(SimpleSession.class);
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected static final long MILLIS_PER_MINUTE = 60000L;
    protected static final long MILLIS_PER_HOUR = 3600000L;
    static int bitIndexCounter = 0;
    private static final int ID_BIT_MASK = 1 << bitIndexCounter++;
    private static final int START_TIMESTAMP_BIT_MASK = 1 << bitIndexCounter++;
    private static final int STOP_TIMESTAMP_BIT_MASK = 1 << bitIndexCounter++;
    private static final int LAST_ACCESS_TIME_BIT_MASK = 1 << bitIndexCounter++;
    private static final int TIMEOUT_BIT_MASK = 1 << bitIndexCounter++;
    private static final int EXPIRED_BIT_MASK = 1 << bitIndexCounter++;
    private static final int HOST_BIT_MASK = 1 << bitIndexCounter++;
    private static final int ATTRIBUTES_BIT_MASK = 1 << bitIndexCounter++;
    private Serializable id;
    private Date startTimestamp;
    private Date stopTimestamp;
    private Date lastAccessTime = this.startTimestamp = new Date();
    private long timeout = 1800000L;
    private boolean expired;
    private String host;
    private Map<Object, Object> attributes;

    public SimpleSession() {
    }

    public SimpleSession(String host) {
        this();
        this.host = host;
    }

    @Override
    public Serializable getId() {
        return this.id;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    @Override
    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getStopTimestamp() {
        return this.stopTimestamp;
    }

    public void setStopTimestamp(Date stopTimestamp) {
        this.stopTimestamp = stopTimestamp;
    }

    @Override
    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<Object, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void touch() {
        this.lastAccessTime = new Date();
    }

    @Override
    public void stop() {
        if (this.stopTimestamp == null) {
            this.stopTimestamp = new Date();
        }
    }

    protected boolean isStopped() {
        return this.getStopTimestamp() != null;
    }

    protected void expire() {
        this.stop();
        this.expired = true;
    }

    @Override
    public boolean isValid() {
        return !this.isStopped() && !this.isExpired();
    }

    protected boolean isTimedOut() {
        if (this.isExpired()) {
            return true;
        }
        long timeout = this.getTimeout();
        if (timeout >= 0L) {
            Date lastAccessTime = this.getLastAccessTime();
            if (lastAccessTime == null) {
                String msg = "session.lastAccessTime for session with id [" + this.getId() + "] is null.  This value must be set at " + "least once, preferably at least upon instantiation.  Please check the " + this.getClass().getName() + " implementation and ensure " + "this value will be set (perhaps in the constructor?)";
                throw new IllegalStateException(msg);
            }
            long expireTimeMillis = System.currentTimeMillis() - timeout;
            Date expireTime = new Date(expireTimeMillis);
            return lastAccessTime.before(expireTime);
        }
        if (log.isTraceEnabled()) {
            log.trace("No timeout for session with id [" + this.getId() + "].  Session is not considered expired.");
        }
        return false;
    }

    @Override
    public void validate() throws InvalidSessionException {
        if (this.isStopped()) {
            String msg = "Session with id [" + this.getId() + "] has been " + "explicitly stopped.  No further interaction under this session is " + "allowed.";
            throw new StoppedSessionException(msg);
        }
        if (this.isTimedOut()) {
            this.expire();
            Date lastAccessTime = this.getLastAccessTime();
            long timeout = this.getTimeout();
            Serializable sessionId = this.getId();
            DateFormat df = DateFormat.getInstance();
            String msg = "Session with id [" + sessionId + "] has expired. " + "Last access time: " + df.format(lastAccessTime) + ".  Current time: " + df.format(new Date()) + ".  Session timeout is set to " + timeout / 1000L + " seconds (" + timeout / 60000L + " minutes)";
            if (log.isTraceEnabled()) {
                log.trace(msg);
            }
            throw new ExpiredSessionException(msg);
        }
    }

    private Map<Object, Object> getAttributesLazy() {
        Map<Object, Object> attributes = this.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<Object, Object>();
            this.setAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        Map<Object, Object> attributes = this.getAttributes();
        if (attributes == null) {
            return Collections.emptySet();
        }
        return attributes.keySet();
    }

    @Override
    public Object getAttribute(Object key) {
        Map<Object, Object> attributes = this.getAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.get(key);
    }

    @Override
    public void setAttribute(Object key, Object value) {
        if (value == null) {
            this.removeAttribute(key);
        } else {
            this.getAttributesLazy().put(key, value);
        }
    }

    @Override
    public Object removeAttribute(Object key) {
        Map<Object, Object> attributes = this.getAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.remove(key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SimpleSession) {
            SimpleSession other = (SimpleSession)obj;
            Serializable thisId = this.getId();
            Serializable otherId = other.getId();
            if (thisId != null && otherId != null) {
                return thisId.equals(otherId);
            }
            return this.onEquals(other);
        }
        return false;
    }

    protected boolean onEquals(SimpleSession ss) {
        return (this.getStartTimestamp() != null ? this.getStartTimestamp().equals(ss.getStartTimestamp()) : ss.getStartTimestamp() == null) && (this.getStopTimestamp() != null ? this.getStopTimestamp().equals(ss.getStopTimestamp()) : ss.getStopTimestamp() == null) && (this.getLastAccessTime() != null ? this.getLastAccessTime().equals(ss.getLastAccessTime()) : ss.getLastAccessTime() == null) && this.getTimeout() == ss.getTimeout() && this.isExpired() == ss.isExpired() && (this.getHost() != null ? this.getHost().equals(ss.getHost()) : ss.getHost() == null) && (this.getAttributes() != null ? ((Object)this.getAttributes()).equals(ss.getAttributes()) : ss.getAttributes() == null);
    }

    public int hashCode() {
        Serializable id = this.getId();
        if (id != null) {
            return id.hashCode();
        }
        int hashCode = this.getStartTimestamp() != null ? this.getStartTimestamp().hashCode() : 0;
        hashCode = 31 * hashCode + (this.getStopTimestamp() != null ? this.getStopTimestamp().hashCode() : 0);
        hashCode = 31 * hashCode + (this.getLastAccessTime() != null ? this.getLastAccessTime().hashCode() : 0);
        hashCode = 31 * hashCode + Long.valueOf(Math.max(this.getTimeout(), 0L)).hashCode();
        hashCode = 31 * hashCode + Boolean.valueOf(this.isExpired()).hashCode();
        hashCode = 31 * hashCode + (this.getHost() != null ? this.getHost().hashCode() : 0);
        hashCode = 31 * hashCode + (this.getAttributes() != null ? ((Object)this.getAttributes()).hashCode() : 0);
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(",id=").append(this.getId());
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        short alteredFieldsBitMask = this.getAlteredFieldsBitMask();
        out.writeShort(alteredFieldsBitMask);
        if (this.id != null) {
            out.writeObject(this.id);
        }
        if (this.startTimestamp != null) {
            out.writeObject(this.startTimestamp);
        }
        if (this.stopTimestamp != null) {
            out.writeObject(this.stopTimestamp);
        }
        if (this.lastAccessTime != null) {
            out.writeObject(this.lastAccessTime);
        }
        if (this.timeout != 0L) {
            out.writeLong(this.timeout);
        }
        if (this.expired) {
            out.writeBoolean(this.expired);
        }
        if (this.host != null) {
            out.writeUTF(this.host);
        }
        if (!CollectionUtils.isEmpty(this.attributes)) {
            out.writeObject(this.attributes);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        short bitMask = in.readShort();
        if (SimpleSession.isFieldPresent(bitMask, ID_BIT_MASK)) {
            this.id = (Serializable)in.readObject();
        }
        if (SimpleSession.isFieldPresent(bitMask, START_TIMESTAMP_BIT_MASK)) {
            this.startTimestamp = (Date)in.readObject();
        }
        if (SimpleSession.isFieldPresent(bitMask, STOP_TIMESTAMP_BIT_MASK)) {
            this.stopTimestamp = (Date)in.readObject();
        }
        if (SimpleSession.isFieldPresent(bitMask, LAST_ACCESS_TIME_BIT_MASK)) {
            this.lastAccessTime = (Date)in.readObject();
        }
        if (SimpleSession.isFieldPresent(bitMask, TIMEOUT_BIT_MASK)) {
            this.timeout = in.readLong();
        }
        if (SimpleSession.isFieldPresent(bitMask, EXPIRED_BIT_MASK)) {
            this.expired = in.readBoolean();
        }
        if (SimpleSession.isFieldPresent(bitMask, HOST_BIT_MASK)) {
            this.host = in.readUTF();
        }
        if (SimpleSession.isFieldPresent(bitMask, ATTRIBUTES_BIT_MASK)) {
            this.attributes = (Map)in.readObject();
        }
    }

    private short getAlteredFieldsBitMask() {
        int bitMask = 0;
        bitMask = this.id != null ? bitMask | ID_BIT_MASK : bitMask;
        bitMask = this.startTimestamp != null ? bitMask | START_TIMESTAMP_BIT_MASK : bitMask;
        bitMask = this.stopTimestamp != null ? bitMask | STOP_TIMESTAMP_BIT_MASK : bitMask;
        bitMask = this.lastAccessTime != null ? bitMask | LAST_ACCESS_TIME_BIT_MASK : bitMask;
        bitMask = this.timeout != 0L ? bitMask | TIMEOUT_BIT_MASK : bitMask;
        bitMask = this.expired ? bitMask | EXPIRED_BIT_MASK : bitMask;
        bitMask = this.host != null ? bitMask | HOST_BIT_MASK : bitMask;
        bitMask = !CollectionUtils.isEmpty(this.attributes) ? bitMask | ATTRIBUTES_BIT_MASK : bitMask;
        return (short)bitMask;
    }

    private static boolean isFieldPresent(short bitMask, int fieldBitMask) {
        return (bitMask & fieldBitMask) != 0;
    }
}

