/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.rat.document.IDocument;
import org.apache.rat.document.IDocumentCollection;
import org.apache.rat.document.impl.DocumentImplUtils;
import org.apache.rat.document.impl.zip.ZipDocumentFactory;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.RatReportFailedException;

class FilesReportable
implements IReportable {
    private final File basedir;
    private final String[] files;

    FilesReportable(File basedir, String[] files) throws IOException {
        File currentDir = new File(System.getProperty("user.dir")).getCanonicalFile();
        File f = basedir.getCanonicalFile();
        this.basedir = currentDir.equals(f) ? null : basedir;
        this.files = files;
    }

    public void run(RatReport report) throws RatReportFailedException {
        FileDocument document = new FileDocument();
        for (int i = 0; i < this.files.length; ++i) {
            document.setFile(new File(this.basedir, this.files[i]));
            report.report((IDocument)document);
        }
    }

    private class FileDocument
    implements IDocument {
        private File file;

        private FileDocument() {
        }

        void setFile(File file) {
            this.file = file;
        }

        public IDocumentCollection readArchive() throws IOException {
            return ZipDocumentFactory.load((File)this.file);
        }

        public Reader reader() throws IOException {
            FileInputStream in = new FileInputStream(this.file);
            return new InputStreamReader(in);
        }

        public String getName() {
            return DocumentImplUtils.toName((File)this.file);
        }
    }
}

